/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.item;

import com.charles445.simpledifficulty.config.ModConfig;
import com.charles445.simpledifficulty.item.ItemDrinkBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemJuice
extends ItemDrinkBase {
    public ItemJuice() {
        this.func_77627_a(true);
    }

    @Override
    public void runSecondaryEffect(EntityPlayer player, ItemStack stack) {
        JuiceEnum type = this.getEnumForStack(stack);
        if (type == JuiceEnum.GOLDEN_APPLE && ModConfig.server.miscellaneous.goldenAppleJuiceEffect) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100, 1));
            player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 2400, 0));
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (JuiceEnum juice : JuiceEnum.values()) {
                items.add((Object)new ItemStack((Item)this, 1, juice.ordinal()));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        return "item.simpledifficulty:juice_" + this.getEnumForStack(stack).toString();
    }

    @Override
    public int getThirstLevel(ItemStack stack) {
        return this.getEnumForStack(stack).getThirstLevel();
    }

    @Override
    public float getSaturationLevel(ItemStack stack) {
        return this.getEnumForStack(stack).getSaturation();
    }

    @Override
    public float getDirtyChance(ItemStack stack) {
        return this.getEnumForStack(stack).getDirtyChance();
    }

    protected JuiceEnum getEnumForStack(ItemStack stack) {
        if (stack.func_77960_j() >= JuiceEnum.values().length) {
            return JuiceEnum.values()[0];
        }
        return JuiceEnum.values()[stack.func_77960_j()];
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        JuiceEnum type = this.getEnumForStack(stack);
        if (type == JuiceEnum.GOLDEN_APPLE || type == JuiceEnum.GOLDEN_CARROT || type == JuiceEnum.GOLDEN_MELON) {
            return true;
        }
        return super.func_77636_d(stack);
    }

    public static enum JuiceEnum {
        APPLE("apple", 8, 6.4f),
        BEETROOT("beetroot", 10, 8.0f),
        CACTUS("cactus", 9, 2.7f),
        CARROT("carrot", 8, 4.8f),
        CHORUS_FRUIT("chorus_fruit", 12, 7.2f),
        GOLDEN_APPLE("golden_apple", 20, 20.0f),
        GOLDEN_CARROT("golden_carrot", 14, 14.0f),
        GOLDEN_MELON("golden_melon", 16, 16.0f),
        MELON("melon", 8, 4.0f),
        PUMPKIN("pumpkin", 7, 4.9f);

        private String name;
        private int thirst;
        private float saturation;

        public String getName() {
            return this.name;
        }

        public int getThirstLevel() {
            return this.thirst;
        }

        public float getSaturation() {
            return this.saturation;
        }

        public float getDirtyChance() {
            return 0.0f;
        }

        private JuiceEnum(String name, int thirst, float saturation) {
            this.name = name;
            this.thirst = thirst;
            this.saturation = saturation;
        }

        public String toString() {
            return this.getName();
        }
    }
}

