/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.api.config.json;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class JsonItemIdentity {
    public int metadata;
    @Nullable
    public String nbt;
    @Nullable
    private NBTTagCompound nbtCompound;

    public JsonItemIdentity(int metadata) {
        this(metadata, null);
    }

    public JsonItemIdentity(int metadata, String nbt) {
        this.metadata = metadata;
        this.nbt = nbt;
        this.tryPopulateCompound();
    }

    public void tryPopulateCompound() {
        if (this.nbtCompound == null) {
            if (this.nbt == null) {
                this.nbtCompound = null;
            } else {
                try {
                    this.nbtCompound = JsonToNBT.func_180713_a((String)this.nbt);
                    if (this.nbtCompound == null) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    this.nbtCompound = null;
                    this.nbt = null;
                }
            }
        }
    }

    public boolean matches(ItemStack stack) {
        if (stack.func_77942_o()) {
            return this.matches(stack.func_77960_j(), stack.func_77978_p());
        }
        return this.matches(stack.func_77960_j(), null);
    }

    public boolean matches(int stackMetadata) {
        return this.matches(stackMetadata, null);
    }

    public boolean matches(JsonItemIdentity sentIdentity) {
        return this.matches(sentIdentity.metadata, sentIdentity.nbtCompound);
    }

    public boolean matches(int stackMetadata, @Nullable NBTTagCompound stackCompound) {
        if (this.metadata == -1 || this.metadata == Short.MAX_VALUE || this.metadata == stackMetadata) {
            if (this.nbt == null || this.nbt.isEmpty()) {
                return true;
            }
            this.tryPopulateCompound();
            return this.checkNestedCompound(this.nbtCompound, stackCompound);
        }
        return false;
    }

    private boolean checkNestedCompound(NBTTagCompound selfCompound, NBTTagCompound stackCompound) {
        if (stackCompound == null) {
            return false;
        }
        for (String key : selfCompound.func_150296_c()) {
            NBTBase a = selfCompound.func_74781_a(key);
            NBTBase b = stackCompound.func_74781_a(key);
            if (a != null) {
                if (a instanceof NBTTagCompound && b instanceof NBTTagCompound) {
                    if (this.checkNestedCompound((NBTTagCompound)a, (NBTTagCompound)b)) continue;
                    return false;
                }
                if (a.equals((Object)b)) continue;
                return false;
            }
            if (b == null) continue;
            return false;
        }
        return true;
    }
}

