/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.tileentity;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.gui.SummoningPedestalScreen;
import com.lycanitesmobs.core.block.BlockSummoningPedestal;
import com.lycanitesmobs.core.container.SummoningPedestalContainer;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.EntityItemCustom;
import com.lycanitesmobs.core.entity.PortalEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.network.MessageSummoningPedestalStats;
import com.lycanitesmobs.core.network.MessageSummoningPedestalSummonSet;
import com.lycanitesmobs.core.pets.SummonSet;
import com.lycanitesmobs.core.tileentity.TileEntityBase;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class TileEntitySummoningPedestal
extends TileEntityBase {
    public long updateTick = 0L;
    public PortalEntity summoningPortal;
    public UUID ownerUUID;
    public String ownerName = "";
    public SummonSet summonSet;
    public int summonAmount = 1;
    public int capacityCharge = 100;
    public int capacity = 0;
    public int capacityMax = this.capacityCharge * 10;
    public int summonProgress = 0;
    public int summonProgressMax = 180;
    public String inventoryName = "";
    public NonNullList<ItemStack> itemStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    public int summoningFuel = 0;
    public int summoningFuelMax = 12000;
    public int summoningFuelAmount = 12000;
    public List<BaseCreatureEntity> minions = new ArrayList<BaseCreatureEntity>();
    protected String[] loadMinionIDs;
    protected boolean blockStateSet = false;

    public TileEntitySummoningPedestal() {
        this.summoningFuelAmount = LycanitesMobs.config.getInt("Player", "Summoning Pedestal Redstone Time", this.summoningFuelAmount, "How much summoning time (in ticks) 1 redstone dust provides. 20 ticks = 1 second, default is 12000 (10 minutes).");
    }

    @Override
    public void onRemove() {
        if (this.summoningPortal != null && !this.summoningPortal.field_70128_L) {
            this.summoningPortal.func_70106_y();
        }
        for (ItemStack itemStack : this.itemStacks) {
            EntityItemCustom entityItem = new EntityItemCustom(this.func_145831_w(), this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o() + 0.5, this.func_174877_v().func_177952_p(), itemStack);
            this.func_145831_w().func_72838_d((Entity)entityItem);
        }
        this.func_174888_l();
        super.onRemove();
    }

    @Override
    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            if (this.summoningFuel > 0) {
                if (this.summonProgress >= this.summonProgressMax) {
                    this.summonProgress = 0;
                } else if (this.summonProgress > 0) {
                    ++this.summonProgress;
                }
            }
            return;
        }
        if (this.loadMinionIDs != null) {
            int range = 20;
            List nearbyEntities = this.func_145831_w().func_72872_a(BaseCreatureEntity.class, new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - range), (double)(this.func_174877_v().func_177956_o() - range), (double)(this.func_174877_v().func_177952_p() - range), (double)(this.func_174877_v().func_177958_n() + range), (double)(this.func_174877_v().func_177956_o() + range), (double)(this.func_174877_v().func_177952_p() + range)));
            block2: for (BaseCreatureEntity possibleEntity : nearbyEntities) {
                for (String loadMinionID : this.loadMinionIDs) {
                    UUID uuid = null;
                    try {
                        uuid = UUID.fromString(loadMinionID);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!possibleEntity.func_110124_au().equals(uuid)) continue;
                    this.minions.add(possibleEntity);
                    continue block2;
                }
            }
            this.loadMinionIDs = null;
        }
        if (this.summonSet != null && this.summonSet.getCreatureInfo() != null) {
            if (this.summonSet.getFollowing()) {
                this.summonSet.following = false;
            }
            if (this.updateTick % 100L == 0L) {
                this.capacity = 0;
                for (BaseCreatureEntity minion : this.minions.toArray(new BaseCreatureEntity[this.minions.size()])) {
                    if (minion == null || minion.field_70128_L) {
                        this.minions.remove((Object)minion);
                        continue;
                    }
                    this.capacity += minion.creatureInfo.summonCost * this.capacityCharge;
                }
            }
            if (this.capacity + this.summonSet.getCreatureInfo().summonCost > this.capacityMax) {
                this.summonProgress = 0;
            } else {
                ItemStack fuelStack;
                if (this.summoningFuel <= 0 && !(fuelStack = this.func_70301_a(0)).func_190926_b()) {
                    int refuel = this.summoningFuelAmount;
                    if (fuelStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150451_bX)) {
                        refuel = this.summoningFuelAmount * 9;
                    }
                    fuelStack.func_190918_g(1);
                    this.summoningFuel = refuel;
                    this.summoningFuelMax = refuel;
                }
                if (this.summoningFuel > 0) {
                    --this.summoningFuel;
                    if (this.summoningPortal == null || this.summoningPortal.field_70128_L) {
                        this.summoningPortal = new PortalEntity(this.func_145831_w(), this);
                        this.summoningPortal.setProjectileScale(4.0f);
                        this.func_145831_w().func_72838_d((Entity)this.summoningPortal);
                    }
                    if (this.summonProgress++ >= this.summonProgressMax) {
                        this.summoningPortal.summonCreatures();
                        this.summonProgress = 0;
                        this.capacity = Math.min(this.capacity + this.capacityCharge * this.summonSet.getCreatureInfo().summonCost, this.capacityMax);
                    }
                }
            }
        }
        if (this.summoningFuel <= 0 && this.summoningPortal != null && !this.summoningPortal.field_70128_L) {
            this.summoningPortal.func_70106_y();
        }
        if (!this.blockStateSet) {
            if (!"".equals(this.getOwnerName())) {
                BlockSummoningPedestal.setState(BlockSummoningPedestal.EnumSummoningPedestal.PLAYER, this.func_145831_w(), this.func_174877_v());
            } else {
                BlockSummoningPedestal.setState(BlockSummoningPedestal.EnumSummoningPedestal.NONE, this.func_145831_w(), this.func_174877_v());
            }
            this.blockStateSet = true;
        }
        if (this.updateTick % 20L == 0L) {
            LycanitesMobs.packetHandler.sendToAllAround(new MessageSummoningPedestalStats(this.capacity, this.summonProgress, this.summoningFuel, this.summoningFuelMax, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()), new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 5.0));
        }
        ++this.updateTick;
    }

    public void setOwner(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)entity;
            this.ownerUUID = entityPlayer.func_110124_au();
            this.ownerName = entity.func_70005_c_();
        }
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public EntityPlayer getPlayer() {
        if (this.ownerUUID == null) {
            return null;
        }
        return this.func_145831_w().func_152378_a(this.ownerUUID);
    }

    public Class getSummonClass() {
        if (this.summonSet == null) {
            return null;
        }
        return this.summonSet.getCreatureClass();
    }

    public void setSummonSet(SummonSet summonSet) {
        if (this.getPlayer() != null && !summonSet.isUseable()) {
            return;
        }
        this.summonSet = new SummonSet(null);
        this.summonSet.setSummonType(summonSet.summonType);
        this.summonSet.sitting = summonSet.getSitting();
        this.summonSet.following = false;
        this.summonSet.passive = summonSet.getPassive();
        this.summonSet.aggressive = summonSet.getAggressive();
        this.summonSet.pvp = summonSet.getPVP();
    }

    public void applyMinionBehaviour(TameableCreatureEntity minion) {
        minion.fromSummoningPedestal = true;
        if (this.summonSet != null) {
            this.summonSet.applyBehaviour(minion);
            minion.setSubspecies(this.summonSet.subspecies);
            minion.applyVariant(this.summonSet.variant);
        }
        this.minions.add(minion);
        minion.setHome(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), 20.0f);
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.itemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.itemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.itemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.itemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.itemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public int func_70302_i_() {
        return this.itemStacks.size();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack itemStack) {
        return itemStack.func_77973_b() == Items.field_151137_ax || itemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150451_bX);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.itemStacks.clear();
    }

    public String func_70005_c_() {
        return this.inventoryName;
    }

    public boolean func_145818_k_() {
        return !"".equals(this.inventoryName);
    }

    @Override
    public boolean func_145842_c(int eventID, int eventArg) {
        return false;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound syncData = new NBTTagCompound();
        if (this.summonSet != null) {
            NBTTagCompound summonSetNBT = new NBTTagCompound();
            this.summonSet.writeToNBT(summonSetNBT);
            syncData.func_74782_a("SummonSet", (NBTBase)summonSetNBT);
        }
        if (!this.func_145831_w().field_72995_K && this.getOwnerUUID() != null && this.getOwnerName() != null) {
            syncData.func_74778_a("OwnerUUID", this.getOwnerUUID().toString());
            syncData.func_74778_a("OwnerName", this.getOwnerName());
            syncData.func_74778_a("InventoryName", this.func_70005_c_());
        }
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, syncData);
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        if (!this.func_145831_w().field_72995_K) {
            return;
        }
        NBTTagCompound syncData = packet.func_148857_g();
        if (syncData.func_74764_b("OwnerUUID")) {
            this.ownerUUID = UUID.fromString(syncData.func_74779_i("OwnerUUID"));
        }
        if (syncData.func_74764_b("OwnerName")) {
            this.ownerName = syncData.func_74779_i("OwnerName");
        }
        if (syncData.func_74764_b("InventoryName")) {
            this.inventoryName = syncData.func_74779_i("InventoryName");
        }
        if (syncData.func_74764_b("SummonSet")) {
            SummonSet summonSet = new SummonSet(null);
            summonSet.readFromNBT(syncData.func_74775_l("SummonSet"));
            this.summonSet = summonSet;
        }
    }

    public void sendSummonSetToServer(SummonSet summonSet) {
        LycanitesMobs.packetHandler.sendToServer(new MessageSummoningPedestalSummonSet(summonSet, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        String uuidString;
        super.func_145839_a(nbtTagCompound);
        this.ownerUUID = nbtTagCompound.func_74764_b("OwnerUUID") ? (!"".equals(uuidString = nbtTagCompound.func_74779_i("OwnerUUID")) ? UUID.fromString(uuidString) : null) : null;
        this.ownerName = nbtTagCompound.func_74764_b("OwnerName") ? nbtTagCompound.func_74779_i("OwnerName") : "";
        if (nbtTagCompound.func_74764_b("SummonSet")) {
            NBTTagCompound summonSetNBT = nbtTagCompound.func_74775_l("SummonSet");
            SummonSet summonSet = new SummonSet(null);
            summonSet.readFromNBT(summonSetNBT);
            this.summonSet = summonSet;
        } else {
            this.summonSet = null;
        }
        if (nbtTagCompound.func_74764_b("MinionIDs")) {
            NBTTagList minionIDs = nbtTagCompound.func_150295_c("MinionIDs", 10);
            this.loadMinionIDs = new String[minionIDs.func_74745_c()];
            for (int i = 0; i < minionIDs.func_74745_c(); ++i) {
                NBTTagCompound minionID = minionIDs.func_150305_b(i);
                if (!minionID.func_74764_b("ID")) continue;
                this.loadMinionIDs[i] = minionID.func_74779_i("ID");
            }
        }
        if (nbtTagCompound.func_74764_b("Fuel")) {
            this.summoningFuel = nbtTagCompound.func_74762_e("Fuel");
        }
        if (nbtTagCompound.func_74764_b("FuelMax")) {
            this.summoningFuelMax = nbtTagCompound.func_74762_e("FuelMax");
        }
        if (nbtTagCompound.func_74764_b("Items")) {
            NonNullList itemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)nbtTagCompound, (NonNullList)itemStacks);
            for (int i = 0; i < itemStacks.size(); ++i) {
                if (i >= this.func_70302_i_()) continue;
                ItemStack itemStack = (ItemStack)itemStacks.get(i);
                if (itemStack.func_190926_b()) {
                    this.func_70299_a(i, ItemStack.field_190927_a);
                    continue;
                }
                this.func_70299_a(i, itemStack);
            }
        }
        super.func_145839_a(nbtTagCompound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        if (this.ownerUUID == null) {
            nbtTagCompound.func_74778_a("OwnerUUID", "");
        } else {
            nbtTagCompound.func_74778_a("OwnerUUID", this.ownerUUID.toString());
        }
        if (this.summonSet != null) {
            NBTTagCompound summonSetNBT = new NBTTagCompound();
            this.summonSet.writeToNBT(summonSetNBT);
            nbtTagCompound.func_74782_a("SummonSet", (NBTBase)summonSetNBT);
        }
        nbtTagCompound.func_74778_a("OwnerName", this.ownerName);
        if (this.minions.size() > 0) {
            NBTTagList minionIDs = new NBTTagList();
            for (EntityLivingBase entityLivingBase : this.minions) {
                NBTTagCompound minionID = new NBTTagCompound();
                minionID.func_74778_a("ID", entityLivingBase.func_110124_au().toString());
                minionIDs.func_74742_a((NBTBase)minionID);
            }
            nbtTagCompound.func_74782_a("MinionIDs", (NBTBase)minionIDs);
        }
        nbtTagCompound.func_74768_a("Fuel", this.summoningFuel);
        nbtTagCompound.func_74768_a("FuelMax", this.summoningFuelMax);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbtTagCompound, this.itemStacks);
        return nbtTagCompound;
    }

    @Override
    public Object getGUI(EntityPlayer player) {
        if (this.func_145831_w().field_72995_K) {
            return new SummoningPedestalScreen(player, this);
        }
        return new SummoningPedestalContainer(this, player.field_71071_by);
    }
}

