/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner.trigger;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.spawner.Spawner;
import com.lycanitesmobs.core.spawner.trigger.SpawnTrigger;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldSpawnTrigger
extends SpawnTrigger {
    public double tickRate = 400.0;
    public double lastTickDistanceMin = -1.0;
    public double lastTickDistanceMax = -1.0;
    public boolean useWorldTime = false;

    public WorldSpawnTrigger(Spawner spawner) {
        super(spawner);
    }

    @Override
    public void loadFromJSON(JsonObject json) {
        if (json.has("tickRate")) {
            this.tickRate = json.get("tickRate").getAsDouble();
        }
        if (json.has("lastTickDistanceMin")) {
            this.lastTickDistanceMin = json.get("lastTickDistanceMin").getAsDouble();
        }
        if (json.has("lastTickDistanceMax")) {
            this.lastTickDistanceMax = json.get("lastTickDistanceMax").getAsDouble();
        }
        if (json.has("useWorldTime")) {
            this.useWorldTime = json.get("useWorldTime").getAsBoolean();
        }
        super.loadFromJSON(json);
    }

    public void onTick(World world, BlockPos position, long ticks) {
        if (this.useWorldTime && (double)(world.func_72820_D() % 24000L) != this.tickRate) {
            return;
        }
        if (ticks == 0L || (double)ticks % this.tickRate != 0.0) {
            return;
        }
        if (this.chance < 1.0 && world.field_73012_v.nextDouble() > this.chance) {
            return;
        }
        this.trigger(world, null, position, 0, 0);
    }
}

