/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner.location;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.helpers.JSONHelper;
import com.lycanitesmobs.core.spawner.location.SpawnLocation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;

public class BlockSpawnLocation
extends SpawnLocation {
    public List<String> blockIds = new ArrayList<String>();
    public String listType = "whitelist";
    public boolean surface = true;
    public boolean underground = true;
    public int blockCost = -1;
    public int requiredBlockTypes = 0;
    public Vec3i offset = new Vec3i(0, 0, 0);

    @Override
    public void loadFromJSON(JsonObject json) {
        if (json.has("blocks")) {
            this.blockIds = JSONHelper.getJsonStrings(json.get("blocks").getAsJsonArray());
        }
        if (json.has("listType")) {
            this.listType = json.get("listType").getAsString();
        }
        if (json.has("surface")) {
            this.surface = json.get("surface").getAsBoolean();
        }
        if (json.has("underground")) {
            this.underground = json.get("underground").getAsBoolean();
        }
        if (json.has("blockCost")) {
            this.blockCost = json.get("blockCost").getAsInt();
        }
        if (json.has("requiredBlockTypes")) {
            this.requiredBlockTypes = json.get("requiredBlockTypes").getAsInt();
        }
        this.offset = JSONHelper.getVec3i(json, "offset");
        super.loadFromJSON(json);
    }

    @Override
    public List<BlockPos> getSpawnPositions(World world, EntityPlayer player, BlockPos triggerPos) {
        ArrayList<BlockPos> spawnPositions = new ArrayList<BlockPos>();
        HashMap<Block, Integer> validBlocksFound = new HashMap<Block, Integer>();
        for (int y = triggerPos.func_177956_o() - this.rangeMax.func_177956_o(); y <= triggerPos.func_177956_o() + this.rangeMax.func_177956_o(); ++y) {
            int yMin = 0;
            if (this.yMin >= 0) {
                yMin = this.yMin;
            }
            if (y < yMin) {
                y = yMin;
            }
            int yMax = world.func_72940_L();
            if (this.yMax >= 0) {
                yMax = Math.min(this.yMax, yMax);
            }
            if (y >= yMax) break;
            for (int x = triggerPos.func_177958_n() - this.rangeMax.func_177958_n(); x <= triggerPos.func_177958_n() + this.rangeMax.func_177958_n(); ++x) {
                for (int z = triggerPos.func_177952_p() - this.rangeMax.func_177952_p(); z <= triggerPos.func_177952_p() + this.rangeMax.func_177952_p(); ++z) {
                    float filled;
                    BlockPos spawnPos = new BlockPos(x, y, z);
                    IBlockState blockState = world.func_180495_p(spawnPos);
                    if (blockState.func_177230_c() instanceof IFluidBlock && (filled = ((IFluidBlock)blockState.func_177230_c()).getFilledPercentage(world, spawnPos)) != 1.0f && filled != -1.0f || blockState.func_177230_c() instanceof BlockLiquid && blockState.func_177230_c().func_176201_c(blockState) != 0 || !this.isValidBlock(world, spawnPos)) continue;
                    spawnPositions.add(spawnPos.func_177971_a(this.offset));
                    if (this.requiredBlockTypes <= 0) continue;
                    Block block = world.func_180495_p(spawnPos).func_177230_c();
                    if (!validBlocksFound.containsKey(block)) {
                        validBlocksFound.put(block, 1);
                        continue;
                    }
                    validBlocksFound.put(block, (Integer)validBlocksFound.get(block) + 1);
                }
            }
        }
        if (this.blockCost > 0 && spawnPositions.size() < this.blockCost) {
            return new ArrayList<BlockPos>();
        }
        if (this.requiredBlockTypes > 0) {
            if (validBlocksFound.size() < this.blockIds.size()) {
                return new ArrayList<BlockPos>();
            }
            Iterator iterator = validBlocksFound.values().iterator();
            while (iterator.hasNext()) {
                int blocksFoundOfType = (Integer)iterator.next();
                if (blocksFoundOfType >= this.requiredBlockTypes) continue;
                return new ArrayList<BlockPos>();
            }
        }
        return this.sortSpawnPositions(spawnPositions, world, triggerPos);
    }

    public boolean isValidBlock(World world, BlockPos blockPos) {
        if (!(this.surface && this.underground || !(world.func_175678_i(blockPos) ? !this.surface : !this.underground))) {
            return false;
        }
        if (this.blockIds.isEmpty()) {
            return true;
        }
        Block block = world.func_180495_p(blockPos).func_177230_c();
        if ("blacklist".equalsIgnoreCase(this.listType)) {
            return !this.blockIds.contains(block.getRegistryName().toString());
        }
        return this.blockIds.contains(block.getRegistryName().toString());
    }
}

