/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment;

import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.helpers.JSONHelper;
import com.lycanitesmobs.core.info.ElementInfo;
import com.lycanitesmobs.core.info.ElementManager;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.item.ChargeItem;
import com.lycanitesmobs.core.item.ItemBase;
import com.lycanitesmobs.core.item.equipment.ItemEquipment;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.vecmath.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEquipmentPart
extends ItemBase {
    public static int BASE_LEVELUP_EXPERIENCE = 500;
    public static ItemStack ITEMSTACK_TO_RENDER;
    public static Map<String, List<ItemEquipmentPart>> MOB_PART_DROPS;
    public List<EquipmentFeature> features = new ArrayList<EquipmentFeature>();
    public List<ElementInfo> elements = new ArrayList<ElementInfo>();
    public String slotType;
    public String dropMobId;
    public float dropChance = 1.0f;
    public int levelMin = 1;
    public int levelMax = 3;

    public ItemEquipmentPart(ModInfo groupInfo) {
        this.modInfo = groupInfo;
        this.func_77625_d(1);
        this.func_77637_a(LycanitesMobs.equipmentPartsTab);
    }

    public void loadFromJSON(JsonObject json) {
        this.itemName = json.get("itemName").getAsString();
        this.slotType = json.get("slotType").getAsString();
        if (json.has("dropMobId")) {
            this.dropMobId = json.get("dropMobId").getAsString();
            if (!"".equals(this.dropMobId)) {
                if (!MOB_PART_DROPS.containsKey(this.dropMobId)) {
                    MOB_PART_DROPS.put(this.dropMobId, new ArrayList());
                }
                MOB_PART_DROPS.get(this.dropMobId).add(this);
            }
        }
        if (json.has("dropChance")) {
            this.dropChance = json.get("dropChance").getAsFloat();
        }
        if (json.has("levelMin")) {
            this.levelMin = json.get("levelMin").getAsInt();
        }
        if (json.has("levelMax")) {
            this.levelMax = json.get("levelMax").getAsInt();
        }
        List<Object> elementNames = new ArrayList();
        if (json.has("elements")) {
            elementNames = JSONHelper.getJsonStrings(json.get("elements").getAsJsonArray());
        }
        this.elements.clear();
        for (String elementName : elementNames) {
            ElementInfo element = ElementManager.getInstance().getElement(elementName);
            if (element == null) {
                throw new RuntimeException("[Equipment] Unable to initialise Equipment Part " + this.func_77658_a() + " as the element " + elementName + " cannot be found.");
            }
            this.elements.add(element);
        }
        if (json.has("features")) {
            JsonArray jsonArray = json.get("features").getAsJsonArray();
            Iterator jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                JsonObject featureJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                if (this.addFeature(EquipmentFeature.createFromJSON(featureJson))) continue;
                LycanitesMobs.logWarning("", "[Equipment] The feature " + featureJson.toString() + " was unable to be added, check the JSON format.");
            }
        }
        this.sortFeatures();
        this.setRegistryName(this.modInfo.modid, this.itemName);
        this.func_77655_b(this.itemName);
        AssetManager.addTexture(this.itemName, this.modInfo, "textures/equipment/" + this.itemName + ".png");
    }

    @Override
    public String func_77653_i(ItemStack itemStack) {
        String displayName = LanguageManager.translate(this.func_77667_c(itemStack) + ".name");
        displayName = displayName + " " + LanguageManager.translate("equipment.level") + " " + this.getLevel(itemStack);
        return displayName;
    }

    @Override
    public void func_77624_a(ItemStack itemStack, World world, List<String> tooltip, ITooltipFlag tooltipFlag) {
        super.func_77624_a(itemStack, world, tooltip, tooltipFlag);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        for (String description : this.getAdditionalDescriptions(itemStack, world, tooltipFlag)) {
            List formattedDescriptionList = fontRenderer.func_78271_c(description, DESCRIPTION_WIDTH);
            for (Object formattedDescription : formattedDescriptionList) {
                if (!(formattedDescription instanceof String)) continue;
                tooltip.add("\u00a73" + formattedDescription);
            }
        }
    }

    @Override
    public String getDescription(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        return LanguageManager.translate("item.equipmentpart.description");
    }

    public List<String> getAdditionalDescriptions(ItemStack itemStack, World world, ITooltipFlag tooltipFlag) {
        ArrayList<String> descriptions = new ArrayList<String>();
        int level = this.getLevel(itemStack);
        int experience = this.getExperience(itemStack);
        int experienceMax = this.getExperienceForNextLevel(itemStack);
        String baseFeature = LanguageManager.translate("equipment.slottype") + " " + LanguageManager.translate("equipment.slot." + this.slotType);
        baseFeature = baseFeature + "\n" + LanguageManager.translate("equipment.level") + " " + level + "/" + this.levelMax;
        if (level < this.levelMax) {
            baseFeature = baseFeature + "\n" + LanguageManager.translate("entity.experience") + ": " + experience + "/" + experienceMax;
        }
        descriptions.add("-------------------\n");
        descriptions.add(baseFeature);
        if (!this.elements.isEmpty()) {
            String elementFeature = LanguageManager.translate("equipment.element") + " " + this.getElementNames();
            descriptions.add(elementFeature);
        }
        descriptions.add("-------------------\n");
        for (EquipmentFeature feature : this.features) {
            String featureDescription = feature.getDescription(itemStack, level);
            if (featureDescription == null || "".equals(featureDescription)) continue;
            descriptions.add(featureDescription);
        }
        return descriptions;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return super.getAttributeModifiers(slot, stack);
    }

    public int getMetadata(ItemStack stack) {
        ITEMSTACK_TO_RENDER = stack;
        return super.getMetadata(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return LycanitesMobs.proxy.getFontRenderer();
    }

    public void randomizeLevel(World world, ItemStack itemStack) {
        int level = this.levelMax;
        if (this.levelMin < this.levelMax) {
            level = this.levelMin + world.field_73012_v.nextInt(this.levelMax - this.levelMin + 1);
        }
        this.setLevel(itemStack, level);
    }

    public boolean addFeature(EquipmentFeature feature) {
        if (feature == null) {
            LycanitesMobs.logWarning("", "[Equipment] Unable to add a null feature to " + (Object)((Object)this));
            return false;
        }
        if (feature.featureType == null) {
            LycanitesMobs.logWarning("", "[Equipment] Feature type not set for part " + (Object)((Object)this));
            return false;
        }
        this.features.add(feature);
        return true;
    }

    public void sortFeatures() {
        Comparator comparator = (o1, o2) -> o1.featureType.compareToIgnoreCase(o2.featureType);
        this.features.sort(comparator);
    }

    public void setLevel(ItemStack itemStack, int level) {
        NBTTagCompound nbt = this.getTagCompound(itemStack);
        nbt.func_74768_a("equipmentLevel", level);
        itemStack.func_77982_d(nbt);
    }

    public int getLevel(ItemStack itemStack) {
        NBTTagCompound nbt = this.getTagCompound(itemStack);
        int level = 1;
        if (nbt.func_74764_b("equipmentLevel")) {
            level = nbt.func_74762_e("equipmentLevel");
        }
        return level;
    }

    public void setExperience(ItemStack itemStack, int experience) {
        NBTTagCompound nbt = this.getTagCompound(itemStack);
        nbt.func_74768_a("equipmentExperience", experience);
        itemStack.func_77982_d(nbt);
    }

    public void addExperience(ItemStack itemStack, int experience) {
        int nextLevelExperience;
        int increasedExperience;
        int currentLevel = this.getLevel(itemStack);
        if (currentLevel >= this.levelMax) {
            this.setExperience(itemStack, 0);
        }
        if ((increasedExperience = this.getExperience(itemStack) + experience) >= (nextLevelExperience = this.getExperienceForNextLevel(itemStack))) {
            increasedExperience -= nextLevelExperience;
            this.setLevel(itemStack, currentLevel + 1);
        }
        this.setExperience(itemStack, increasedExperience);
    }

    public int getExperience(ItemStack itemStack) {
        NBTTagCompound nbt = this.getTagCompound(itemStack);
        int experience = 0;
        if (nbt.func_74764_b("equipmentExperience")) {
            experience = nbt.func_74762_e("equipmentExperience");
        }
        return experience;
    }

    public int getExperienceForNextLevel(ItemStack itemStack) {
        return BASE_LEVELUP_EXPERIENCE + Math.round((float)(BASE_LEVELUP_EXPERIENCE * (this.getLevel(itemStack) - 1)) * 0.25f);
    }

    public boolean isLevelingChargeItem(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ChargeItem) {
            ChargeItem chargeItem = (ChargeItem)itemStack.func_77973_b();
            for (ElementInfo elementInfo : this.elements) {
                if (!chargeItem.getElements().contains(elementInfo)) continue;
                return true;
            }
        }
        return false;
    }

    public int getExperienceFromChargeItem(ItemStack itemStack) {
        int experience = 0;
        if (itemStack.func_77973_b() instanceof ChargeItem) {
            ChargeItem chargeItem = (ChargeItem)itemStack.func_77973_b();
            for (ElementInfo elementInfo : this.elements) {
                if (!chargeItem.getElements().contains(elementInfo)) continue;
                experience += ChargeItem.CHARGE_EXPERIENCE;
            }
        }
        return experience;
    }

    public int getSharpness(ItemStack itemStack) {
        NBTTagCompound nbt = this.getTagCompound(itemStack);
        int sharpness = ItemEquipment.SHARPNESS_MAX;
        if (nbt.func_74764_b("equipmentSharpness")) {
            sharpness = nbt.func_74762_e("equipmentSharpness");
        }
        return sharpness;
    }

    public void setSharpness(ItemStack itemStack, int sharpness) {
        NBTTagCompound nbt = this.getTagCompound(itemStack);
        nbt.func_74768_a("equipmentSharpness", Math.max(Math.min(sharpness, ItemEquipment.SHARPNESS_MAX), 0));
        itemStack.func_77982_d(nbt);
    }

    public boolean addSharpness(ItemStack itemStack, int sharpness) {
        int currentSharpness = this.getSharpness(itemStack);
        if (currentSharpness >= ItemEquipment.SHARPNESS_MAX) {
            return false;
        }
        this.setSharpness(itemStack, this.getSharpness(itemStack) + sharpness);
        return true;
    }

    public boolean removeSharpness(ItemStack itemStack, int sharpness) {
        int currentSharpness = this.getSharpness(itemStack);
        if (currentSharpness <= 0) {
            return false;
        }
        this.setSharpness(itemStack, this.getSharpness(itemStack) - sharpness);
        return true;
    }

    public int getMana(ItemStack itemStack) {
        NBTTagCompound nbt = this.getTagCompound(itemStack);
        int mana = ItemEquipment.MANA_MAX;
        if (nbt.func_74764_b("equipmentMana")) {
            mana = nbt.func_74762_e("equipmentMana");
        }
        return mana;
    }

    public void setMana(ItemStack itemStack, int mana) {
        NBTTagCompound nbt = this.getTagCompound(itemStack);
        nbt.func_74768_a("equipmentMana", Math.max(Math.min(mana, ItemEquipment.MANA_MAX), 0));
        itemStack.func_77982_d(nbt);
    }

    public boolean addMana(ItemStack itemStack, int mana) {
        int currentMana = this.getMana(itemStack);
        if (currentMana >= ItemEquipment.MANA_MAX) {
            return false;
        }
        this.setMana(itemStack, this.getMana(itemStack) + mana);
        return true;
    }

    public boolean removeMana(ItemStack itemStack, int mana) {
        int currentMana = this.getMana(itemStack);
        if (currentMana <= 0) {
            return false;
        }
        this.setMana(itemStack, this.getMana(itemStack) - mana);
        return true;
    }

    public Vector4f getColor(ItemStack itemStack) {
        NBTTagCompound nbt = this.getTagCompound(itemStack);
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        if (nbt.func_74764_b("equipmentColorR")) {
            r = nbt.func_74760_g("equipmentColorR");
        }
        if (nbt.func_74764_b("equipmentColorG")) {
            g = nbt.func_74760_g("equipmentColorG");
        }
        if (nbt.func_74764_b("equipmentColorB")) {
            b = nbt.func_74760_g("equipmentColorB");
        }
        return new Vector4f(r, g, b, 1.0f);
    }

    public void setColor(ItemStack itemStack, float red, float green, float blue) {
        NBTTagCompound nbt = this.getTagCompound(itemStack);
        nbt.func_74776_a("equipmentColorR", red);
        nbt.func_74776_a("equipmentColorG", green);
        nbt.func_74776_a("equipmentColorB", blue);
        itemStack.func_77982_d(nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int level = 1; level <= this.levelMax; ++level) {
            ItemStack itemStack = new ItemStack((Item)this, 1);
            this.setLevel(itemStack, level);
            items.add((Object)itemStack);
        }
    }

    public boolean hasElement(ElementInfo element) {
        return this.elements.contains(element);
    }

    public String getElementNames() {
        String elementNames = "";
        boolean firstElement = true;
        for (ElementInfo element : this.elements) {
            if (!firstElement) {
                elementNames = elementNames + ", ";
            }
            firstElement = false;
            elementNames = elementNames + element.getTitle();
        }
        return elementNames;
    }

    @Override
    public ModelResourceLocation getModelResourceLocation() {
        return new ModelResourceLocation(new ResourceLocation("lycanitesmobs", "equipmentpart"), "inventory");
    }

    public ResourceLocation getTexture(ItemStack itemStack, String suffix) {
        if (AssetManager.getTexture(this.itemName + suffix) == null) {
            AssetManager.addTexture(this.itemName + suffix, this.modInfo, "textures/equipment/" + this.itemName.toLowerCase() + suffix + ".png");
        }
        return AssetManager.getTexture(this.itemName + suffix);
    }

    static {
        MOB_PART_DROPS = new HashMap<String, List<ItemEquipmentPart>>();
    }
}

