/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info.projectile.behaviours;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.helpers.JSONHelper;
import com.lycanitesmobs.core.info.projectile.behaviours.ProjectileBehaviour;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ProjectileBehaviourRandomEffect
extends ProjectileBehaviour {
    public List<String> effects = new ArrayList<String>();
    public int duration = 100;
    public int amplifier = 0;

    @Override
    public void loadFromJSON(JsonObject json) {
        if (json.has("effects")) {
            this.effects = JSONHelper.getJsonStrings(json.get("effects").getAsJsonArray());
        }
        if (json.has("effectDuration")) {
            this.duration = json.get("effectDuration").getAsInt();
        }
        if (json.has("effectAmplifier")) {
            this.amplifier = json.get("effectAmplifier").getAsInt();
        }
    }

    @Override
    public void onProjectileDamage(BaseProjectileEntity projectile, World world, EntityLivingBase target, float damage) {
        if (projectile.func_85052_h() == null || damage <= 0.0f) {
            return;
        }
        if (this.duration <= 0 || this.amplifier < 0) {
            return;
        }
        int randomIndex = world.field_73012_v.nextInt(this.effects.size());
        Potion effect = (Potion)GameRegistry.findRegistry(Potion.class).getValue(new ResourceLocation(this.effects.get(randomIndex)));
        if (effect != null) {
            target.func_70690_d(new PotionEffect(effect, this.duration, this.amplifier));
        }
    }
}

