/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info.projectile.behaviours;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.info.projectile.behaviours.ProjectileBehaviour;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ProjectileBehaviourExplosion
extends ProjectileBehaviour {
    public int radius = 2;
    public String mode = "none";

    @Override
    public void loadFromJSON(JsonObject json) {
        if (json.has("radius")) {
            this.radius = json.get("radius").getAsInt();
        }
        if (json.has("mode")) {
            this.mode = json.get("mode").getAsString();
        }
    }

    @Override
    public void onProjectileImpact(BaseProjectileEntity projectile, World world, BlockPos pos) {
        BaseCreatureEntity baseCreatureEntity;
        if (this.radius <= 0 || projectile.func_130014_f_().field_72995_K) {
            return;
        }
        if (!world.func_82736_K().func_82766_b("mobGriefing")) {
            return;
        }
        int explosionRadius = this.radius;
        if (projectile.func_85052_h() != null && projectile.func_85052_h() instanceof BaseCreatureEntity && (baseCreatureEntity = (BaseCreatureEntity)projectile.func_85052_h()).isRareVariant()) {
            explosionRadius += 2;
        }
        boolean breakBlocks = false;
        boolean destroyBlocks = false;
        if ("break".equalsIgnoreCase(this.mode)) {
            breakBlocks = true;
        } else if ("destroy".equalsIgnoreCase(this.mode)) {
            breakBlocks = true;
            destroyBlocks = true;
        }
        world.func_72885_a((Entity)projectile, projectile.func_174791_d().field_72450_a, projectile.func_174791_d().field_72448_b, projectile.func_174791_d().field_72449_c, (float)explosionRadius, destroyBlocks, breakBlocks);
    }
}

