/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.JSONLoader;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.entity.CreatureStats;
import com.lycanitesmobs.core.info.CreatureConfig;
import com.lycanitesmobs.core.info.CreatureGroup;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureSpawnConfig;
import com.lycanitesmobs.core.info.CreatureType;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.spawner.SpawnerMobRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.entity.EntityLiving;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CreatureManager
extends JSONLoader {
    public static CreatureManager INSTANCE;
    public CreatureConfig config;
    public CreatureSpawnConfig spawnConfig;
    public Map<String, CreatureType> creatureTypes = new HashMap<String, CreatureType>();
    public Map<String, CreatureGroup> creatureGroups = new HashMap<String, CreatureGroup>();
    public Map<String, CreatureInfo> creatures = new HashMap<String, CreatureInfo>();
    public Map<Class, CreatureInfo> creatureClassMap = new HashMap<Class, CreatureInfo>();
    protected int nextCreatureNetworkId = 100;
    public List<ModInfo> loadedMods = new ArrayList<ModInfo>();
    public Map<String, Double> difficultyMultipliers = new HashMap<String, Double>();
    public Map<String, Double> levelMultipliers = new HashMap<String, Double>();
    public double tamedHealthMultiplier = 3.0;
    public boolean dlDungeonsLoaded = false;

    public static CreatureManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CreatureManager();
        }
        return INSTANCE;
    }

    public CreatureManager() {
        this.config = new CreatureConfig();
        this.spawnConfig = new CreatureSpawnConfig();
    }

    public void startup(ModInfo modInfo) {
        this.loadConfig();
        this.loadCreatureTypesFromJSON(modInfo);
        this.loadCreatureGroupsFromJSON(modInfo);
        this.loadCreaturesFromJSON(modInfo);
        for (CreatureType creatureType : this.creatureTypes.values()) {
            creatureType.load();
        }
        for (CreatureGroup creatureGroup : this.creatureGroups.values()) {
            creatureGroup.init();
        }
        for (CreatureInfo creatureInfo : this.creatures.values()) {
            creatureInfo.load();
        }
    }

    public void lateStartup(ModInfo modInfo) {
        for (CreatureInfo creatureInfo : this.creatures.values()) {
            creatureInfo.lateLoad();
        }
    }

    public void loadConfig() {
        ConfigBase config = ConfigBase.getConfig(LycanitesMobs.modInfo, "general");
        this.config.loadConfig(config);
        this.spawnConfig.loadConfig(ConfigBase.getConfig(LycanitesMobs.modInfo, "spawning"));
        String[] difficultyNames = new String[]{"easy", "normal", "hard"};
        double[] difficultyDefaults = new double[]{0.8, 1.0, 1.1};
        this.difficultyMultipliers = new HashMap<String, Double>();
        config.setCategoryComment("Difficulty Multipliers", "Here you can scale the stats of every mob on a per difficulty basis. Note that on easy, speed is kept at 1.0 by default as 0.5 makes them stupidly slow.");
        int difficultyIndex = 0;
        for (String difficultyName : difficultyNames) {
            for (String statName : CreatureStats.STAT_NAMES) {
                double defaultValue = difficultyDefaults[difficultyIndex];
                if ("easy".equalsIgnoreCase(difficultyName) && "speed".equalsIgnoreCase(statName)) {
                    defaultValue = 1.0;
                }
                if ("hard".equalsIgnoreCase(difficultyName) && ("attackSpeed".equalsIgnoreCase(statName) || "rangedSpeed".equalsIgnoreCase(statName))) {
                    defaultValue = 1.5;
                }
                if ("armor".equalsIgnoreCase(statName)) {
                    defaultValue = 1.0;
                }
                if ("sight".equalsIgnoreCase(statName)) {
                    defaultValue = 1.0;
                }
                this.difficultyMultipliers.put((difficultyName + "-" + statName).toUpperCase(Locale.ENGLISH), config.getDouble("Difficulty Multipliers", difficultyName + " " + statName, defaultValue));
            }
            ++difficultyIndex;
        }
        config.setCategoryComment("Mob Level Multipliers", "Normally mobs are level 1, but Spawners can increase their level. Here you can adjust the percentage of each stat that is added per extra level. So by default at level 2 a mobs health is increased by 10%, at level 3 20% and so on.");
        for (String statName : CreatureStats.STAT_NAMES) {
            double levelValue = 0.01;
            if ("health".equalsIgnoreCase(statName)) {
                levelValue = 0.1;
            }
            if ("defense".equalsIgnoreCase(statName)) {
                levelValue = 0.01;
            }
            if ("armor".equalsIgnoreCase(statName)) {
                levelValue = 0.0;
            }
            if ("speed".equalsIgnoreCase(statName)) {
                levelValue = 0.01;
            }
            if ("damage".equalsIgnoreCase(statName)) {
                levelValue = 0.02;
            }
            if ("attackSpeed".equalsIgnoreCase(statName)) {
                levelValue = 0.01;
            }
            if ("rangedSpeed".equalsIgnoreCase(statName)) {
                levelValue = 0.01;
            }
            if ("effect".equalsIgnoreCase(statName)) {
                levelValue = 0.02;
            }
            if ("pierce".equalsIgnoreCase(statName)) {
                levelValue = 0.02;
            }
            if ("sight".equalsIgnoreCase(statName)) {
                levelValue = 0.0;
            }
            this.levelMultipliers.put(statName.toUpperCase(Locale.ENGLISH), config.getDouble("Mob Level Multipliers", statName, levelValue));
        }
    }

    public void loadCreatureTypesFromJSON(ModInfo groupInfo) {
        try {
            this.loadAllJson(groupInfo, "Creature Type", "creaturetypes", "name", true);
            LycanitesMobs.logDebug("Creature", "Complete! " + this.creatureTypes.size() + " JSON Creature Types Loaded In Total.");
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "No Creature Types loaded for: " + groupInfo.name);
        }
    }

    public void loadCreatureGroupsFromJSON(ModInfo groupInfo) {
        try {
            this.loadAllJson(groupInfo, "Creature Group", "creaturegroups", "name", true);
            LycanitesMobs.logDebug("Creature", "Complete! " + this.creatureGroups.size() + " JSON Creature Groups Loaded In Total.");
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "No Creature Groups loaded for: " + groupInfo.name);
        }
    }

    public void loadCreaturesFromJSON(ModInfo groupInfo) {
        try {
            if (!this.loadedMods.contains(groupInfo)) {
                this.loadedMods.add(groupInfo);
            }
            this.loadAllJson(groupInfo, "Creature", "creatures", "name", false);
            LycanitesMobs.logDebug("Creature", "Complete! " + this.creatures.size() + " JSON Creature Info Loaded In Total.");
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "No Creatures loaded for: " + groupInfo.name);
        }
    }

    @Override
    public void parseJson(ModInfo groupInfo, String loadGroup, JsonObject json) {
        if ("Creature Type".equals(loadGroup)) {
            CreatureType creatureType = new CreatureType(groupInfo);
            creatureType.loadFromJSON(json);
            if (creatureType.name == null) {
                LycanitesMobs.logWarning("", "[Creature] Unable to load " + loadGroup + " json due to missing name.");
                return;
            }
            if (this.creatureTypes.containsKey(creatureType.name)) {
                creatureType = this.creatureTypes.get(creatureType.name);
                creatureType.loadFromJSON(json);
            }
            this.creatureTypes.put(creatureType.name, creatureType);
            return;
        }
        if ("Creature Group".equals(loadGroup)) {
            CreatureGroup creatureGroup = new CreatureGroup();
            creatureGroup.loadFromJson(json);
            if (this.creatureGroups.containsKey(creatureGroup.name)) {
                creatureGroup = this.creatureGroups.get(creatureGroup.name);
                creatureGroup.loadFromJson(json);
            }
            this.creatureGroups.put(creatureGroup.name, creatureGroup);
            return;
        }
        if ("Creature".equals(loadGroup)) {
            CreatureInfo creatureInfo = new CreatureInfo(groupInfo);
            creatureInfo.loadFromJSON(json);
            if (creatureInfo.name == null) {
                LycanitesMobs.logWarning("", "[Creature] Unable to load " + loadGroup + " json due to missing name.");
                return;
            }
            if (this.creatures.containsKey(creatureInfo.name)) {
                creatureInfo = this.creatures.get(creatureInfo.name);
                creatureInfo.loadFromJSON(json);
            }
            this.creatures.put(creatureInfo.name, creatureInfo);
            this.creatureClassMap.put(creatureInfo.entityClass, creatureInfo);
        }
    }

    public int getNextCreatureNetworkId() {
        return this.nextCreatureNetworkId++;
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        ModInfo modInfo = LycanitesMobs.modInfo;
        LycanitesMobs.logDebug("Creature", "Forge registering all " + this.creatures.size() + " creatures from the mod: " + modInfo.name + "...");
        for (CreatureInfo creatureInfo : this.creatures.values()) {
            if (creatureInfo.modInfo != modInfo) continue;
            try {
                EntityEntry entityEntry = EntityEntryBuilder.create().entity(creatureInfo.entityClass).id(creatureInfo.getEntityId(), this.getNextCreatureNetworkId()).name(creatureInfo.getName()).tracker(creatureInfo.isBoss() ? 160 : 80, 3, false).build();
                event.getRegistry().register((IForgeRegistryEntry)entityEntry);
            }
            catch (Exception e) {
                LycanitesMobs.logWarning("", "Unable to find entity class for: " + creatureInfo.getName() + ".");
                throw e;
            }
        }
    }

    public void reload() {
        this.loadConfig();
        SpawnerMobRegistry.SPAWNER_MOB_REGISTRIES.clear();
        for (ModInfo group : this.loadedMods) {
            this.loadCreaturesFromJSON(group);
        }
    }

    public CreatureType getCreatureType(String creatureTypeName) {
        if (!this.creatureTypes.containsKey(creatureTypeName)) {
            return null;
        }
        return this.creatureTypes.get(creatureTypeName);
    }

    public CreatureGroup getCreatureGroup(String creatureGroupName) {
        if (!this.creatureGroups.containsKey(creatureGroupName)) {
            return null;
        }
        return this.creatureGroups.get(creatureGroupName);
    }

    public CreatureInfo getCreature(String creatureName) {
        if (!this.creatures.containsKey(creatureName)) {
            return null;
        }
        return this.creatures.get(creatureName);
    }

    public CreatureInfo getCreature(Class creatureClass) {
        if (!this.creatureClassMap.containsKey(creatureClass)) {
            return null;
        }
        return this.creatureClassMap.get(creatureClass);
    }

    public CreatureInfo getCreatureFromId(String entityId) {
        entityId = entityId.replace(".", ":");
        String[] mobIdParts = entityId.toLowerCase().split(":");
        return this.getCreature(mobIdParts[mobIdParts.length - 1]);
    }

    public Class<? extends EntityLiving> getEntityClass(String creatureName) {
        CreatureInfo creatureInfo = this.getCreature(creatureName);
        if (creatureInfo == null) {
            return null;
        }
        return creatureInfo.entityClass;
    }

    public double getDifficultyMultiplier(String difficultyName, String statName) {
        String key = difficultyName.toUpperCase(Locale.ENGLISH) + "-" + statName.toUpperCase(Locale.ENGLISH);
        if (!this.difficultyMultipliers.containsKey(key)) {
            return 1.0;
        }
        return this.difficultyMultipliers.get(key);
    }

    public double getLevelMultiplier(String statName) {
        if (!this.levelMultipliers.containsKey(statName.toUpperCase(Locale.ENGLISH))) {
            return 1.0;
        }
        return this.levelMultipliers.get(statName.toUpperCase(Locale.ENGLISH));
    }
}

