/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.helpers.JSONHelper;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.AbstractIllager;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class CreatureGroup {
    public List<CreatureInfo> creatures = new ArrayList<CreatureInfo>();
    public String name;
    public List<CreatureGroup> huntGroups = new ArrayList<CreatureGroup>();
    public List<String> huntGroupNames = new ArrayList<String>();
    public List<CreatureGroup> packGroups = new ArrayList<CreatureGroup>();
    public List<String> packGroupNames = new ArrayList<String>();
    public List<CreatureGroup> waryGroups = new ArrayList<CreatureGroup>();
    public List<String> waryGroupNames = new ArrayList<String>();
    public List<CreatureGroup> fleeGroups = new ArrayList<CreatureGroup>();
    public List<String> fleeGroupNames = new ArrayList<String>();
    public List<CreatureGroup> ignoreGroups = new ArrayList<CreatureGroup>();
    public List<String> ignoreGroupNames = new ArrayList<String>();
    public Interaction defaultInteraction = Interaction.HUNT;
    public boolean animals = false;
    public boolean humanoids = false;
    public boolean raiders = false;
    public boolean frozen = false;
    public boolean inferno = false;
    public List<String> entityIds = new ArrayList<String>();

    public void loadFromJson(JsonObject json) {
        this.name = json.get("name").getAsString();
        if (json.has("hunt")) {
            this.huntGroupNames = JSONHelper.getJsonStrings(json.getAsJsonArray("hunt"));
        }
        if (json.has("pack")) {
            this.packGroupNames = JSONHelper.getJsonStrings(json.getAsJsonArray("pack"));
        }
        if (json.has("wary")) {
            this.waryGroupNames = JSONHelper.getJsonStrings(json.getAsJsonArray("wary"));
        }
        if (json.has("flee")) {
            this.fleeGroupNames = JSONHelper.getJsonStrings(json.getAsJsonArray("flee"));
        }
        if (json.has("ignore")) {
            this.ignoreGroupNames = JSONHelper.getJsonStrings(json.getAsJsonArray("ignore"));
        }
        if (json.has("default")) {
            this.defaultInteraction = Interaction.valueOf(json.get("default").getAsString().toUpperCase(Locale.ENGLISH));
        }
        if (json.has("animals")) {
            this.animals = json.get("animals").getAsBoolean();
        }
        if (json.has("humanoids")) {
            this.humanoids = json.get("humanoids").getAsBoolean();
        }
        if (json.has("raiders")) {
            this.raiders = json.get("raiders").getAsBoolean();
        }
        if (json.has("frozen")) {
            this.frozen = json.get("frozen").getAsBoolean();
        }
        if (json.has("inferno")) {
            this.inferno = json.get("inferno").getAsBoolean();
        }
        if (json.has("entityIds")) {
            this.entityIds = JSONHelper.getJsonStrings(json.get("entityIds").getAsJsonArray());
        }
    }

    public void init() {
        CreatureGroup group;
        for (String groupName : this.huntGroupNames) {
            group = CreatureManager.getInstance().getCreatureGroup(groupName);
            if (groupName.equals(this.name)) {
                group = this;
            }
            if (group == null) continue;
            this.huntGroups.add(group);
        }
        for (String groupName : this.packGroupNames) {
            group = CreatureManager.getInstance().getCreatureGroup(groupName);
            if (groupName.equals(this.name)) {
                group = this;
            }
            if (group == null) continue;
            this.packGroups.add(group);
        }
        for (String groupName : this.waryGroupNames) {
            group = CreatureManager.getInstance().getCreatureGroup(groupName);
            if (groupName.equals(this.name)) {
                group = this;
            }
            if (group == null) continue;
            this.waryGroups.add(group);
        }
        for (String groupName : this.fleeGroupNames) {
            group = CreatureManager.getInstance().getCreatureGroup(groupName);
            if (groupName.equals(this.name)) {
                group = this;
            }
            if (group == null) continue;
            this.fleeGroups.add(group);
        }
        for (String groupName : this.ignoreGroupNames) {
            group = CreatureManager.getInstance().getCreatureGroup(groupName);
            if (groupName.equals(this.name)) {
                group = this;
            }
            if (group == null) continue;
            this.ignoreGroups.add(group);
        }
        LycanitesMobs.logDebug("Creature Group", "Loaded Creature Group: " + this.getName());
    }

    public String getName() {
        return this.name;
    }

    public void addCreature(CreatureInfo creature) {
        if (this.creatures.contains(creature)) {
            return;
        }
        this.creatures.add(creature);
    }

    public boolean hasEntity(Entity entity) {
        if (entity instanceof BaseCreatureEntity) {
            return ((BaseCreatureEntity)entity).creatureInfo.groups.contains(this);
        }
        if (!(entity instanceof EntityLivingBase)) {
            return false;
        }
        if (this.animals && entity instanceof EntityAnimal) {
            return true;
        }
        if (this.humanoids && (entity instanceof EntityPlayer || entity instanceof EntityVillager || entity instanceof AbstractIllager || entity instanceof EntityWitch)) {
            return true;
        }
        if (this.raiders && (entity instanceof AbstractIllager || entity instanceof EntityWitch)) {
            return true;
        }
        if (this.frozen && entity instanceof EntitySnowman) {
            return true;
        }
        if (this.inferno && (entity instanceof EntityBlaze || entity instanceof EntityMagmaCube)) {
            return true;
        }
        ResourceLocation entityResourceLocation = EntityList.func_191301_a((Entity)entity);
        if (entityResourceLocation == null) {
            return false;
        }
        String entityId = entityResourceLocation.toString();
        return this.entityIds.contains(entityId);
    }

    public boolean shouldRevenge(Entity entity) {
        for (CreatureGroup group : this.ignoreGroups) {
            if (!group.hasEntity(entity)) continue;
            return false;
        }
        for (CreatureGroup group : this.waryGroups) {
            if (!group.hasEntity(entity)) continue;
            return false;
        }
        for (CreatureGroup group : this.fleeGroups) {
            if (!group.hasEntity(entity)) continue;
            return false;
        }
        return this.defaultInteraction == Interaction.HUNT || this.defaultInteraction == Interaction.RETALIATE;
    }

    public boolean shouldHunt(Entity entity) {
        for (CreatureGroup group : this.ignoreGroups) {
            if (!group.hasEntity(entity)) continue;
            return false;
        }
        for (CreatureGroup group : this.huntGroups) {
            if (!group.hasEntity(entity)) continue;
            return true;
        }
        return this.defaultInteraction == Interaction.HUNT;
    }

    public boolean shouldPackHunt(Entity entity) {
        for (CreatureGroup group : this.ignoreGroups) {
            if (!group.hasEntity(entity)) continue;
            return false;
        }
        for (CreatureGroup group : this.packGroups) {
            if (!group.hasEntity(entity)) continue;
            return true;
        }
        return this.defaultInteraction == Interaction.PACKHUNT;
    }

    public boolean shouldFlee(Entity entity) {
        for (CreatureGroup group : this.fleeGroups) {
            if (!group.hasEntity(entity)) continue;
            return true;
        }
        return this.defaultInteraction == Interaction.FLEE;
    }

    static enum Interaction {
        HUNT("hunt"),
        PACKHUNT("pack"),
        WARY("wary"),
        FLEE("flee"),
        IGNORE("ignore"),
        RETALIATE("retaliate");

        public final String name;

        private Interaction(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

