/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.goals.targeting;

import com.google.common.base.Predicate;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.goals.TargetSorterNearest;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.MathHelper;

public abstract class TargetingGoal
extends EntityAIBase {
    protected BaseCreatureEntity host;
    protected EntityLivingBase target;
    protected Predicate<EntityLivingBase> targetSelector;
    protected Predicate<EntityLivingBase> allySelector;
    protected TargetSorterNearest nearestSorter;
    protected boolean checkSight = true;
    protected boolean nearbyOnly = false;
    protected boolean callForHelp = false;
    private int cantSeeTime;
    protected int cantSeeTimeMax = 60;
    protected double targetingRange = 0.0;
    private int targetSearchStatus;
    private int targetSearchDelay;

    public TargetingGoal(BaseCreatureEntity setHost) {
        this.host = setHost;
        this.targetSelector = entity -> {
            if (entity == null) {
                return false;
            }
            double d = entity.func_70032_d((Entity)this.host);
            double d2 = this.getTargetDistance();
            double d3 = entity.func_70093_af() && !this.host.trueSight ? (double)0.8f : 1.0;
            if (d > d2 * d3) {
                return false;
            }
            if (!this.isEntityTargetable((EntityLivingBase)entity, false)) {
                return false;
            }
            if (this.shouldCheckSight() && !entity.func_184202_aL() && !this.host.func_70685_l((Entity)entity)) {
                return false;
            }
            if (this.shouldCheckSight() && !entity.func_184202_aL() && entity.func_82150_aj() && !this.host.trueSight) {
                float f;
                if (!(entity instanceof EntityPlayer)) {
                    return false;
                }
                double d0 = this.getTargetDistance();
                if (entity.func_70093_af()) {
                    d0 *= (double)0.8f;
                }
                if ((f = ((EntityPlayer)entity).func_82243_bO()) < 0.1f) {
                    f = 0.1f;
                }
                d0 *= (double)(0.7f * f);
                if ((double)entity.func_70032_d((Entity)this.host) > d0) {
                    return false;
                }
            }
            return true;
        };
        this.allySelector = entity -> {
            if (entity == null) {
                return false;
            }
            if ((double)entity.func_70032_d((Entity)this.host) > this.getTargetDistance()) {
                return false;
            }
            if (!this.isAllyTarget((EntityLivingBase)entity)) {
                return false;
            }
            return !this.shouldCheckSight() || entity.func_184202_aL() || this.host.func_70685_l((Entity)entity);
        };
        this.nearestSorter = new TargetSorterNearest((Entity)setHost);
    }

    public void func_75249_e() {
        this.setTarget(this.target);
        this.targetSearchStatus = 0;
        this.targetSearchDelay = 0;
        this.cantSeeTime = 0;
    }

    public boolean func_75253_b() {
        if (this.getTarget() == null) {
            return false;
        }
        if (!this.getTarget().func_70089_S()) {
            return false;
        }
        if (this.shouldStopTargeting(this.getTarget())) {
            return false;
        }
        double distance = this.getTargetDistance() + 2.0;
        if ((double)this.host.func_70032_d((Entity)this.getTarget()) > distance) {
            return false;
        }
        if (this.shouldCheckSight()) {
            if (this.host.func_70635_at().func_75522_a((Entity)this.getTarget())) {
                this.cantSeeTime = 0;
            } else if (++this.cantSeeTime > this.cantSeeTimeMax) {
                return false;
            }
        }
        return true;
    }

    public boolean shouldStopTargeting(EntityLivingBase target) {
        return false;
    }

    public void func_75251_c() {
        this.setTarget(null);
    }

    protected EntityLivingBase getTarget() {
        return null;
    }

    protected void setTarget(EntityLivingBase newTarget) {
    }

    public EntityLivingBase getNewTarget(double rangeX, double rangeY, double rangeZ) {
        EntityLivingBase newTarget = null;
        try {
            List<EntityLivingBase> possibleTargets = this.getPossibleTargets(EntityLivingBase.class, rangeX, rangeY, rangeZ);
            if (possibleTargets.isEmpty()) {
                return null;
            }
            Collections.sort(possibleTargets, this.nearestSorter);
            newTarget = possibleTargets.get(0);
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "An exception occurred when target selecting, this has been skipped to prevent a crash.");
            e.printStackTrace();
        }
        return newTarget;
    }

    public <T extends EntityLivingBase> List<T> getPossibleTargets(Class<? extends T> clazz, double rangeX, double rangeY, double rangeZ) {
        return this.host.func_130014_f_().func_175647_a(clazz, this.host.func_174813_aQ().func_72314_b(rangeX, rangeY, rangeZ), this.targetSelector);
    }

    protected double getTargetDistance() {
        if (this.targetingRange > 0.0) {
            return this.targetingRange;
        }
        IAttributeInstance attributeInstance = this.host.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return attributeInstance.func_111126_e();
    }

    public void callNearbyForHelp() {
        if (this.allySelector == null || this.target == null) {
            return;
        }
        try {
            double targetDistance = this.getTargetDistance();
            List allies = this.host.func_130014_f_().func_175647_a(BaseCreatureEntity.class, this.host.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance), this.allySelector);
            for (EntityLiving possibleAlly : allies) {
                if (possibleAlly.func_184191_r((Entity)this.target) || !possibleAlly.func_70686_a(this.target.getClass())) continue;
                if (possibleAlly instanceof BaseCreatureEntity) {
                    BaseCreatureEntity possibleCreatureAlly = (BaseCreatureEntity)possibleAlly;
                    if (possibleCreatureAlly.func_70638_az() != null || !possibleCreatureAlly.canAttackEntity(this.target) || !possibleCreatureAlly.shouldCreatureGroupRevenge(this.target)) continue;
                    possibleCreatureAlly.func_70604_c(this.target);
                    continue;
                }
                if (possibleAlly.func_70643_av() != null) continue;
                possibleAlly.func_70604_c(this.target);
            }
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "An exception occurred when calling for help, this has been skipped to prevent a crash.");
            e.printStackTrace();
        }
    }

    protected boolean isEntityTargetable(EntityLivingBase checkTarget, boolean targetCreative) {
        if (checkTarget == null) {
            return false;
        }
        if (checkTarget == this.host) {
            return false;
        }
        if (!checkTarget.func_70089_S()) {
            return false;
        }
        if (checkTarget instanceof EntityPlayer) {
            if (!targetCreative && ((EntityPlayer)checkTarget).func_184812_l_()) {
                return false;
            }
            if (((EntityPlayer)checkTarget).func_175149_v()) {
                return false;
            }
        }
        if (!this.isValidTarget(checkTarget)) {
            return false;
        }
        if (!this.host.positionNearHome(MathHelper.func_76128_c((double)checkTarget.field_70165_t), MathHelper.func_76128_c((double)checkTarget.field_70163_u), MathHelper.func_76128_c((double)checkTarget.field_70161_v))) {
            return false;
        }
        if (this.shouldCheckSight() && !checkTarget.func_70644_a(MobEffects.field_188423_x) && !this.host.func_70635_at().func_75522_a((Entity)checkTarget)) {
            return false;
        }
        if (this.nearbyOnly) {
            if (--this.targetSearchDelay <= 0) {
                this.targetSearchStatus = 0;
            }
            if (this.targetSearchStatus == 0) {
                int n = this.targetSearchStatus = this.isNearby(checkTarget) ? 1 : 2;
            }
            if (this.targetSearchStatus == 2) {
                return false;
            }
        }
        return true;
    }

    protected boolean shouldCheckSight() {
        return this.checkSight;
    }

    protected boolean isValidTarget(EntityLivingBase target) {
        return true;
    }

    protected boolean isAllyTarget(EntityLivingBase checkTarget) {
        if (checkTarget == null) {
            return false;
        }
        if (checkTarget == this.host) {
            return false;
        }
        if (!checkTarget.func_70089_S()) {
            return false;
        }
        if (checkTarget instanceof EntityPlayer) {
            return false;
        }
        if (checkTarget instanceof BaseCreatureEntity ? !((BaseCreatureEntity)checkTarget).isProtective((Entity)this.host) : checkTarget.getClass() != ((Object)((Object)this.host)).getClass()) {
            return false;
        }
        return !this.shouldCheckSight() || this.host.func_70635_at().func_75522_a((Entity)checkTarget);
    }

    private boolean isNearby(EntityLivingBase target) {
        int j;
        this.targetSearchDelay = 10 + this.host.func_70681_au().nextInt(5);
        Path path = this.host.func_70661_as().func_75494_a((Entity)target);
        if (path == null) {
            return false;
        }
        PathPoint pathpoint = path.func_75870_c();
        if (pathpoint == null) {
            return false;
        }
        int i = pathpoint.field_75839_a - MathHelper.func_76128_c((double)target.field_70165_t);
        return (double)(i * i + (j = pathpoint.field_75838_c - MathHelper.func_76128_c((double)target.field_70161_v)) * j) <= 2.25;
    }
}

