/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.goals.actions.abilities;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.goals.BaseGoal;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class FireProjectilesGoal
extends BaseGoal {
    protected String projectileName;
    protected Class<? extends BaseProjectileEntity> projectileClass;
    protected float velocity = 1.6f;
    protected float inaccuracy = 0.0f;
    protected float scale = 1.0f;
    protected float angle = 0.0f;
    protected Vec3d offset = Vec3d.field_186680_a;
    private int fireRate = 60;
    private boolean allPlayers = false;
    private int randomCount = 0;
    protected int phase = -1;
    protected boolean overhead = false;
    private int abilityTime = 60;
    private Entity attackTarget;

    public FireProjectilesGoal(BaseCreatureEntity setHost) {
        super(setHost);
    }

    public FireProjectilesGoal setPhase(int phase) {
        this.phase = phase;
        return this;
    }

    public FireProjectilesGoal setProjectile(String projectileName) {
        this.projectileName = projectileName;
        return this;
    }

    public FireProjectilesGoal setProjectile(Class<? extends BaseProjectileEntity> projectileClass) {
        this.projectileClass = projectileClass;
        return this;
    }

    public FireProjectilesGoal setFireRate(int fireRate) {
        this.fireRate = fireRate;
        return this;
    }

    public FireProjectilesGoal setVelocity(float velocity) {
        this.velocity = velocity;
        return this;
    }

    public FireProjectilesGoal setScale(float scale) {
        this.scale = scale;
        return this;
    }

    public FireProjectilesGoal setInaccuracy(int inaccuracy) {
        this.inaccuracy = inaccuracy;
        return this;
    }

    public FireProjectilesGoal setAngle(int angle) {
        this.angle = angle;
        return this;
    }

    public FireProjectilesGoal setOffset(Vec3d offset) {
        this.offset = offset;
        return this;
    }

    public FireProjectilesGoal setOverhead(boolean overhead) {
        this.overhead = overhead;
        return this;
    }

    public FireProjectilesGoal setAllPlayers(boolean allPlayers) {
        this.allPlayers = allPlayers;
        return this;
    }

    public FireProjectilesGoal setRandomCount(int randomCount) {
        this.randomCount = randomCount;
        return this;
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        if (this.projectileName == null && this.projectileClass == null) {
            return false;
        }
        this.attackTarget = this.host.func_70638_az();
        if (!this.allPlayers && this.randomCount <= 0 && this.attackTarget == null) {
            return false;
        }
        return this.phase < 0 || this.phase == this.host.getBattlePhase();
    }

    public void func_75249_e() {
        this.abilityTime = 1;
    }

    public void func_75251_c() {
        this.attackTarget = null;
    }

    public void func_75246_d() {
        if (this.abilityTime++ % Math.round((float)(1.0 / this.host.func_110148_a(BaseCreatureEntity.RANGED_SPEED).func_111126_e() * (double)this.fireRate)) != 0) {
            return;
        }
        if (this.allPlayers) {
            for (EntityPlayer target : this.host.playerTargets) {
                if (target.field_71075_bZ.field_75102_a || target.func_175149_v()) continue;
                this.fireProjectile((Entity)target);
            }
            return;
        }
        if (this.randomCount > 0) {
            for (int i = 0; i < this.randomCount; ++i) {
                if (this.projectileName != null) {
                    this.host.fireProjectile(this.projectileName, null, this.host.func_70681_au().nextFloat() * 10.0f, this.host.func_70681_au().nextFloat() * this.angle, this.offset, this.velocity, this.scale, this.inaccuracy);
                    continue;
                }
                if (this.projectileClass == null) continue;
                this.host.fireProjectile(this.projectileClass, null, this.host.func_70681_au().nextFloat() * 10.0f, this.host.func_70681_au().nextFloat() * this.angle, this.offset, this.velocity, this.scale, this.inaccuracy);
            }
            return;
        }
        this.fireProjectile(this.attackTarget);
    }

    public BaseProjectileEntity fireProjectile(Entity target) {
        BaseProjectileEntity projectile = this.createProjectile();
        if (this.overhead) {
            this.fireProjectileOverhead(projectile);
        } else {
            this.host.fireProjectile(projectile, target, this.host.func_70032_d(target), this.angle, this.offset, this.velocity, this.scale, this.inaccuracy);
        }
        return projectile;
    }

    public BaseProjectileEntity createProjectile() {
        BaseProjectileEntity projectile = null;
        if (this.projectileName != null) {
            ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile(this.projectileName);
            if (projectileInfo == null) {
                return projectile;
            }
            projectile = projectileInfo.createProjectile(this.host.func_130014_f_(), (EntityLivingBase)this.host);
        } else if (this.projectileClass != null) {
            try {
                projectile = this.projectileClass.getConstructor(World.class, EntityLivingBase.class).newInstance(new Object[]{this.host.func_130014_f_(), this.host});
            }
            catch (Exception e) {
                LycanitesMobs.logWarning("", "Unable to create a projectile from the class: " + this.projectileClass);
            }
        }
        if (projectile != null) {
            projectile.setProjectileScale(this.scale);
        }
        return projectile;
    }

    public void fireProjectileOverhead(BaseProjectileEntity projectile) {
        Object target = this.attackTarget != null ? this.attackTarget : this.host;
        projectile.func_70186_c(0.0, -1.0, 0.0, 0.5f, this.inaccuracy);
        projectile.func_70107_b(target.func_180425_c().func_177958_n(), (double)target.func_180425_c().func_177956_o() + this.offset.field_72448_b + this.host.func_70681_au().nextDouble() * 3.0, target.func_180425_c().func_177952_p());
        this.host.func_130014_f_().func_72838_d((Entity)projectile);
    }
}

