/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.goals.actions;

import com.lycanitesmobs.core.entity.AgeableCreatureEntity;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.item.consumable.CreatureTreatItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.math.BlockPos;

public class TemptGoal
extends EntityAIBase {
    private BaseCreatureEntity host;
    private EntityPlayer player;
    private double speed = 1.0;
    private ItemStack temptItemStack = null;
    private String temptList = null;
    private int retemptTime;
    private int retemptTimeMax = 0;
    private double temptDistanceMin = 1.0;
    private double temptDistanceMax = 16.0;
    private boolean scaredByPlayerMovement = false;
    private boolean stopAttack = false;
    private boolean includeTreats = true;
    private boolean includeDiet = false;
    private boolean alwaysTempted = false;
    private double targetX;
    private double targetY;
    private double targetZ;
    private double targetPitch;
    private double targetYaw;
    private boolean canSwim;
    private boolean isRunning;

    public TemptGoal(BaseCreatureEntity setHost) {
        this.host = setHost;
        this.func_75248_a(3);
    }

    public TemptGoal setSpeed(double setSpeed) {
        this.speed = setSpeed;
        return this;
    }

    public TemptGoal setItemStack(ItemStack item) {
        this.temptItemStack = item;
        return this;
    }

    public TemptGoal setItemList(String list) {
        this.temptList = list;
        return this;
    }

    public TemptGoal setRetemptTime(int time) {
        this.retemptTimeMax = time;
        return this;
    }

    public TemptGoal setTemptDistanceMin(double dist) {
        this.temptDistanceMin = dist;
        return this;
    }

    public TemptGoal setTemptDistanceMax(double dist) {
        this.temptDistanceMax = dist;
        return this;
    }

    public TemptGoal setScaredByMovement(boolean scared) {
        this.scaredByPlayerMovement = scared;
        return this;
    }

    public TemptGoal setStopAttack(boolean setStopAttack) {
        this.stopAttack = setStopAttack;
        return this;
    }

    public TemptGoal setIncludeTreats(boolean includeTreats) {
        this.includeTreats = includeTreats;
        return this;
    }

    public TemptGoal setIncludeDiet(boolean includeDiet) {
        this.includeDiet = includeDiet;
        return this;
    }

    public TemptGoal setAlwaysTempted(boolean alwaysTempted) {
        this.alwaysTempted = alwaysTempted;
        return this;
    }

    public boolean func_75250_a() {
        if (this.retemptTime > 0) {
            --this.retemptTime;
            return false;
        }
        if (!this.host.canBeTempted()) {
            return false;
        }
        if (this.host instanceof TameableCreatureEntity && this.host.isTamed()) {
            return false;
        }
        if (this.player == null) {
            this.player = this.host.func_130014_f_().func_72890_a((Entity)this.host, this.temptDistanceMax);
            if (this.player == null) {
                return false;
            }
        } else if (this.host.func_70068_e((Entity)this.player) > this.temptDistanceMax * this.temptDistanceMax) {
            this.player = null;
            return false;
        }
        if (!(this.alwaysTempted || this.isTemptStack(this.player.func_184614_ca()) || this.isTemptStack(this.player.func_184592_cb()))) {
            this.player = null;
            return false;
        }
        this.host.setStealth(0.0f);
        return true;
    }

    public boolean isTemptStack(ItemStack itemStack) {
        CreatureTreatItem itemTreat;
        if (itemStack.func_190926_b()) {
            return false;
        }
        if (this.includeTreats && this.host.creatureInfo.isTameable() && this.host.creatureInfo.creatureType != null && itemStack.func_77973_b() instanceof CreatureTreatItem && this.host.creatureInfo.creatureType == (itemTreat = (CreatureTreatItem)itemStack.func_77973_b()).getCreatureType()) {
            return true;
        }
        if (this.includeDiet && this.host.creatureInfo.canEat(itemStack)) {
            return true;
        }
        if (this.temptList != null) {
            if (ObjectLists.inItemList(this.temptList, itemStack)) {
                return true;
            }
        } else if (this.temptItemStack != null) {
            if (itemStack.func_77973_b() != this.temptItemStack.func_77973_b()) {
                return false;
            }
            return itemStack.func_77960_j() == this.temptItemStack.func_77960_j();
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.scaredByPlayerMovement) {
            if ((double)this.host.func_70032_d((Entity)this.player) < 36.0) {
                if (this.player.func_70092_e(this.targetX, this.targetY, this.targetZ) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.player.field_70125_A - this.targetPitch) > 5.0 || Math.abs((double)this.player.field_70177_z - this.targetYaw) > 5.0) {
                    return false;
                }
            } else {
                this.targetX = this.player.field_70165_t;
                this.targetY = this.player.field_70163_u;
                this.targetZ = this.player.field_70161_v;
            }
            this.targetPitch = this.player.field_70125_A;
            this.targetYaw = this.player.field_70177_z;
        }
        return this.func_75250_a();
    }

    public void func_75249_e() {
        this.targetX = this.player.field_70165_t;
        this.targetY = this.player.field_70163_u;
        this.targetZ = this.player.field_70161_v;
        this.isRunning = true;
        if (this.host.func_70661_as() instanceof PathNavigateGround) {
            PathNavigateGround navigateGround = (PathNavigateGround)this.host.func_70661_as();
            this.canSwim = !navigateGround.func_179684_h();
            navigateGround.func_179693_d(true);
        }
        if (this.stopAttack) {
            this.host.func_70624_b(null);
        }
    }

    public void func_75251_c() {
        AgeableCreatureEntity ageable;
        this.player = null;
        this.host.func_70661_as().func_75499_g();
        this.retemptTime = this.retemptTimeMax;
        if (this.host instanceof AgeableCreatureEntity && !(ageable = (AgeableCreatureEntity)this.host).func_70631_g_() && !ageable.canBreed()) {
            Math.max(this.retemptTime *= 10, 100);
        }
        this.isRunning = false;
        if (this.host.func_70661_as() instanceof PathNavigateGround) {
            PathNavigateGround navigateGround = (PathNavigateGround)this.host.func_70661_as();
            navigateGround.func_179693_d(this.canSwim);
        }
    }

    public void func_75246_d() {
        if (this.stopAttack) {
            this.host.func_70624_b(null);
        }
        this.host.func_70671_ap().func_75651_a((Entity)this.player, 30.0f, (float)this.host.func_70646_bf());
        if (this.host.func_70068_e((Entity)this.player) < this.temptDistanceMin * this.temptDistanceMin) {
            this.host.clearMovement();
        } else if (!this.host.useDirectNavigator()) {
            this.host.func_70661_as().func_75497_a((Entity)this.player, this.speed);
        } else {
            this.host.directNavigator.setTargetPosition(new BlockPos((int)this.player.field_70165_t, (int)this.player.field_70163_u, (int)this.player.field_70161_v), this.speed);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

