/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.ExtendedEntity;
import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.targeting.FindAttackTargetGoal;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityRoc
extends RideableCreatureEntity
implements IMob {
    public AttackMeleeGoal attackAI;
    public boolean creeperDropping = true;
    private int creeperDropCooldown = 0;

    public EntityRoc(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.flySoundSpeed = 20;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        if (this.creeperDropping) {
            this.field_70715_bh.func_75776_a(this.nextFindTargetIndex++, (EntityAIBase)new FindAttackTargetGoal(this).addTargets(EntityCreeper.class));
        }
        super.func_184651_r();
        this.attackAI = new AttackMeleeGoal(this).setLongMemory(false);
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)this.attackAI);
    }

    @Override
    public void loadCreatureFlags() {
        this.creeperDropping = this.creatureInfo.getFlag("creeperDropping", this.creeperDropping);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && this.func_184179_bs() == null) {
            this.attackAI.setEnabled(this.hasPickupEntity() ? this.getPickupEntity() instanceof EntityCreeper : this.creeperDropCooldown <= 0);
            if (this.creeperDropCooldown > 0) {
                --this.creeperDropCooldown;
            }
            if (this.hasPickupEntity()) {
                double distance;
                ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(this.getPickupEntity());
                if (extendedEntity != null) {
                    extendedEntity.setPickedUpByEntity((Entity)this);
                }
                if (this.getPickupEntity() instanceof EntityCreeper && this.hasAttackTarget() && !(this.func_70638_az() instanceof EntityCreeper) && (distance = new Vec3d(this.field_70165_t, 0.0, this.field_70161_v).func_72438_d(new Vec3d(this.func_70638_az().field_70165_t, 0.0, this.func_70638_az().field_70161_v))) <= 2.0 && this.field_70163_u > this.func_70638_az().field_70163_u) {
                    this.getPickupEntity().func_70604_c(this.func_70638_az());
                    this.dropPickupEntity();
                    this.creeperDropCooldown = 120;
                }
                if (this.hasPickupEntity() && this.field_70173_aa % 100 == 0 && this.func_70681_au().nextBoolean()) {
                    if (this.getPickupEntity() instanceof EntityPlayer) {
                        for (int distToGround = 0; distToGround < 8; ++distToGround) {
                            Block searchBlock = this.func_130014_f_().func_180495_p(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u - distToGround, (int)this.field_70161_v)).func_177230_c();
                            if (searchBlock == null || searchBlock == Blocks.field_150350_a) continue;
                            this.dropPickupEntity();
                            this.leap(1.0, 2.0);
                            break;
                        }
                    } else if (!(this.getPickupEntity() instanceof EntityCreeper)) {
                        this.dropPickupEntity();
                    }
                }
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.func_184179_bs() == null && this.getPickupEntity() instanceof EntityCreeper) {
            ((EntityCreeper)this.getPickupEntity()).func_70624_b(null);
        }
    }

    @Override
    public void riderEffects(EntityLivingBase rider) {
        if (rider.func_70644_a(MobEffects.field_76437_t)) {
            rider.func_184589_d(MobEffects.field_76437_t);
        }
        if (rider.func_70644_a(MobEffects.field_76419_f)) {
            rider.func_184589_d(MobEffects.field_76419_f);
        }
    }

    @Override
    public double getFlightOffset() {
        if (this.hasPickupEntity()) {
            return 5.0;
        }
        return super.getFlightOffset();
    }

    @Override
    public boolean rollWanderChance() {
        if (this.isFlying()) {
            return this.func_70681_au().nextDouble() <= 0.25;
        }
        return this.func_70681_au().nextDouble() <= 0.008;
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if (target instanceof EntityLivingBase && this.func_184179_bs() == null) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)target;
            if (this.canPickupEntity(entityLivingBase)) {
                this.pickupEntity(entityLivingBase);
            }
            if (entityLivingBase instanceof EntityCreeper) {
                entityLivingBase.func_70604_c(null);
                ((EntityCreeper)entityLivingBase).func_70624_b(null);
                this.func_70624_b(null);
            }
        }
        return true;
    }

    @Override
    public boolean canAttackEntity(EntityLivingBase targetEntity) {
        if (this.isTamed()) {
            return super.canAttackEntity(targetEntity);
        }
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(targetEntity);
        if (extendedEntity != null && extendedEntity.pickedUpByEntity != null) {
            return false;
        }
        if (!this.creeperDropping && targetEntity instanceof EntityCreeper) {
            return false;
        }
        if (this.hasPickupEntity() && targetEntity instanceof EntityCreeper) {
            return false;
        }
        if (this.creeperDropCooldown > 0) {
            return false;
        }
        return super.canAttackEntity(targetEntity);
    }

    @Override
    public boolean isAggressive() {
        if (this.isTamed()) {
            return super.isAggressive();
        }
        if ("".equals(this.spawnEventType) && this.func_130014_f_().func_72935_r() && this.testLightLevel() >= 2) {
            return false;
        }
        return super.isAggressive();
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public void pickupEntity(EntityLivingBase entity) {
        super.pickupEntity(entity);
        if (this.func_130014_f_().func_180495_p(this.func_180425_c()) != null && this.func_130014_f_().func_175710_j(this.func_180425_c())) {
            this.leap(0.5, 4.0);
        }
    }

    @Override
    public double[] getPickupOffset(Entity entity) {
        if (entity != null) {
            return new double[]{0.0, 1.0f - entity.field_70131_O, 0.0};
        }
        return new double[]{0.0, 0.0, 0.0};
    }

    @Override
    public boolean canPickupEntity(EntityLivingBase entity) {
        if (this.creeperDropCooldown > 0 || this.hasPickupEntity()) {
            return false;
        }
        return super.canPickupEntity(entity);
    }

    @Override
    public boolean canAttackWithPickup() {
        if (this.getPickupEntity() instanceof EntityCreeper) {
            return true;
        }
        return super.canAttackWithPickup();
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public BlockPos getWanderPosition(BlockPos wanderPosition) {
        if (this.hasPickupEntity() && this.getPickupEntity() instanceof EntityPlayer) {
            return new BlockPos(wanderPosition.func_177958_n(), this.restrictYHeightFromGround(wanderPosition, 6, 14), wanderPosition.func_177952_p());
        }
        return super.getWanderPosition(wanderPosition);
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.hasPickupEntity()) {
            if (this.getPickupEntity() instanceof EntityCreeper) {
                ((EntityCreeper)this.getPickupEntity()).func_146079_cb();
            }
            this.dropPickupEntity();
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        EntityLivingBase nearestTarget = this.getNearestEntity(EntityLivingBase.class, null, 4.0, false);
        if (this.canPickupEntity(nearestTarget)) {
            this.pickupEntity(nearestTarget);
        }
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 20.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 100;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }
}

