/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.EntityItemCustom;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLobber
extends BaseCreatureEntity
implements IMob {
    public int blockMeltingRadius = 2;

    public EntityLobber(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.spawnsOnLand = true;
        this.spawnsInWater = true;
        this.isLavaCreature = true;
        this.hasAttackSound = false;
        this.setupMob();
        this.func_184644_a(PathNodeType.LAVA, 0.0f);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackRangedGoal(this).setSpeed(1.0).setRange(16.0f).setMinChaseDistance(8.0f));
    }

    @Override
    public void loadCreatureFlags() {
        this.blockMeltingRadius = this.creatureInfo.getFlag("blockMeltingRadius", this.blockMeltingRadius);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && this.isMoving() && this.field_70173_aa % 5 == 0) {
            int trailHeight = 1;
            int trailWidth = 1;
            if (this.isRareVariant()) {
                trailWidth = 3;
            }
            for (int y = 0; y < trailHeight; ++y) {
                Block block = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(0, y, 0)).func_177230_c();
                if (block != Blocks.field_150350_a && block != Blocks.field_150480_ab && block != Blocks.field_150433_aE && block != Blocks.field_150329_H && block != ObjectManager.getBlock("frostfire") && block != ObjectManager.getBlock("icefire")) continue;
                if (trailWidth == 1) {
                    this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(0, y, 0), Blocks.field_150480_ab.func_176223_P());
                    continue;
                }
                for (int x = -(trailWidth / 2); x < trailWidth / 2 + 1; ++x) {
                    for (int z = -(trailWidth / 2); z < trailWidth / 2 + 1; ++z) {
                        this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(x, y, z), Blocks.field_150480_ab.func_176223_P());
                    }
                }
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.isRareVariant() && this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing") && this.blockMeltingRadius > 0 && this.field_70173_aa % 10 == 0) {
            ProjectileInfo projectileInfo;
            int range = this.blockMeltingRadius;
            int w = -((int)Math.ceil(this.field_70130_N) + range);
            while ((double)w <= Math.ceil(this.field_70130_N) + (double)range) {
                int d = -((int)Math.ceil(this.field_70130_N) + range);
                while ((double)d <= Math.ceil(this.field_70130_N) + (double)range) {
                    int h = 0;
                    while ((double)h <= Math.ceil(this.field_70131_O)) {
                        Block block = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(w, h, d)).func_177230_c();
                        if (block == Blocks.field_150343_Z || block == Blocks.field_150347_e || block == Blocks.field_150346_d || block == Blocks.field_150351_n || block == Blocks.field_150354_m) {
                            IBlockState blockState = Blocks.field_150356_k.func_176203_a(11);
                            this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(w, h, d), blockState);
                        }
                        ++h;
                    }
                    ++d;
                }
                ++w;
            }
            if (this.field_70173_aa % 40 == 0 && (projectileInfo = ProjectileManager.getInstance().getProjectile("magma")) != null) {
                BaseProjectileEntity projectile = projectileInfo.createProjectile(this.func_130014_f_(), (EntityLivingBase)this);
                projectile.setProjectileScale(2.0f);
                projectile.func_70186_c(2.0f * this.func_70681_au().nextFloat() - 1.0f, this.func_70681_au().nextFloat(), 2.0f * this.func_70681_au().nextFloat() - 1.0f, 1.2f, 6.0f);
                this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                this.func_130014_f_().func_72838_d((Entity)projectile);
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            int i;
            for (i = 0; i < 2; ++i) {
                this.func_130014_f_().func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                this.func_130014_f_().func_175688_a(EnumParticleTypes.DRIP_LAVA, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.field_70173_aa % 10 == 0) {
                for (i = 0; i < 2; ++i) {
                    this.func_130014_f_().func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (this.lavaContact()) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        int waterWeight = 10;
        BlockPos pos = new BlockPos(x, y, z);
        if (this.func_130014_f_().func_180495_p(pos).func_177230_c() == Blocks.field_150353_l) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_70638_az() != null) {
            return super.getBlockPathWeight(x, y, z);
        }
        if (this.lavaContact()) {
            return -999999.0f;
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile("magma", target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 1.2f, 2.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public boolean isAggressive() {
        if (this.func_70086_ai() <= -100) {
            return false;
        }
        return super.isAggressive();
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean waterDamage() {
        return !this.isRareVariant();
    }

    @Override
    public boolean canBreatheUnderlava() {
        return true;
    }

    @Override
    public boolean canBreatheAir() {
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 0.0f;
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public void applyDropEffects(EntityItemCustom entityitem) {
        entityitem.setCanBurn(false);
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }
}

