/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityIoray
extends RideableCreatureEntity
implements IMob {
    WanderGoal wanderAI;
    BaseProjectileEntity projectile = null;
    BaseProjectileEntity abilityProjectile = null;

    public EntityIoray(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.spawnsOnLand = false;
        this.spawnsInWater = true;
        this.hasAttackSound = true;
        this.babySpawnChance = 0.0;
        this.canGrow = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setLongMemory(false).setMaxChaseDistanceSq(4.0f));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackRangedGoal(this).setSpeed(0.75).setStaminaTime(100).setRange(8.0f).setMinChaseDistance(4.0f).setMountedAttacking(false));
    }

    @Override
    public void riderEffects(EntityLivingBase rider) {
        rider.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 105, 1));
        super.riderEffects(rider);
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        int waterWeight = 10;
        Block block = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (block == Blocks.field_150355_j) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_130014_f_().func_72896_J() && this.func_130014_f_().func_175710_j(new BlockPos(x, y, z))) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_70638_az() != null) {
            return super.getBlockPathWeight(x, y, z);
        }
        if (this.waterContact()) {
            return -999999.0f;
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean isStrongSwimmer() {
        return true;
    }

    @Override
    public boolean canWalk() {
        return false;
    }

    @Override
    public double func_70042_X() {
        return (double)this.field_70131_O * 0.6;
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean canBreatheAir() {
        return false;
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public void attackRanged(Entity target, float range) {
        ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile("waterjet");
        if (projectileInfo == null) {
            return;
        }
        if (this.projectile != null && this.projectile.func_70089_S()) {
            this.projectile.projectileLife = 20;
        } else {
            this.projectile = null;
        }
        if (this.projectile == null) {
            this.projectile = projectileInfo.createProjectile(this.func_130014_f_(), (EntityLivingBase)this);
            this.func_184185_a(this.projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.func_130014_f_().func_72838_d((Entity)this.projectile);
        }
        super.attackRanged(target, range);
    }

    @Override
    public void mountAbility(Entity rider) {
        ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile("waterjet");
        if (projectileInfo == null) {
            return;
        }
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.getStamina() < this.getStaminaRecoveryMax() * 2.0f) {
            return;
        }
        if (this.hasAttackTarget()) {
            this.func_70624_b(null);
        }
        if (this.abilityProjectile != null && this.abilityProjectile.func_70089_S()) {
            this.abilityProjectile.projectileLife = 20;
        } else {
            this.abilityProjectile = null;
        }
        if (this.abilityProjectile == null) {
            if (this.func_184179_bs() == null || !(this.func_184179_bs() instanceof EntityLivingBase)) {
                return;
            }
            this.abilityProjectile = projectileInfo.createProjectile(this.func_130014_f_(), (EntityLivingBase)this);
            this.func_184185_a(this.abilityProjectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.func_130014_f_().func_72838_d((Entity)this.abilityProjectile);
        }
        this.applyStaminaCost();
    }

    @Override
    public void onDismounted(Entity entity) {
        super.onDismounted(entity);
        if (entity != null && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76427_o, 100, 1));
        }
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }
}

