/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IFusable;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityAegis;
import com.lycanitesmobs.core.entity.creature.EntityArgus;
import com.lycanitesmobs.core.entity.creature.EntityCinder;
import com.lycanitesmobs.core.entity.creature.EntityGeonach;
import com.lycanitesmobs.core.entity.creature.EntityJengu;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityDjinn
extends TameableCreatureEntity
implements IMob,
IFusable {
    public float fireDamageAbsorbed = 0.0f;
    protected IFusable fusionTarget;

    public EntityDjinn(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = false;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackRangedGoal(this).setSpeed(0.75).setRange(16.0f).setMinChaseDistance(8.0f));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && !this.isTamed() && this.fireDamageAbsorbed >= 10.0f) {
            this.transform(CreatureManager.getInstance().getEntityClass("zephyr"), null, false);
        }
    }

    @Override
    public void attackRanged(Entity target, float range) {
        int projectileCount = 10;
        for (int i = 0; i < projectileCount; ++i) {
            this.fireProjectile("whirlwind", target, range, (float)(360 / projectileCount * i), new Vec3d(0.0, 0.0, 0.0), 0.6f, 2.0f, 1.0f);
        }
        super.attackRanged(target, range);
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean isStrongSwimmer() {
        return false;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (type.equals("cactus") || type.equals("inWall")) {
            return false;
        }
        if (source.func_76347_k()) {
            this.fireDamageAbsorbed += damage;
            return false;
        }
        if (type.equals("lightningBolt") && !this.isTamed()) {
            this.transform(CreatureManager.getInstance().getEntityClass("zephyr"), null, false);
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public IFusable getFusionTarget() {
        return this.fusionTarget;
    }

    @Override
    public void setFusionTarget(IFusable fusionTarget) {
        this.fusionTarget = fusionTarget;
    }

    @Override
    public Class getFusionClass(IFusable fusable) {
        if (fusable instanceof EntityCinder) {
            return CreatureManager.getInstance().getEntityClass("zephyr");
        }
        if (fusable instanceof EntityJengu) {
            return CreatureManager.getInstance().getEntityClass("reiver");
        }
        if (fusable instanceof EntityGeonach) {
            return CreatureManager.getInstance().getEntityClass("banshee");
        }
        if (fusable instanceof EntityAegis) {
            return CreatureManager.getInstance().getEntityClass("sylph");
        }
        if (fusable instanceof EntityArgus) {
            return CreatureManager.getInstance().getEntityClass("wraith");
        }
        return null;
    }
}

