/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityAsmodeus;
import com.lycanitesmobs.core.entity.creature.EntityAstaroth;
import com.lycanitesmobs.core.entity.creature.EntityTrite;
import com.lycanitesmobs.core.entity.creature.EntityWraith;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.goals.targeting.FindAttackTargetGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCacodemon
extends RideableCreatureEntity {
    public boolean griefing = true;

    public EntityCacodemon(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEAD;
        this.hasAttackSound = false;
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.hitAreaWidthScale = 1.5f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackRangedGoal(this).setSpeed(0.25).setRange(40.0f).setMinChaseDistance(10.0f).setLongMemory(false));
        this.field_70715_bh.func_75776_a(this.nextFindTargetIndex++, (EntityAIBase)new FindAttackTargetGoal(this).addTargets(EntityGhast.class));
    }

    @Override
    public void loadCreatureFlags() {
        this.griefing = this.creatureInfo.getFlag("griefing", this.griefing);
    }

    @Override
    public void func_70636_d() {
        if (!this.func_130014_f_().field_72995_K && this.isRareVariant() && this.hasAttackTarget() && this.field_70173_aa % 20 == 0) {
            this.allyUpdate();
        }
        super.func_70636_d();
    }

    @Override
    public void riderEffects(EntityLivingBase rider) {
        if (rider.func_70644_a(MobEffects.field_82731_v)) {
            rider.func_184589_d(MobEffects.field_82731_v);
        }
        if (rider.func_70027_ad()) {
            rider.func_70066_B();
        }
    }

    public void allyUpdate() {
        float random;
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (CreatureManager.getInstance().getCreature((String)"wraith").enabled && this.nearbyCreatureCount(CreatureManager.getInstance().getCreature("wraith").getEntityClass(), 64.0) < 10 && (random = this.field_70146_Z.nextFloat()) <= 0.1f) {
            this.spawnAlly(this.field_70165_t - 2.0 + (double)(random * 4.0f), this.field_70163_u, this.field_70161_v - 2.0 + (double)(random * 4.0f));
        }
    }

    public void spawnAlly(double x, double y, double z) {
        EntityWraith minion = (EntityWraith)CreatureManager.getInstance().getCreature("wraith").createEntity(this.func_130014_f_());
        minion.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        minion.setMinion(true);
        minion.setMasterTarget((EntityLivingBase)this);
        this.func_130014_f_().func_72838_d((Entity)minion);
        if (this.func_70638_az() != null) {
            minion.func_70604_c(this.func_70638_az());
        }
        minion.setSizeScale(this.sizeScale);
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public boolean canAttackEntity(EntityLivingBase target) {
        if (target instanceof EntityTrite || target instanceof EntityAstaroth || target instanceof EntityAsmodeus || target instanceof EntityWraith) {
            return false;
        }
        return super.canAttackEntity(target);
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile("demonicblast", target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 0.6f, 2.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public boolean isDamageEntityApplicable(Entity entity) {
        if (entity instanceof EntityCacodemon) {
            return false;
        }
        return super.isDamageEntityApplicable(entity);
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if ("explosion".equals(type)) {
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public double func_70042_X() {
        return (double)this.field_70131_O * 0.9;
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.hasPickupEntity()) {
            this.dropPickupEntity();
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        if (rider instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)rider;
            ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile("demonicblast");
            if (projectileInfo != null) {
                BaseProjectileEntity projectile = projectileInfo.createProjectile(this.func_130014_f_(), (EntityLivingBase)player);
                this.func_130014_f_().func_72838_d((Entity)projectile);
                this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                this.triggerAttackCooldown();
            }
        }
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 10.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 40;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    public float func_70013_c() {
        if (this.isAttackOnCooldown()) {
            return 1.0f;
        }
        return super.func_70013_c();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        if (this.isAttackOnCooldown()) {
            return 0xF000F0;
        }
        return super.func_70070_b();
    }
}

