/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.info.ElementInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import com.lycanitesmobs.core.info.projectile.behaviours.ProjectileBehaviour;
import com.lycanitesmobs.core.info.projectile.behaviours.ProjectileBehaviourLaser;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CustomProjectileEntity
extends BaseProjectileEntity {
    public ProjectileInfo projectileInfo;
    protected int throwerId = -1;
    protected BaseProjectileEntity parent;
    protected Entity target;
    protected int parentId = -1;
    protected int targetId = -1;
    protected Vec3d laserEnd;
    public float laserWidth;
    public float laserAngle;
    public List<BaseProjectileEntity> spawnedProjectiles = new ArrayList<BaseProjectileEntity>();
    protected static final DataParameter<String> PROJECTILE_NAME = EntityDataManager.func_187226_a(CustomProjectileEntity.class, (DataSerializer)DataSerializers.field_187194_d);
    protected static final DataParameter<Integer> THROWING_ENTITY_ID = EntityDataManager.func_187226_a(CustomProjectileEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> PARENT_PROJECTILE_ID = EntityDataManager.func_187226_a(CustomProjectileEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> TARGET_ID = EntityDataManager.func_187226_a(CustomProjectileEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Float> LASER_ANGLE = EntityDataManager.func_187226_a(CustomProjectileEntity.class, (DataSerializer)DataSerializers.field_187193_c);

    public CustomProjectileEntity(World world) {
        super(world);
        this.field_70180_af.func_187214_a(PROJECTILE_NAME, (Object)"");
        this.modInfo = LycanitesMobs.modInfo;
    }

    public CustomProjectileEntity(World world, ProjectileInfo projectileInfo) {
        super(world);
        this.field_70180_af.func_187214_a(PROJECTILE_NAME, (Object)"");
        this.modInfo = LycanitesMobs.modInfo;
        this.setProjectileInfo(projectileInfo);
    }

    public CustomProjectileEntity(World world, EntityLivingBase entityLiving, ProjectileInfo projectileInfo) {
        super(world, entityLiving);
        if (projectileInfo != null) {
            this.func_184538_a((Entity)entityLiving, entityLiving.field_70125_A, entityLiving.field_70177_z, 0.0f, (float)projectileInfo.velocity, 1.0f);
        }
        this.field_70180_af.func_187214_a(PROJECTILE_NAME, (Object)"");
        this.modInfo = LycanitesMobs.modInfo;
        this.setProjectileInfo(projectileInfo);
    }

    public CustomProjectileEntity(World world, double x, double y, double z, ProjectileInfo projectileInfo) {
        super(world, x, y, z);
        this.field_70180_af.func_187214_a(PROJECTILE_NAME, (Object)"");
        this.modInfo = LycanitesMobs.modInfo;
        this.setProjectileInfo(projectileInfo);
    }

    @Override
    public void setup() {
        super.setup();
        this.field_70180_af.func_187214_a(THROWING_ENTITY_ID, (Object)this.throwerId);
        this.field_70180_af.func_187214_a(PARENT_PROJECTILE_ID, (Object)this.parentId);
        this.field_70180_af.func_187214_a(TARGET_ID, (Object)this.targetId);
        this.field_70180_af.func_187214_a(LASER_ANGLE, (Object)Float.valueOf(this.laserAngle));
    }

    public void loadProjectileInfo(String projectileName) {
        this.setProjectileInfo(ProjectileManager.getInstance().getProjectile(projectileName));
    }

    public void setProjectileInfo(ProjectileInfo projectileInfo) {
        this.projectileInfo = projectileInfo;
        if (this.projectileInfo == null) {
            return;
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(PROJECTILE_NAME, (Object)this.projectileInfo.getName());
        }
        this.modInfo = this.projectileInfo.modInfo;
        this.entityName = this.projectileInfo.getName();
        this.setProjectileScale(this.projectileInfo.scale);
        this.func_70105_a(this.projectileInfo.width, this.projectileInfo.height);
        this.projectileLife = this.projectileInfo.lifetime;
        this.setDamage(this.projectileInfo.damage);
        this.setPierce(this.projectileInfo.pierce);
        this.knockbackChance = this.projectileInfo.knockbackChance;
        this.weight = this.projectileInfo.weight;
        this.rollSpeed = this.projectileInfo.rollSpeed;
        if (this.rollSpeed > 0.0f && this.field_70146_Z.nextBoolean()) {
            this.rollSpeed = -this.rollSpeed;
        }
        this.waterProof = this.projectileInfo.waterproof;
        this.lavaProof = this.projectileInfo.lavaproof;
        this.cutsGrass = this.projectileInfo.cutGrass;
        this.ripper = this.projectileInfo.ripper;
        this.pierceBlocks = this.projectileInfo.pierceBlocks;
        this.animationFrameMax = this.projectileInfo.animationFrames;
    }

    @Override
    public void func_70071_h_() {
        if (this.projectileInfo == null) {
            this.loadProjectileInfo(this.getStringFromDataManager(PROJECTILE_NAME));
        }
        super.func_70071_h_();
        if (this.projectileInfo != null) {
            for (ProjectileBehaviour behaviour : this.projectileInfo.behaviours) {
                behaviour.onProjectileUpdate(this);
            }
            if (this.func_130014_f_().field_72995_K && this.projectileInfo.particleCount > 0) {
                for (int i = 0; i < this.projectileInfo.particleCount; ++i) {
                    if (this.projectileInfo.waterParticleType != null && this.func_70090_H()) {
                        this.func_130014_f_().func_175688_a(this.projectileInfo.waterParticleType, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150346_d.func_176223_P())});
                        continue;
                    }
                    if (this.projectileInfo.particleType == null) continue;
                    this.func_130014_f_().func_175688_a(this.projectileInfo.particleType, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150346_d.func_176223_P())});
                }
            }
        }
    }

    public void syncThrower() {
        if (!this.func_130014_f_().field_72995_K) {
            this.throwerId = this.func_85052_h() != null ? this.func_85052_h().func_145782_y() : -1;
            this.field_70180_af.func_187227_b(THROWING_ENTITY_ID, (Object)this.throwerId);
        } else {
            this.throwerId = (Integer)this.field_70180_af.func_187225_a(THROWING_ENTITY_ID);
            if (this.throwerId == -1) {
                this.field_70192_c = null;
            } else if (this.func_85052_h() == null || this.func_85052_h().func_145782_y() != this.throwerId) {
                Entity possibleThrower = this.func_130014_f_().func_73045_a(this.throwerId);
                this.field_70192_c = possibleThrower instanceof EntityLivingBase ? (EntityLivingBase)possibleThrower : null;
            }
        }
    }

    @Override
    public boolean canDamage(EntityLivingBase targetEntity) {
        boolean canDamage = super.canDamage(targetEntity);
        if (this.projectileInfo != null) {
            for (ProjectileBehaviour behaviour : this.projectileInfo.behaviours) {
                if (behaviour.canDamage(this, this.func_130014_f_(), targetEntity, canDamage)) continue;
                canDamage = false;
            }
        }
        return canDamage;
    }

    public boolean shouldChannel() {
        if (this.projectileInfo != null) {
            for (ProjectileBehaviour behaviour : this.projectileInfo.behaviours) {
                if (!(behaviour instanceof ProjectileBehaviourLaser)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setProjectileScale(float scale) {
        super.setProjectileScale(scale);
        if (this.projectileInfo != null) {
            this.func_70105_a(this.projectileInfo.width * this.projectileScale, this.projectileInfo.height * this.projectileScale);
        }
    }

    @Override
    public void onDamage(EntityLivingBase target, float damage, boolean attackSuccess) {
        super.onDamage(target, damage, attackSuccess);
        if (!this.func_130014_f_().field_72995_K && attackSuccess && this.projectileInfo != null) {
            for (ElementInfo element : this.projectileInfo.elements) {
                element.debuffEntity(target, this.projectileInfo.effectDuration * 20, this.projectileInfo.effectAmplifier);
            }
        }
        if (attackSuccess && this.projectileInfo != null) {
            for (ProjectileBehaviour behaviour : this.projectileInfo.behaviours) {
                behaviour.onProjectileDamage(this, this.func_130014_f_(), target, damage);
            }
        }
    }

    @Override
    public void onImpactComplete(BlockPos impactPos) {
        super.onImpactComplete(impactPos);
        if (this.projectileInfo == null) {
            return;
        }
        for (ProjectileBehaviour behaviour : this.projectileInfo.behaviours) {
            behaviour.onProjectileImpact(this, this.func_130014_f_(), impactPos);
        }
    }

    public void setParent(BaseProjectileEntity parent) {
        this.parent = parent;
        if (!this.func_130014_f_().field_72995_K) {
            this.parentId = this.parent != null ? this.parent.func_145782_y() : -1;
            this.field_70180_af.func_187227_b(PARENT_PROJECTILE_ID, (Object)this.parentId);
        }
    }

    public BaseProjectileEntity getParent() {
        if (this.func_130014_f_().field_72995_K) {
            Entity possibleParent;
            this.parentId = (Integer)this.field_70180_af.func_187225_a(PARENT_PROJECTILE_ID);
            if (this.parentId == -1) {
                this.parent = null;
            } else if ((this.parent == null || this.parent.func_145782_y() != this.parentId) && (possibleParent = this.func_130014_f_().func_73045_a(this.parentId)) instanceof BaseProjectileEntity) {
                this.parent = (BaseProjectileEntity)possibleParent;
            }
        }
        return this.parent;
    }

    public void setTarget(Entity target) {
        this.target = target;
        if (!this.func_130014_f_().field_72995_K) {
            this.targetId = this.target != null ? this.target.func_145782_y() : -1;
            this.field_70180_af.func_187227_b(TARGET_ID, (Object)this.targetId);
        }
    }

    public Entity getTarget() {
        if (this.func_130014_f_().field_72995_K) {
            this.targetId = (Integer)this.field_70180_af.func_187225_a(TARGET_ID);
            if (this.targetId == -1) {
                this.target = null;
            } else if (this.target == null || this.target.func_145782_y() != this.targetId) {
                this.target = this.func_130014_f_().func_73045_a(this.targetId);
            }
        }
        return this.target;
    }

    public void setLaserEnd(Vec3d laserEnd) {
        this.laserEnd = laserEnd;
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(LASER_ANGLE, (Object)Float.valueOf(this.laserAngle));
        }
    }

    public Vec3d getLaserEnd() {
        if (this.func_130014_f_().field_72995_K) {
            this.laserAngle = ((Float)this.field_70180_af.func_187225_a(LASER_ANGLE)).floatValue();
        }
        return this.laserEnd;
    }

    public boolean func_70027_ad() {
        return this.projectileInfo != null && this.projectileInfo.burningEffect;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.projectileInfo != null) {
            compound.func_74778_a("ProjectileName", this.projectileInfo.getName());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("ProjectileName")) {
            this.loadProjectileInfo(compound.func_74779_i("ProjectileName"));
        }
    }

    @Override
    public String getTextureName() {
        return this.entityName;
    }

    public ResourceLocation getBeamTexture() {
        String textureName = this.getTextureName() + "_beam";
        if (AssetManager.getTexture(textureName) == null) {
            AssetManager.addTexture(textureName, this.modInfo, "textures/items/" + textureName + ".png");
        }
        return AssetManager.getTexture(textureName);
    }

    public float func_70013_c() {
        if (this.projectileInfo == null || !this.projectileInfo.glow) {
            return super.func_70013_c();
        }
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        if (this.projectileInfo == null || !this.projectileInfo.glow) {
            return super.func_70070_b();
        }
        return 0xF000F0;
    }

    @Override
    public SoundEvent getLaunchSound() {
        if (this.projectileInfo != null) {
            return this.projectileInfo.getLaunchSound();
        }
        return super.getLaunchSound();
    }

    @Override
    public SoundEvent getImpactSound() {
        if (this.projectileInfo != null) {
            return this.projectileInfo.getImpactSound();
        }
        return super.getImpactSound();
    }
}

