/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.core.block.building.BlockPropolis;
import com.lycanitesmobs.core.block.building.BlockVeswax;
import com.lycanitesmobs.core.dungeon.definition.DungeonTheme;
import com.lycanitesmobs.core.dungeon.definition.ThemeBlock;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.CreatureBuildTask;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.IFluidBlock;

public class CreatureStructure {
    protected BaseCreatureEntity owner;
    protected DungeonTheme dungeonTheme;
    protected Map<Integer, Map<BlockPos, CreatureBuildTask>> buildTasks = new HashMap<Integer, Map<BlockPos, CreatureBuildTask>>();
    protected BlockPos origin;
    protected BlockPos startPos;

    public CreatureStructure(BaseCreatureEntity creatureEntity, DungeonTheme dungeonTheme) {
        this.owner = creatureEntity;
        this.dungeonTheme = dungeonTheme;
        this.origin = creatureEntity.func_180425_c();
        if (this.dungeonTheme == null) {
            throw new RuntimeException("Unable to find the vespid_hive dungeon theme!");
        }
    }

    public BlockPos getOrigin() {
        return this.origin;
    }

    public void setOrigin(BlockPos blockPos) {
        this.origin = blockPos;
        this.startPos = blockPos.func_177982_a(0, 8, 0);
    }

    public void refreshBuildTasks() {
        BlockPos blockPos;
        int z;
        int y;
        int x;
        this.buildTasks.clear();
        int radius = 8;
        for (x = -radius; x <= radius; ++x) {
            for (y = -radius; y <= radius; ++y) {
                for (z = -radius; z <= radius; ++z) {
                    if (Math.abs(x) == radius && Math.abs(z) == radius || !this.shouldBuildAt(blockPos = this.origin.func_177982_a(x, y, z))) continue;
                    IBlockState blockState = Math.abs(y) <= 1 && (Math.abs(x) <= 1 || Math.abs(z) <= 1) ? Blocks.field_150350_a.func_176223_P() : (Math.abs(x) < radius && Math.abs(y) < radius && Math.abs(z) < radius ? Blocks.field_150350_a.func_176223_P() : (y == radius ? this.dungeonTheme.getCeiling(null, '1', this.owner.func_70681_au()) : (y == -radius ? this.dungeonTheme.getFloor(null, '1', this.owner.func_70681_au()) : this.dungeonTheme.getWall(null, '1', this.owner.func_70681_au()))));
                    this.createBuildTask(blockState, blockPos, 1);
                }
            }
        }
        for (x = -radius; x <= radius; ++x) {
            for (y = -radius; y <= radius; ++y) {
                for (z = -radius; z <= radius; ++z) {
                    IBlockState blockState;
                    int pitLayer;
                    if (Math.abs(x) < radius / 4 + 1 && Math.abs(z) < radius / 4 + 1 || !this.shouldBuildAt(blockPos = this.origin.func_177982_a(x, y, z))) continue;
                    for (pitLayer = 1; pitLayer <= radius / 2; ++pitLayer) {
                        if (y != radius - pitLayer || Math.abs(x) >= radius - pitLayer || Math.abs(z) >= radius - pitLayer) continue;
                        blockState = this.dungeonTheme.getPit('1', this.owner.func_70681_au());
                        this.createBuildTask(blockState, blockPos, 1);
                    }
                    for (pitLayer = 1; pitLayer <= radius / 2; ++pitLayer) {
                        if (y != -radius + pitLayer || Math.abs(x) >= radius - pitLayer || Math.abs(z) >= radius - pitLayer) continue;
                        blockState = this.dungeonTheme.getPit('1', this.owner.func_70681_au());
                        this.createBuildTask(blockState, blockPos, 1);
                    }
                }
            }
        }
        for (x = -radius; x <= radius; ++x) {
            for (y = -radius; y <= radius; ++y) {
                for (z = -radius; z <= radius; ++z) {
                    if (Math.abs(x) >= radius / 4 + 1 || y > -(radius / 2) || y <= -radius || Math.abs(z) >= radius / 4 + 1 || !this.shouldBuildAt(blockPos = this.origin.func_177982_a(x, y, z))) continue;
                    IBlockState blockState = this.dungeonTheme.getPit('2', this.owner.func_70681_au());
                    this.createBuildTask(blockState, blockPos, 1);
                }
            }
        }
    }

    public void createBuildTask(IBlockState blockState, BlockPos blockPos, int phase) {
        IBlockState targetBlockState = this.owner.func_130014_f_().func_180495_p(blockPos);
        if (blockState == targetBlockState || !(blockState.func_177230_c() instanceof IFluidBlock) && blockState.func_177230_c() == targetBlockState.func_177230_c()) {
            for (Map<BlockPos, CreatureBuildTask> phasedBuildTasks : this.buildTasks.values()) {
                phasedBuildTasks.remove(blockPos);
            }
            return;
        }
        CreatureBuildTask buildTask = new CreatureBuildTask(blockState, blockPos, phase);
        if (!this.buildTasks.containsKey(phase)) {
            this.buildTasks.put(phase, new HashMap());
        }
        this.buildTasks.get(phase).put(blockPos, buildTask);
    }

    protected boolean shouldBuildAt(BlockPos pos) {
        IBlockState targetState = this.owner.func_130014_f_().func_180495_p(pos);
        Block targetBlock = targetState.func_177230_c();
        if (targetBlock == Blocks.field_150350_a) {
            return true;
        }
        return this.owner.func_130014_f_().func_175625_s(pos) == null;
    }

    @Nullable
    public CreatureBuildTask takeBuildTask(EntityLivingBase builder) {
        if (this.buildTasks.isEmpty()) {
            return null;
        }
        for (int phase : this.buildTasks.keySet()) {
            if (this.buildTasks.get(phase).isEmpty()) continue;
            CreatureBuildTask[] phasedBuildTasks = this.buildTasks.get(phase).values().toArray(new CreatureBuildTask[0]);
            if (phasedBuildTasks.length == 1) {
                return phasedBuildTasks[0];
            }
            return phasedBuildTasks[builder.func_70681_au().nextInt(phasedBuildTasks.length)];
        }
        return null;
    }

    public void completeBuildTask(CreatureBuildTask buildTask) {
        for (int phase : this.buildTasks.keySet()) {
            if (this.buildTasks.get(phase).isEmpty()) continue;
            this.buildTasks.get(phase).remove(buildTask.pos);
            this.owner.onBuildTaskComplete(buildTask);
        }
    }

    public boolean isPhaseComplete(int phase) {
        return this.getBuildTaskSize(phase) == 0;
    }

    public int getBuildTaskSize(int phase) {
        if (!this.buildTasks.containsKey(phase)) {
            return 0;
        }
        return this.buildTasks.get(phase).size();
    }

    public int getFinalPhaseBuildTaskSize() {
        return this.getBuildTaskSize(this.buildTasks.size() - 1);
    }

    public void removePitBLocks() {
        int radius = 10;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos blockPos = this.getOrigin().func_177982_a(x, y, z);
                    IBlockState blockState = this.owner.func_130014_f_().func_180495_p(blockPos);
                    if (blockState.func_177230_c() instanceof BlockPropolis || blockState.func_177230_c() instanceof BlockVeswax) continue;
                    if (blockState.func_177230_c() == this.dungeonTheme.getPit('1', this.owner.func_70681_au()).func_177230_c()) {
                        this.owner.func_130014_f_().func_175698_g(blockPos);
                        continue;
                    }
                    if (blockState.func_177230_c() != this.dungeonTheme.getPit('2', this.owner.func_70681_au()).func_177230_c()) continue;
                    this.owner.func_130014_f_().func_175698_g(blockPos);
                }
            }
        }
    }

    protected boolean isStructureBlock(BlockPos blockPos) {
        IBlockState targetState = this.owner.func_130014_f_().func_180495_p(blockPos);
        Block targetBlock = targetState.func_177230_c();
        if (targetBlock == Blocks.field_150350_a) {
            return false;
        }
        for (ThemeBlock themeBlock : this.dungeonTheme.ceilingBlocks) {
            if (targetBlock != themeBlock.getBlockState().func_177230_c()) continue;
            return true;
        }
        for (ThemeBlock themeBlock : this.dungeonTheme.floorBlocks) {
            if (targetBlock != themeBlock.getBlockState().func_177230_c()) continue;
            return true;
        }
        for (ThemeBlock themeBlock : this.dungeonTheme.wallBlocks) {
            if (targetBlock != themeBlock.getBlockState().func_177230_c()) continue;
            return true;
        }
        return false;
    }
}

