/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.dungeon.instance;

import com.lycanitesmobs.core.dungeon.instance.DungeonLayout;
import com.lycanitesmobs.core.dungeon.instance.SectorInstance;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class SectorConnector {
    public BlockPos position;
    public SectorInstance parentSector;
    public SectorInstance childSector;
    public EnumFacing facing = EnumFacing.SOUTH;
    public boolean closed = false;
    public int level = 0;

    public SectorConnector(BlockPos position, SectorInstance parentSector, int level, EnumFacing facing) {
        this.position = position;
        this.parentSector = parentSector;
        this.level = level;
        this.facing = facing;
    }

    public boolean canConnect(DungeonLayout dungeonLayout, SectorInstance sectorInstance) {
        if (this.closed) {
            return false;
        }
        if (sectorInstance == null) {
            return this.facing != EnumFacing.UP;
        }
        if ("tower".equalsIgnoreCase(sectorInstance.dungeonSector.type)) {
            return this.facing == EnumFacing.UP;
        }
        if (this.facing == EnumFacing.UP) {
            return false;
        }
        boolean tempConnector = false;
        if (sectorInstance.parentConnector == null) {
            sectorInstance.parentConnector = this;
            tempConnector = true;
        }
        for (SectorInstance nearbySector : sectorInstance.getNearbySectors()) {
            if (!sectorInstance.collidesWith(nearbySector)) continue;
            if (tempConnector) {
                sectorInstance.parentConnector = null;
            }
            return false;
        }
        if (tempConnector) {
            sectorInstance.parentConnector = null;
        }
        return true;
    }

    public void buildEntrance(World world, ChunkPos chunkPos, Random random) {
        SectorInstance sectorInstance = this.parentSector;
        if (sectorInstance == null) {
            sectorInstance = this.childSector;
        }
        if (sectorInstance == null) {
            return;
        }
        Vec3i size = sectorInstance.getRoomSize();
        if (this.childSector != null && sectorInstance != this.childSector) {
            Vec3i childSize = this.childSector.getRoomSize();
            size = new Vec3i(Math.min(size.func_177958_n(), childSize.func_177958_n()), Math.min(size.func_177956_o(), childSize.func_177956_o()), Math.min(size.func_177952_p(), childSize.func_177952_p()));
        }
        int entranceHeight = 2;
        int entranceRadius = 1;
        int startX = this.position.func_177958_n();
        int stopX = this.position.func_177958_n();
        int startY = Math.max(1, this.position.func_177956_o() + 1);
        int stopY = Math.min(world.func_72800_K() - 1, this.position.func_177956_o() + 1 + entranceHeight);
        int startZ = this.position.func_177952_p();
        int stopZ = this.position.func_177952_p();
        if (this.facing.func_176740_k() == EnumFacing.Axis.Z) {
            startX -= entranceRadius;
            stopX += entranceRadius;
            if (size.func_177958_n() % 2 != 0) {
                --startX;
            }
            if (this.facing == EnumFacing.SOUTH) {
                startZ -= 2;
                ++stopZ;
            } else {
                --startZ;
                stopZ += 2;
            }
        } else {
            startZ -= entranceRadius;
            stopZ += entranceRadius;
            if (size.func_177952_p() % 2 != 0) {
                --startZ;
            }
            if (this.facing == EnumFacing.EAST) {
                startX -= 2;
                ++stopX;
            } else {
                --startX;
                stopX += 2;
            }
        }
        BlockPos.MutableBlockPos buildPos = new BlockPos.MutableBlockPos();
        for (int x = startX; x <= stopX; ++x) {
            for (int y = startY; y <= stopY; ++y) {
                for (int z = startZ; z <= stopZ; ++z) {
                    IBlockState blockState;
                    buildPos.func_181079_c(x, y, z);
                    if (world.func_175625_s((BlockPos)buildPos) != null || (blockState = sectorInstance.getAirBlockForPos((BlockPos)buildPos)) == null) continue;
                    sectorInstance.placeBlock(world, chunkPos, (BlockPos)buildPos, blockState, this.facing, random);
                }
            }
        }
    }

    public void buildTest(World world, ChunkPos chunkPos, Random random) {
        SectorInstance sectorInstance = this.parentSector;
        if (sectorInstance == null) {
            sectorInstance = this.childSector;
        }
        if (sectorInstance == null) {
            return;
        }
        sectorInstance.placeBlock(world, chunkPos, this.position.func_177982_a(0, 1, 0), Blocks.field_150340_R.func_176223_P(), EnumFacing.SOUTH, random);
        if (this.facing == EnumFacing.SOUTH) {
            for (int z = 1; z <= 3; ++z) {
                sectorInstance.placeBlock(world, chunkPos, this.position.func_177982_a(0, 1, z), Blocks.field_150451_bX.func_176223_P(), EnumFacing.SOUTH, random);
            }
        } else if (this.facing == EnumFacing.EAST) {
            for (int x = 1; x <= 3; ++x) {
                sectorInstance.placeBlock(world, chunkPos, this.position.func_177982_a(x, 1, 0), Blocks.field_150451_bX.func_176223_P(), EnumFacing.SOUTH, random);
            }
        } else if (this.facing == EnumFacing.NORTH) {
            for (int z = -1; z >= -3; --z) {
                sectorInstance.placeBlock(world, chunkPos, this.position.func_177982_a(0, 1, z), Blocks.field_150451_bX.func_176223_P(), EnumFacing.SOUTH, random);
            }
        } else {
            for (int x = -1; x >= -3; --x) {
                sectorInstance.placeBlock(world, chunkPos, this.position.func_177982_a(x, 1, 0), Blocks.field_150451_bX.func_176223_P(), EnumFacing.SOUTH, random);
            }
        }
    }
}

