/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.template.ModelTemplateElemental;
import com.lycanitesmobs.client.renderer.RenderCreature;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureEffect;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureScrolling;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelWisp
extends ModelTemplateElemental {
    float maxLeg = 0.0f;

    public ModelWisp() {
        this(1.0f);
    }

    public ModelWisp(float shadowSize) {
        this.initModel("wisp", LycanitesMobs.modInfo, "entity/wisp");
        this.trophyScale = 1.2f;
        this.trophyOffset = new float[]{0.0f, 0.0f, -0.4f};
    }

    @Override
    public void addCustomLayers(RenderCreature renderer) {
        super.addCustomLayers(renderer);
        renderer.func_177094_a(new LayerCreatureEffect(renderer, "ball", true, LayerCreatureEffect.BLEND.NORMAL.id, true));
        renderer.func_177094_a(new LayerCreatureEffect(renderer, "ball_glow", "ball", true, LayerCreatureEffect.BLEND.ADD.id, true));
        renderer.func_177094_a(new LayerCreatureScrolling(renderer, "hair", true, LayerCreatureEffect.BLEND.NORMAL.id, true, new Vector2f(0.0f, 4.0f)));
    }

    @Override
    public void animatePart(String partName, EntityLiving entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        if (partName.equals("haircenter")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.1f)) * 0.1f), 0.0f, 0.0f);
        } else if (partName.equals("hairleft")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.05f)) * 0.1f), (float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.1f)) * 0.2f - 0.2f), 0.0f);
        } else if (partName.equals("hairright")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.05f)) * 0.1f), -((float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.1f)) * 0.2f - 0.2f)), 0.0f);
        } else if (partName.contains("fringeleft")) {
            this.rotate(-((float)Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f)), 0.0f, -((float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.1f)));
        } else if (partName.contains("fringeright")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f), 0.0f, (float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.1f));
        } else if (partName.equals("armleft")) {
            this.rotate(0.0f, 0.0f, (float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.1f));
        } else if (partName.equals("armright")) {
            this.rotate(0.0f, 0.0f, -((float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.1f)));
        }
        if (entity instanceof BaseCreatureEntity && ((BaseCreatureEntity)entity).isAttackOnCooldown()) {
            if (partName.equals("armleft")) {
                this.rotate(0.0f, 25.0f, 25.0f);
            }
            if (partName.equals("armright")) {
                this.rotate(0.0f, -25.0f, -25.0f);
            }
        }
    }

    @Override
    public boolean canRenderPart(String partName, Entity entity, LayerCreatureBase layer, boolean trophy) {
        if (partName.contains("ball") && entity instanceof BaseCreatureEntity && ((BaseCreatureEntity)entity).isAttackOnCooldown()) {
            return false;
        }
        if (partName.equals("ball01")) {
            return layer != null && "ball".equals(layer.name);
        }
        if (partName.equals("ball02") || partName.equals("ball03")) {
            return layer != null && "ball_glow".equals(layer.name);
        }
        if (partName.contains("fringe")) {
            return layer != null && "hair".equals(layer.name);
        }
        if (partName.contains("hair")) {
            return layer != null && "hair".equals(layer.name);
        }
        return layer == null;
    }

    @Override
    public Vector4f getPartColor(String partName, Entity entity, LayerCreatureBase layer, boolean trophy, float loop) {
        if (layer != null && ("ball".equals(layer.name) || "ball_glow".equals(layer.name))) {
            float glowSpeed = 40.0f;
            float glow = loop * glowSpeed % 360.0f;
            float color = (float)Math.cos(Math.toRadians(glow)) * 0.1f + 0.9f;
            return new Vector4f(color, color, color, 1.0f);
        }
        return super.getPartColor(partName, entity, layer, trophy, loop);
    }

    @Override
    public void onRenderStart(LayerCreatureBase layer, Entity entity, boolean renderAsTrophy) {
        super.onRenderStart(layer, entity, renderAsTrophy);
        GlStateManager.func_179140_f();
    }

    @Override
    public void onRenderFinish(LayerCreatureBase layer, Entity entity, boolean renderAsTrophy) {
        super.onRenderFinish(layer, entity, renderAsTrophy);
        GlStateManager.func_179145_e();
    }
}

