/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui.overlays;

import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.client.KeyHandler;
import com.lycanitesmobs.client.gui.BaseGui;
import com.lycanitesmobs.client.gui.DrawHelper;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.CreatureRelationshipEntry;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.item.temp.ItemStaffSummoning;
import com.lycanitesmobs.core.mobevent.MobEventPlayerClient;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class BaseOverlay
extends BaseGui {
    public DrawHelper drawHelper;
    public Minecraft minecraft;
    protected ScaledResolution scaledResolution;
    private int mountMessageTimeMax = 200;
    private int mountMessageTime = 0;

    public BaseOverlay(Minecraft minecraft) {
        this.minecraft = minecraft;
        this.drawHelper = new DrawHelper(minecraft, LycanitesMobs.proxy.getFontRenderer());
        this.scaledResolution = new ScaledResolution(this.minecraft);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderExperienceBar(RenderGameOverlayEvent event) {
        Entity mouseOverEntity;
        ExtendedPlayer playerExt;
        if (LycanitesMobs.proxy.getClientPlayer() == null) {
            return;
        }
        EntityPlayer player = LycanitesMobs.proxy.getClientPlayer();
        if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ScaledResolution scaledresolution = new ScaledResolution(this.minecraft);
        int sWidth = scaledresolution.func_78326_a();
        int sHeight = scaledresolution.func_78328_b();
        ExtendedWorld worldExt = ExtendedWorld.getForWorld(player.func_130014_f_());
        if (worldExt != null) {
            for (MobEventPlayerClient mobEventPlayerClient : worldExt.clientMobEventPlayers.values()) {
                GlStateManager.func_179094_E();
                mobEventPlayerClient.onGUIUpdate(this, sWidth, sHeight);
                GlStateManager.func_179121_F();
            }
            if (worldExt.clientWorldEventPlayer != null) {
                GlStateManager.func_179094_E();
                worldExt.clientWorldEventPlayer.onGUIUpdate(this, sWidth, sHeight);
                GL11.glPopMatrix();
            }
        }
        if ((playerExt = ExtendedPlayer.getForPlayer(player)) != null && !this.minecraft.field_71439_g.field_71075_bZ.field_75098_d && (this.minecraft.field_71439_g.func_184586_b(EnumHand.MAIN_HAND) != null && this.minecraft.field_71439_g.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemStaffSummoning || this.minecraft.field_71439_g.func_184586_b(EnumHand.OFF_HAND) != null && this.minecraft.field_71439_g.func_184586_b(EnumHand.OFF_HAND).func_77973_b() instanceof ItemStaffSummoning)) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.minecraft.func_110434_K().func_110577_a(AssetManager.getTexture("GUIInventoryCreature"));
            int barYSpace = 10;
            int barXSpace = -1;
            int summonBarWidth = 9;
            int summonBarHeight = 9;
            int summonBarX = sWidth / 2 + 10;
            int summonBarY = sHeight - 30 - summonBarHeight;
            int summonBarU = 256 - summonBarWidth;
            int summonBarV = 256 - summonBarHeight;
            summonBarY -= barYSpace;
            if (this.minecraft.field_71439_g.func_70055_a(Material.field_151586_h)) {
                summonBarY -= barYSpace;
            }
            for (int summonBarEnergyN = 0; summonBarEnergyN < 10; ++summonBarEnergyN) {
                this.func_73729_b(summonBarX + (summonBarWidth + barXSpace) * summonBarEnergyN, summonBarY, summonBarU, summonBarV, summonBarWidth, summonBarHeight);
                if (playerExt.summonFocus >= playerExt.summonFocusMax - summonBarEnergyN * playerExt.summonFocusCharge) {
                    this.func_73729_b(summonBarX + (summonBarWidth + barXSpace) * summonBarEnergyN, summonBarY, summonBarU - summonBarWidth, summonBarV, summonBarWidth, summonBarHeight);
                    continue;
                }
                if (playerExt.summonFocus + playerExt.summonFocusCharge <= playerExt.summonFocusMax - summonBarEnergyN * playerExt.summonFocusCharge) continue;
                float summonChargeScale = (float)(playerExt.summonFocus % playerExt.summonFocusCharge) / (float)playerExt.summonFocusCharge;
                this.func_73729_b(summonBarX + (summonBarWidth + barXSpace) * summonBarEnergyN + (summonBarWidth - Math.round((float)summonBarWidth * summonChargeScale)), summonBarY, summonBarU - Math.round((float)summonBarWidth * summonChargeScale), summonBarV, Math.round((float)summonBarWidth * summonChargeScale), summonBarHeight);
            }
        }
        if (this.minecraft.field_71439_g.func_184187_bx() != null && this.minecraft.field_71439_g.func_184187_bx() instanceof RideableCreatureEntity) {
            RideableCreatureEntity mount = (RideableCreatureEntity)this.minecraft.field_71439_g.func_184187_bx();
            float mountStamina = mount.getStaminaPercent();
            if (this.mountMessageTime > 0) {
                String mountMessage = LanguageManager.translate("gui.mount.controls");
                mountMessage = mountMessage.replace("%controlA%", GameSettings.func_74298_c((int)KeyHandler.instance.mountAbility.func_151463_i()));
                mountMessage = mountMessage.replace("%controlB%", GameSettings.func_74298_c((int)KeyHandler.instance.dismount.func_151463_i()));
                this.minecraft.field_71456_v.func_110326_a(mountMessage, false);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.minecraft.func_110434_K().func_110577_a(field_110324_m);
            int staminaBarWidth = 182;
            int staminaBarHeight = 5;
            int staminaEnergyWidth = (int)((float)(staminaBarWidth + 1) * mountStamina);
            int staminaBarX = sWidth / 2 - staminaBarWidth / 2;
            int staminaBarY = sHeight - 32 + 3;
            int staminaTextureY = 84;
            if ("toggle".equals(mount.getStaminaType())) {
                staminaTextureY -= staminaBarHeight * 2;
            }
            int staminaEnergyY = staminaTextureY + staminaBarHeight;
            this.func_73729_b(staminaBarX, staminaBarY, 0, staminaTextureY, staminaBarWidth, staminaBarHeight);
            if (staminaEnergyWidth > 0) {
                this.func_73729_b(staminaBarX, staminaBarY, 0, staminaEnergyY, staminaEnergyWidth, staminaBarHeight);
            }
            if (this.mountMessageTime > 0) {
                --this.mountMessageTime;
            }
        } else {
            this.mountMessageTime = this.mountMessageTimeMax;
        }
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        if (mouseOver != null && (mouseOverEntity = mouseOver.field_72308_g) != null && mouseOverEntity instanceof BaseCreatureEntity) {
            BaseCreatureEntity creatureEntity = (BaseCreatureEntity)mouseOverEntity;
            CreatureInfo creatureInfo = creatureEntity.creatureInfo;
            CreatureRelationshipEntry relationshipEntry = creatureEntity.relationships.getEntry((Entity)player);
            if (relationshipEntry != null && relationshipEntry.getReputation() > 0 && !creatureEntity.isTamed()) {
                float barWidth = 100.0f;
                float barHeight = 11.0f;
                float barX = (float)sWidth / 2.0f - barWidth / 2.0f;
                float barY = (float)sHeight * 0.75f;
                float barCenter = barX + barWidth / 2.0f;
                this.drawHelper.drawTexture(AssetManager.getTexture("GUIPetBarEmpty"), barX, barY, 0.0f, 1.0f, 1.0f, barWidth, barHeight);
                float reputationNormal = Math.min(1.0f, (float)relationshipEntry.getReputation() / (float)creatureInfo.getTamingReputation());
                String barFillTexture = "GUIPetBarRespawn";
                if (relationshipEntry.getReputation() >= creatureInfo.getFriendlyReputation()) {
                    barFillTexture = "GUIPetBarHealth";
                }
                this.drawHelper.drawTexture(AssetManager.getTexture(barFillTexture), barX, barY, 0.0f, reputationNormal, 1.0f, barWidth * reputationNormal, barHeight);
                String reputationText = LanguageManager.translate("entity.reputation") + ": " + relationshipEntry.getReputation() + "/" + creatureInfo.getTamingReputation();
                this.drawHelper.getFontRenderer().func_78276_b(reputationText, Math.round(barCenter - (float)this.drawHelper.getStringWidth(reputationText) / 2.0f), Math.round(barY + 2.0f), 0xFFFFFF);
            }
        }
        GlStateManager.func_179121_F();
        this.minecraft.func_110434_K().func_110577_a(field_110324_m);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGameOverlay(RenderGameOverlayEvent.Text event) {
        Entity mouseOverEntity;
        if (!LycanitesMobs.config.getBool("Debug", "Overlay", false)) {
            return;
        }
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        if (mouseOver != null && (mouseOverEntity = mouseOver.field_72308_g) != null && mouseOverEntity instanceof BaseCreatureEntity) {
            BaseCreatureEntity mouseOverCreature = (BaseCreatureEntity)mouseOverEntity;
            event.getLeft().add("");
            event.getLeft().add("Target Creature: " + mouseOverCreature.func_70005_c_());
            event.getLeft().add("Distance To player: " + mouseOverCreature.func_70032_d((Entity)Minecraft.func_71410_x().field_71439_g));
            event.getLeft().add("Elements: " + mouseOverCreature.creatureInfo.getElementNames(mouseOverCreature.getSubspecies()));
            event.getLeft().add("Subspecies: " + mouseOverCreature.getSubspeciesIndex());
            event.getLeft().add("Variant: " + mouseOverCreature.getVariantIndex());
            event.getLeft().add("Level: " + mouseOverCreature.getLevel());
            event.getLeft().add("Experience: " + mouseOverCreature.getExperience() + "/" + mouseOverCreature.creatureStats.getExperienceForNextLevel());
            event.getLeft().add("Size: " + mouseOverCreature.sizeScale);
            event.getLeft().add("");
            event.getLeft().add("Health: " + mouseOverCreature.func_110143_aJ() + "/" + mouseOverCreature.func_110138_aP() + " Fresh: " + mouseOverCreature.creatureStats.getHealth());
            event.getLeft().add("Speed: " + mouseOverCreature.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() + "/" + mouseOverCreature.creatureStats.getSpeed());
            event.getLeft().add("");
            event.getLeft().add("Defense: " + mouseOverCreature.creatureStats.getDefense());
            event.getLeft().add("Armor: " + mouseOverCreature.func_70658_aO());
            event.getLeft().add("");
            event.getLeft().add("Damage: " + mouseOverCreature.creatureStats.getDamage());
            event.getLeft().add("Melee Speed: " + mouseOverCreature.creatureStats.getAttackSpeed());
            event.getLeft().add("Melee Range: " + mouseOverCreature.getPhysicalRange());
            event.getLeft().add("Ranged Speed: " + mouseOverCreature.creatureStats.getRangedSpeed());
            event.getLeft().add("Pierce: " + mouseOverCreature.creatureStats.getPierce());
            event.getLeft().add("");
            event.getLeft().add("Effect Duration: " + mouseOverCreature.creatureStats.getEffect() + " Base Seconds");
            event.getLeft().add("Effect Amplifier: x" + mouseOverCreature.creatureStats.getAmplifier());
            event.getLeft().add("");
            event.getLeft().add("Has Attack Target: " + mouseOverCreature.hasAttackTarget());
            event.getLeft().add("Has Avoid Target: " + mouseOverCreature.hasAvoidTarget());
            event.getLeft().add("Has Master Target: " + mouseOverCreature.hasMaster());
            event.getLeft().add("Has Parent Target: " + mouseOverCreature.hasParent());
            event.getLeft().add("");
            CreatureRelationshipEntry relationshipEntry = mouseOverCreature.relationships.getEntry((Entity)this.minecraft.field_71439_g);
            event.getLeft().add("Reputation with Player: " + (relationshipEntry != null ? relationshipEntry.getReputation() : 0) + "/" + mouseOverCreature.creatureInfo.getTamingReputation());
            if (mouseOverEntity instanceof TameableCreatureEntity) {
                TameableCreatureEntity mouseOverTameable = (TameableCreatureEntity)mouseOverCreature;
                event.getLeft().add("");
                event.getLeft().add("Owner ID: " + (mouseOverTameable.func_184753_b() != null ? mouseOverTameable.func_184753_b().toString() : "None"));
                event.getLeft().add("Owner Name: " + mouseOverTameable.getOwnerName());
            }
        }
    }
}

