/*
 * Decompiled with CFR 0.152.
 */
package at.feldim2425.moreoverlays.itemsearch;

import at.feldim2425.moreoverlays.itemsearch.JeiModule;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class ItemUtils {
    public static boolean ingredientMatches(Object ingredient, ItemStack stack) {
        if (ingredient instanceof ItemStack) {
            ItemStack stack1 = (ItemStack)ingredient;
            return stack1.func_185136_b(stack) && JeiModule.areItemsEqualInterpreter(stack1, stack);
        }
        if (ingredient instanceof EnchantmentData) {
            NBTTagList tags = stack.func_77973_b() instanceof ItemEnchantedBook ? ItemEnchantedBook.func_92110_g((ItemStack)stack) : stack.func_77986_q();
            return ItemUtils.getEnchantmentData(tags).stream().anyMatch(ench -> ench.field_76302_b.equals(((EnchantmentData)ingredient).field_76302_b) && ench.field_76303_c == ((EnchantmentData)ingredient).field_76303_c);
        }
        return false;
    }

    public static Collection<EnchantmentData> getEnchantmentData(@Nullable NBTTagList nbtList) {
        if (nbtList == null) {
            return Collections.emptySet();
        }
        HashSet<EnchantmentData> enchantments = new HashSet<EnchantmentData>();
        for (NBTBase nbt : nbtList) {
            if (!(nbt instanceof NBTTagCompound)) continue;
            NBTTagCompound nbttagcompound = (NBTTagCompound)nbt;
            short id = nbttagcompound.func_74765_d("id");
            short level = nbttagcompound.func_74765_d("lvl");
            Enchantment enchantment = Enchantment.func_185262_c((int)id);
            if (enchantment == null || level <= 0) continue;
            enchantments.add(new EnchantmentData(enchantment, (int)level));
        }
        return enchantments;
    }

    public static boolean matchNBT(ItemStack a, ItemStack b) {
        return a.func_77942_o() == b.func_77942_o() && (!a.func_77942_o() || a.func_77978_p().equals((Object)b.func_77978_p()));
    }

    private ItemUtils() {
    }
}

