/*
 * Decompiled with CFR 0.152.
 */
package de.krokoyt.element.entities;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Wind
extends EntityThrowable {
    private EntityPlayer thrower;
    int mountTime = 0;
    int livetime = 0;
    int tickExisted = 0;
    int maxLifeTime = 80;
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    Random field_70146_Z = new Random();
    private Entity owner;
    public double accelerationX;
    public double accelerationY;
    public double accelerationZ;
    public double motionx;
    public double motiony;
    public double motionz;
    private int ticksAlive;
    private int ticksInAir;
    double maxdist;

    public Wind(World worldIn) {
        super(worldIn);
    }

    public Wind(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public Wind(World worldIn, EntityPlayer throwerIn) {
        super(worldIn, (EntityLivingBase)throwerIn);
        this.thrower = throwerIn;
        this.owner = throwerIn;
        this.func_70012_b(throwerIn.field_70165_t, throwerIn.field_70163_u + (double)this.thrower.func_70047_e(), throwerIn.field_70161_v, throwerIn.field_70177_z, throwerIn.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.motionz = 0.0;
        this.motiony = 0.0;
        this.motionx = 0.0;
        this.accelerationX = this.motionx * 0.1;
        this.accelerationY = this.motiony * 0.1;
        this.accelerationZ = this.motionz * 0.1;
        this.xTile = -1;
        this.yTile = -1;
        this.zTile = -1;
        this.field_70159_w = this.motionx;
        this.field_70181_x = this.motiony;
        this.field_70179_y = this.motionz;
        this.field_70146_Z = new Random();
        this.func_70045_F();
        Vec3d Vector3d = throwerIn.func_70040_Z();
        if (Vector3d != null) {
            this.field_70159_w = Vector3d.field_72450_a;
            this.field_70181_x = Vector3d.field_72448_b;
            this.field_70179_y = Vector3d.field_72449_c;
        }
    }

    @Nonnull
    protected Item getDefaultItem() {
        return Items.field_190931_a;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_174854_a) {
            ++this.ticksAlive;
            IBlockState var1 = this.field_70170_p.func_180495_p(new BlockPos(this.xTile, this.yTile, this.zTile));
            if (this.ticksAlive >= this.maxLifeTime) {
                this.func_70106_y();
            }
            this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.ticksAlive = 0;
            this.ticksInAir = 0;
        } else {
            ++this.ticksInAir;
        }
        if (this.func_70090_H()) {
            for (int var19 = 0; var19 < 4; ++var19) {
                float var18 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)var18, this.field_70163_u - this.field_70181_x * (double)var18, this.field_70161_v - this.field_70179_y * (double)var18, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
        }
        if (this.field_70173_aa % 30 == 0) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, new SoundEvent(new ResourceLocation("element", "wind")), SoundCategory.WEATHER, 1.0f, 1.0f, true);
        }
        if (this.field_70173_aa >= this.maxLifeTime) {
            this.func_70106_y();
        }
        this.accelerationX = 0.0;
        this.accelerationY = 0.0;
        this.accelerationZ = 0.0;
        this.field_70159_w *= 0.9;
        this.field_70181_x *= 0.9;
        this.field_70179_y *= 0.9;
        IBlockState id = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 2.0, this.field_70161_v));
        if (id.func_177230_c() == Blocks.field_150350_a) {
            id = Blocks.field_150359_w.func_176223_P();
        }
        double dist = 5.0;
        AxisAlignedBB var3 = this.func_174813_aQ().func_72314_b(dist - 1.0, 2.0, dist - 1.0);
        List list = this.field_70170_p.func_72872_a(Entity.class, var3);
        for (Entity e : list) {
            if (e == this.owner) continue;
            Vec3d d = new Vec3d(this.field_70165_t - e.field_70165_t, this.field_70163_u - e.field_70163_u, this.field_70161_v - e.field_70161_v);
            double distToEntity = Math.max(15.0, (d.field_72450_a * d.field_72450_a + d.field_72449_c * d.field_72449_c) * 10.0);
            d.func_72432_b();
            double x = d.field_72450_a / distToEntity;
            double y = d.field_72448_b / Math.max(15.0, d.field_72448_b * d.field_72448_b * 10.0);
            double z = d.field_72449_c / distToEntity;
            if (e instanceof EntityLiving) {
                if (e.func_70104_M() && e != this.owner) {
                    e.func_70024_g(x, y, z);
                }
                if (this.func_70068_e(e) <= 3.0 && !this.field_70170_p.field_72995_K) {
                    e.func_70097_a(DamageSource.field_76376_m, 1.0f);
                }
                e.field_70143_R = 0.0f;
                continue;
            }
            if (e instanceof Wind && e != this && (Wind)e instanceof Wind) {
                if (((Wind)e).thrower != this.thrower) {
                    if (this.field_70170_p.field_72995_K || this.field_70146_Z.nextInt(30) == 0) {
                        // empty if block
                    }
                    EntityLightningBolt lightning = new EntityLightningBolt(this.field_70170_p, (double)this.func_180425_c().func_177958_n(), (double)this.func_180425_c().func_177956_o() - 1.0, (double)this.func_180425_c().func_177952_p(), false);
                    lightning.func_70107_b(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)lightning);
                    e.func_70024_g(x, y, z);
                    continue;
                }
                if (this.tickExisted > e.field_70173_aa) {
                    this.func_70106_y();
                    continue;
                }
                this.field_70173_aa -= e.field_70173_aa / 2;
                continue;
            }
            if (e == this.thrower) continue;
            e.func_70024_g(x, y, z);
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (double)this.field_70146_Z.nextFloat() - 0.5, this.field_70163_u + (double)this.field_70146_Z.nextFloat() - 0.5, this.field_70161_v + (double)this.field_70146_Z.nextFloat() - 0.5, (double)(this.field_70146_Z.nextFloat() - 0.5f), (double)(this.field_70146_Z.nextFloat() - 0.5f), (double)(this.field_70146_Z.nextFloat() - 0.5f), new int[]{Block.func_149682_b((Block)id.func_177230_c())});
            }
        }
        if (this.ticksInAir > this.maxLifeTime) {
            this.func_70106_y();
        }
    }

    public double func_70042_X() {
        return -0.40000001192092893;
    }

    public boolean func_70067_L() {
        return true;
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K && !(result.hitInfo instanceof EntityLiving)) {
            this.field_70181_x = this.motiony = 0.0;
        }
    }
}

