/*
 * Decompiled with CFR 0.152.
 */
package ladylib.registration;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import ladylib.LadyLib;
import ladylib.client.ItemRenderRegistrationHandler;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemRegistrar {
    private Map<Item, ItemInfo> allItems = new HashMap<Item, ItemInfo>();
    private Map<ResourceLocation, ItemRenderRegistrationHandler> modelRegistrationHandlers = new HashMap<ResourceLocation, ItemRenderRegistrationHandler>();

    public static <T extends Item> T name(T item, String name) {
        ((Item)item.setRegistryName(name)).func_77655_b(item.getRegistryName().func_110624_b() + "." + name);
        return item;
    }

    public static void registerRender(Item item, ModelResourceLocation loc) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)loc);
    }

    public static void registerRender(Item item) {
        if (item instanceof ItemRenderRegistrationHandler) {
            ((ItemRenderRegistrationHandler)item).registerRender(item);
        } else {
            ItemRegistrar.registerRender(item, new ModelResourceLocation(Objects.requireNonNull(item.getRegistryName()).toString()));
        }
    }

    public void addItem(@Nonnull Item item, boolean listed, String ... oreNames) {
        Preconditions.checkNotNull((Object)item.getRegistryName(), (String)"Can't use a null-name for the registry, object %s.", (Object)item);
        this.allItems.put(item, new ItemInfo(listed, oreNames));
    }

    public void setCustomRenderRegistrationHandler(ResourceLocation registryName, ItemRenderRegistrationHandler handler) {
        this.modelRegistrationHandlers.put(registryName, handler);
    }

    public Collection<Item> getAllItems() {
        return this.allItems.keySet();
    }

    public Stream<Item> getInvisibleItems() {
        return this.allItems.entrySet().stream().filter(entry -> !((ItemInfo)entry.getValue()).listed).map(Map.Entry::getKey);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    void registerItems(RegistryEvent.Register<Item> event) {
        this.allItems.forEach((item, info) -> {
            event.getRegistry().register((IForgeRegistryEntry)item);
            if (info.listed) {
                item.func_77637_a(LadyLib.INSTANCE.getContainer(item.getRegistryName().func_110624_b()).getCreativeTab());
            }
            for (String oreName : info.oreNames) {
                OreDictionary.registerOre((String)oreName, (Item)item);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    void registerRenders(ModelRegistryEvent event) {
        this.allItems.keySet().forEach(item -> this.modelRegistrationHandlers.getOrDefault(item.getRegistryName(), ItemRegistrar::registerRender).registerRender((Item)item));
    }

    static class ItemInfo {
        boolean listed;
        String[] oreNames;

        ItemInfo(boolean listed, String[] oreNames) {
            this.listed = listed;
            this.oreNames = oreNames;
        }
    }
}

