/*
 * Decompiled with CFR 0.152.
 */
package ladylib.nbt.serialization.internal;

import com.google.gson.reflect.TypeToken;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import ladylib.LadyLib;
import ladylib.misc.ReflectionFailedException;
import ladylib.misc.ReflectionUtil;
import ladylib.nbt.serialization.DefaultValue;
import ladylib.nbt.serialization.TagAdapters;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;
import org.objectweb.asm.Type;

public class DefaultValuesSearch {
    private DefaultValuesSearch() {
    }

    public static void searchDefaultValues(ASMDataTable asmData) {
        Set allDefaultValues = asmData.getAll(DefaultValue.class.getName());
        for (ASMDataTable.ASMData entry : allDefaultValues) {
            String targetClass = entry.getClassName();
            String targetName = entry.getObjectName();
            List types = (List)entry.getAnnotationInfo().get("value");
            if (types == null) {
                LadyLib.LOGGER.warn("Unable to inject capability at {}.{} (Invalid Annotation)", (Object)targetClass, (Object)targetName);
                continue;
            }
            boolean isMethod = entry.getObjectName().indexOf(40) >= 0;
            for (Type type : types) {
                try {
                    Class<?> clazz = Class.forName(targetClass, false, DefaultValuesSearch.class.getClassLoader());
                    Class<?> typeClass = ReflectionUtil.getClassForType(type);
                    if (isMethod) {
                        Method method = clazz.getDeclaredMethod(targetName, new Class[0]);
                        if (!Modifier.isStatic(method.getModifiers()) || Modifier.isAbstract(method.getModifiers())) {
                            throw new ReflectionFailedException("Default value supplying methods must be static and non abstract");
                        }
                        MethodHandles.Lookup lookup = MethodHandles.lookup();
                        MethodHandle mh = lookup.unreflect(method);
                        CallSite metafactory = LambdaMetafactory.metafactory(lookup, "get", MethodType.methodType(Supplier.class), MethodType.methodType(Object.class), mh, MethodType.methodType(typeClass));
                        TagAdapters.setDefaultValue(TypeToken.get(typeClass), metafactory.getTarget().invoke());
                        continue;
                    }
                    Field f = clazz.getDeclaredField(targetName);
                    if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers())) {
                        throw new ReflectionFailedException("Default value fields must be static and final");
                    }
                    Object o = f.get(null);
                    TagAdapters.setDefaultValue(TypeToken.get(typeClass), () -> o);
                }
                catch (Throwable t) {
                    LadyLib.LOGGER.error((Message)new FormattedMessage("Could not register default value {} for type {} in class {}", new Object[]{targetName, type, targetClass}), t);
                }
            }
        }
    }
}

