/*
 * Decompiled with CFR 0.152.
 */
package ladylib.nbt.serialization.adapter;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.function.Supplier;
import ladylib.misc.ReflectionUtil;
import ladylib.nbt.serialization.NBTTypeAdapter;
import ladylib.nbt.serialization.NBTTypeAdapterFactory;
import ladylib.nbt.serialization.adapter.AbstractNBTTypeAdapter;
import net.minecraft.nbt.NBTBase;
import net.minecraftforge.common.util.INBTSerializable;

public class SerializableNBTTypeAdapterFactory
implements NBTTypeAdapterFactory<INBTSerializable<NBTBase>, NBTBase> {
    @Override
    public NBTTypeAdapter<INBTSerializable<NBTBase>, NBTBase> create(TypeToken type, boolean allowMutating) {
        Class rawType = type.getRawType();
        if (!INBTSerializable.class.isAssignableFrom(rawType)) {
            return null;
        }
        Supplier constructor = (Supplier)ReflectionUtil.createFactory(rawType, "get", Supplier.class);
        Object elementType = Object.class;
        Type nbtType = type.getType();
        if (nbtType instanceof WildcardType) {
            nbtType = ((WildcardType)nbtType).getUpperBounds()[0];
        }
        if (nbtType instanceof ParameterizedType) {
            elementType = ((ParameterizedType)nbtType).getActualTypeArguments()[0];
        }
        return new SerializableNBTTypeAdapter<INBTSerializable<NBTBase>, NBTBase>(constructor, TypeToken.get(elementType).getRawType());
    }

    public static class SerializableNBTTypeAdapter<T extends INBTSerializable<NBT>, NBT extends NBTBase>
    extends AbstractNBTTypeAdapter<T, NBT> {
        private final Supplier<T> constructor;
        private final Class<NBT> nbtClass;

        public SerializableNBTTypeAdapter(Supplier<T> constructor, Class nbtClass) {
            this.constructor = constructor;
            this.nbtClass = nbtClass;
        }

        @Override
        public NBT toNBT(T value) {
            return (NBT)value.serializeNBT();
        }

        @Override
        public T fromNBT(NBTBase nbt) {
            return (T)this.castAnd(nbt, this.nbtClass, tag -> {
                INBTSerializable value = (INBTSerializable)this.constructor.get();
                value.deserializeNBT(tag);
                return value;
            });
        }
    }
}

