/*
 * Decompiled with CFR 0.152.
 */
package ladylib.nbt.serialization.adapter;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import ladylib.nbt.serialization.NBTTypeAdapter;
import ladylib.nbt.serialization.NBTTypeAdapterFactory;
import ladylib.nbt.serialization.adapter.AbstractNBTTypeAdapter;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class RegistryEntryNBTAdapterFactory
implements NBTTypeAdapterFactory<IForgeRegistryEntry, NBTTagString> {
    @Override
    public NBTTypeAdapter<IForgeRegistryEntry, NBTTagString> create(TypeToken type, boolean allowMutating) {
        if (!IForgeRegistryEntry.class.isAssignableFrom(type.getRawType())) {
            return null;
        }
        IForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(this.getRegistryType(type.getRawType()));
        if (registry == null) {
            return null;
        }
        RegistryEntryNBTAdapter<IForgeRegistryEntry> ret = new RegistryEntryNBTAdapter<IForgeRegistryEntry>(registry);
        return ret;
    }

    @Nullable
    private Class getRegistryType(Class clazz) {
        Type superclass = clazz.getGenericSuperclass();
        if (superclass instanceof ParameterizedType) {
            Type superclassType = ((ParameterizedType)superclass).getActualTypeArguments()[0];
            TypeToken typeToken = TypeToken.get((Type)superclassType);
            Class typeClass = typeToken.getRawType();
            if (IForgeRegistryEntry.class.isAssignableFrom(TypeToken.get((Type)superclass).getRawType()) && IForgeRegistryEntry.class.isAssignableFrom(typeClass)) {
                return typeClass;
            }
        }
        if (IForgeRegistryEntry.class.isAssignableFrom(clazz.getSuperclass())) {
            return this.getRegistryType(clazz.getSuperclass());
        }
        for (Type interfaceType : clazz.getGenericInterfaces()) {
            Class registryType;
            Class interfaceClass = TypeToken.get((Type)interfaceType).getRawType();
            if (interfaceType instanceof ParameterizedType) {
                Type superclassType = ((ParameterizedType)interfaceType).getActualTypeArguments()[0];
                TypeToken typeToken = TypeToken.get((Type)superclassType);
                Class typeClass = typeToken.getRawType();
                if (IForgeRegistryEntry.class.isAssignableFrom(interfaceClass) && IForgeRegistryEntry.class.isAssignableFrom(typeClass)) {
                    return typeClass;
                }
            }
            if ((registryType = this.getRegistryType(interfaceClass)) == null) continue;
            return registryType;
        }
        return null;
    }

    public static class RegistryEntryNBTAdapter<V extends IForgeRegistryEntry<V>>
    extends AbstractNBTTypeAdapter<V, NBTTagString> {
        private IForgeRegistry<V> registry;

        public RegistryEntryNBTAdapter(IForgeRegistry<V> registry) {
            this.registry = registry;
        }

        @Override
        public NBTTagString toNBT(V value) {
            return new NBTTagString(String.valueOf(value.getRegistryName()));
        }

        @Override
        public V fromNBT(NBTBase nbtTagString) {
            return (V)this.castAnd(nbtTagString, NBTTagString.class, nbt -> this.registry.getValue(new ResourceLocation(nbt.func_150285_a_())));
        }
    }
}

