/*
 * Decompiled with CFR 0.152.
 */
package ladylib.nbt.serialization.adapter;

import com.google.gson.reflect.TypeToken;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ladylib.LadyLib;
import ladylib.misc.ReflectionUtil;
import ladylib.nbt.serialization.NBTDeserializationException;
import ladylib.nbt.serialization.NBTMutatingTypeAdapter;
import ladylib.nbt.serialization.NBTTypeAdapter;
import ladylib.nbt.serialization.NBTTypeAdapterFactory;
import ladylib.nbt.serialization.TagAdapters;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class ReflectiveNBTAdapterFactory
implements NBTTypeAdapterFactory<Object, NBTTagCompound> {
    public static final ReflectiveNBTAdapterFactory INSTANCE = new ReflectiveNBTAdapterFactory();

    public <T> NBTTypeAdapter<T, NBTTagCompound> create(Class<T> type) {
        return this.create(TypeToken.get(type), true);
    }

    @Override
    @Nonnull
    public NBTTypeAdapter<Object, NBTTagCompound> create(TypeToken type, boolean allowMutating) {
        try {
            MutatingReflectiveNBTAdapter<Object> ret = new MutatingReflectiveNBTAdapter<Object>(type.getRawType());
            if (!allowMutating) {
                return new ReflectiveNBTAdapter<Object>(type, ret);
            }
            return ret;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ReflectionUtil.UnableToGetFactoryException(e);
        }
    }

    private static class FieldEntry {
        private final String name;
        private final MethodHandle getter;
        private final MethodHandle setter;
        private final NBTTypeAdapter adapter;

        private FieldEntry(String name, MethodHandle getter, @Nullable MethodHandle setter, NBTTypeAdapter adapter) {
            this.name = name;
            this.getter = getter;
            this.setter = setter;
            this.adapter = adapter;
        }
    }

    public static class MutatingReflectiveNBTAdapter<T>
    implements NBTMutatingTypeAdapter<T, NBTTagCompound> {
        private final List<FieldEntry> fieldEntries;

        public MutatingReflectiveNBTAdapter(Class<?> clazz) throws IllegalAccessException {
            Field[] fields = clazz.getDeclaredFields();
            this.fieldEntries = new ArrayList<FieldEntry>();
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            for (Field field : fields) {
                int modifiers = field.getModifiers();
                if (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers)) continue;
                field.setAccessible(true);
                MethodHandle getter = lookup.unreflectGetter(field);
                MethodHandle setter = null;
                if (!Modifier.isFinal(modifiers)) {
                    setter = lookup.unreflectSetter(field);
                }
                NBTTypeAdapter adapter = TagAdapters.getNBTAdapter(field);
                this.fieldEntries.add(new FieldEntry(field.getName(), getter, setter, adapter));
            }
        }

        @Override
        public NBTTagCompound toNBT(T instance) {
            NBTTagCompound compound = new NBTTagCompound();
            for (FieldEntry fieldEntry : this.fieldEntries) {
                try {
                    Object value = fieldEntry.getter.invoke(instance);
                    Object serialized = fieldEntry.adapter.toNBT(value);
                    if (serialized == null) continue;
                    compound.func_74782_a(fieldEntry.name, serialized);
                }
                catch (Throwable throwable) {
                    LadyLib.LOGGER.error((Message)new FormattedMessage("Could not write NBT for {} ", instance), throwable);
                }
            }
            return compound;
        }

        @Override
        public T fromNBT(T instance, NBTBase nbt) {
            for (FieldEntry fieldEntry : this.fieldEntries) {
                NBTTypeAdapter.castNBT(nbt, NBTTagCompound.class).ifPresent(compound -> {
                    try {
                        NBTBase serialized = compound.func_74781_a(fieldEntry.name);
                        if (fieldEntry.adapter instanceof NBTMutatingTypeAdapter) {
                            Object value = fieldEntry.getter.invoke(instance);
                            fieldEntry.adapter.fromNBT(value, serialized);
                        } else if (fieldEntry.setter != null) {
                            Object value = fieldEntry.adapter.fromNBT(serialized);
                            fieldEntry.setter.invoke(instance, value);
                        } else {
                            LadyLib.LOGGER.warn("Could not write to final field {} in {}", (Object)fieldEntry.name, instance);
                        }
                    }
                    catch (Throwable throwable) {
                        throw new NBTDeserializationException("Could not read NBT for " + instance, throwable);
                    }
                });
            }
            return instance;
        }
    }

    public static class ReflectiveNBTAdapter<T>
    implements NBTTypeAdapter<T, NBTTagCompound> {
        private final MutatingReflectiveNBTAdapter<T> delegate;
        private final MethodHandle constructor;
        private final TypeToken<T> type;

        public ReflectiveNBTAdapter(TypeToken<T> type, MutatingReflectiveNBTAdapter<T> delegate) throws NoSuchMethodException, IllegalAccessException {
            this.delegate = delegate;
            Class tClass = type.getRawType();
            this.constructor = ReflectionUtil.getTrustedLookup(tClass).findConstructor(tClass, MethodType.methodType(Void.TYPE));
            this.type = type;
        }

        @Override
        public NBTTagCompound toNBT(T value) {
            return this.delegate.toNBT(value);
        }

        @Override
        public T fromNBT(NBTBase nbtTagCompound) {
            try {
                Object ret = this.constructor.invoke();
                return (T)this.delegate.fromNBT(ret, nbtTagCompound);
            }
            catch (Throwable throwable) {
                return TagAdapters.getDefaultValue(this.type).orElseThrow(() -> new NBTDeserializationException("Unable to deserialize object of type " + this.type + " and no default value exists", throwable));
            }
        }
    }
}

