/*
 * Decompiled with CFR 0.152.
 */
package ladylib.nbt.serialization.adapter;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import ladylib.misc.ReflectionUtil;
import ladylib.nbt.serialization.NBTMutatingTypeAdapter;
import ladylib.nbt.serialization.NBTTypeAdapter;
import ladylib.nbt.serialization.NBTTypeAdapterFactory;
import ladylib.nbt.serialization.adapter.AbstractNBTTypeAdapter;
import ladylib.nbt.serialization.adapter.CollectionNBTTypeAdapterFactory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class MapNBTTypeAdapterFactory
implements NBTTypeAdapterFactory<Map, NBTTagList> {
    @Override
    public NBTTypeAdapter<Map, NBTTagList> create(TypeToken type, boolean allowMutating) {
        Class rawType = type.getRawType();
        if (!Map.class.isAssignableFrom(rawType)) {
            return null;
        }
        NBTTypeAdapter keyAdapter = CollectionNBTTypeAdapterFactory.getElementTypeAdapter(type, 0);
        NBTTypeAdapter valueAdapter = CollectionNBTTypeAdapterFactory.getElementTypeAdapter(type, 1);
        if (allowMutating) {
            MapNBTMutatingTypeAdapter ret = new MapNBTMutatingTypeAdapter(keyAdapter, valueAdapter);
            return ret;
        }
        Supplier supplier = !Modifier.isAbstract(rawType.getModifiers()) ? (Supplier)ReflectionUtil.createFactory(rawType, "get", Supplier.class) : (SortedMap.class.isAssignableFrom(rawType) ? TreeMap::new : HashMap::new);
        MapNBTTypeAdapter ret = new MapNBTTypeAdapter(keyAdapter, valueAdapter, supplier);
        return ret;
    }

    public static class MapNBTTypeAdapter<K, V>
    extends MapBaseAdapter<K, V>
    implements NBTTypeAdapter<Map<K, V>, NBTTagList> {
        private final Supplier<Map<K, V>> mapSupplier;

        public MapNBTTypeAdapter(NBTTypeAdapter<K, NBTBase> keyAdapter, NBTTypeAdapter<V, NBTBase> valueAdapter, Supplier<Map<K, V>> mapSupplier) {
            super(keyAdapter, valueAdapter);
            this.mapSupplier = mapSupplier;
        }

        @Override
        public Map<K, V> fromNBT(Map<K, V> value, NBTBase nbt) {
            return this.fromNBT(nbt);
        }

        @Override
        public Map<K, V> fromNBT(NBTBase list) {
            return super.fromNBT(this.mapSupplier.get(), list);
        }
    }

    public static class MapNBTMutatingTypeAdapter<K, V>
    extends MapBaseAdapter<K, V>
    implements NBTMutatingTypeAdapter<Map<K, V>, NBTTagList> {
        public MapNBTMutatingTypeAdapter(NBTTypeAdapter<K, NBTBase> keyAdapter, NBTTypeAdapter<V, NBTBase> valueAdapter) {
            super(keyAdapter, valueAdapter);
        }
    }

    public static abstract class MapBaseAdapter<K, V>
    extends AbstractNBTTypeAdapter<Map<K, V>, NBTTagList> {
        protected static final String KEY_TAG = "key";
        protected static final String VALUE_TAG = "value";
        protected final NBTTypeAdapter<K, NBTBase> keyAdapter;
        protected final NBTTypeAdapter<V, NBTBase> valueAdapter;

        public MapBaseAdapter(NBTTypeAdapter<K, NBTBase> keyAdapter, NBTTypeAdapter<V, NBTBase> valueAdapter) {
            this.keyAdapter = keyAdapter;
            this.valueAdapter = valueAdapter;
        }

        @Override
        public Map<K, V> fromNBT(Map<K, V> value, NBTBase nbt) {
            this.cast(nbt, NBTTagList.class).ifPresent(list -> {
                value.clear();
                for (NBTBase nbtBase : list) {
                    NBTTypeAdapter.castNBT(nbtBase, NBTTagCompound.class).ifPresent(entry -> {
                        K k = this.keyAdapter.fromNBT(entry.func_74781_a(KEY_TAG));
                        V v = this.valueAdapter.fromNBT(entry.func_74781_a(VALUE_TAG));
                        value.put(k, v);
                    });
                }
            });
            return value;
        }

        @Override
        public NBTTagList toNBT(Map<K, V> value) {
            NBTTagList ret = new NBTTagList();
            value.forEach((k, v) -> {
                NBTTagCompound pair = new NBTTagCompound();
                pair.func_74782_a(KEY_TAG, this.keyAdapter.toNBT(k));
                pair.func_74782_a(VALUE_TAG, this.valueAdapter.toNBT(v));
                ret.func_74742_a((NBTBase)pair);
            });
            return ret;
        }
    }
}

