/*
 * Decompiled with CFR 0.152.
 */
package ladylib.nbt.serialization.adapter;

import com.google.gson.reflect.TypeToken;
import ladylib.nbt.serialization.NBTDeserializationException;
import ladylib.nbt.serialization.NBTTypeAdapter;
import ladylib.nbt.serialization.NBTTypeAdapterFactory;
import ladylib.nbt.serialization.TagAdapters;
import ladylib.nbt.serialization.adapter.AbstractNBTTypeAdapter;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;

public class EnumNBTTypeAdapterFactory
implements NBTTypeAdapterFactory<Enum, NBTTagString> {
    @Override
    public NBTTypeAdapter<Enum, NBTTagString> create(TypeToken type, boolean allowMutating) {
        Class enumClass = type.getRawType();
        if (!Enum.class.isAssignableFrom(enumClass) || enumClass == Enum.class) {
            return null;
        }
        if (!enumClass.isEnum()) {
            enumClass = enumClass.getSuperclass();
        }
        return new EnumNBTTypeAdapter<Enum>(type, enumClass);
    }

    public static class EnumNBTTypeAdapter<E extends Enum<E>>
    extends AbstractNBTTypeAdapter<E, NBTTagString> {
        private final Class<E> enumClass;

        public EnumNBTTypeAdapter(TypeToken<E> tt, Class<E> enumClass) {
            super(tt);
            this.enumClass = enumClass;
        }

        @Override
        public NBTTagString toNBT(E value) {
            return new NBTTagString(((Enum)value).name());
        }

        @Override
        public E fromNBT(NBTBase nbtTagString) {
            try {
                return (E)this.castAnd(nbtTagString, NBTTagString.class, nbt -> Enum.valueOf(this.enumClass, nbt.func_150285_a_()));
            }
            catch (IllegalArgumentException e) {
                TypeToken typeToken = TypeToken.get(this.enumClass);
                return (E)((Enum)TagAdapters.getDefaultValue(typeToken).orElseThrow(() -> new NBTDeserializationException("Failed to deserialize enum field", e)));
            }
        }
    }
}

