/*
 * Decompiled with CFR 0.152.
 */
package ladylib.nbt.serialization.adapter;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import ladylib.LadyLib;
import ladylib.misc.ReflectionUtil;
import ladylib.nbt.serialization.NBTMutatingTypeAdapter;
import ladylib.nbt.serialization.NBTTypeAdapter;
import ladylib.nbt.serialization.NBTTypeAdapterFactory;
import ladylib.nbt.serialization.TagAdapters;
import ladylib.nbt.serialization.adapter.AbstractNBTTypeAdapter;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;

public class CollectionNBTTypeAdapterFactory
implements NBTTypeAdapterFactory<Collection, NBTTagList> {
    @Override
    public NBTTypeAdapter<Collection, NBTTagList> create(TypeToken type, boolean allowMutating) {
        Supplier supplier;
        Class rawType = type.getRawType();
        if (!Collection.class.isAssignableFrom(rawType)) {
            return null;
        }
        NBTTypeAdapter elementAdapter = CollectionNBTTypeAdapterFactory.getElementTypeAdapter(type, 0);
        if (allowMutating) {
            CollectionNBTMutatingTypeAdapter ret = new CollectionNBTMutatingTypeAdapter(elementAdapter);
            return ret;
        }
        if (!Modifier.isAbstract(rawType.getModifiers())) {
            supplier = (Supplier)ReflectionUtil.createFactory(rawType, "get", Supplier.class);
        } else if (List.class.isAssignableFrom(rawType)) {
            supplier = ArrayList::new;
        } else if (SortedSet.class.isAssignableFrom(rawType)) {
            supplier = TreeSet::new;
        } else if (Set.class.isAssignableFrom(rawType)) {
            supplier = HashSet::new;
        } else if (Queue.class.isAssignableFrom(rawType)) {
            supplier = ArrayDeque::new;
        } else {
            LadyLib.LOGGER.warn("Unsupported collection type: {}", (Object)rawType);
            return null;
        }
        CollectionNBTTypeAdapter ret = new CollectionNBTTypeAdapter(elementAdapter, supplier);
        return ret;
    }

    static NBTTypeAdapter getElementTypeAdapter(TypeToken type, int index) {
        Type collectionType = type.getType();
        Object elementType = Object.class;
        if (collectionType instanceof WildcardType) {
            collectionType = ((WildcardType)collectionType).getUpperBounds()[index];
        }
        if (collectionType instanceof ParameterizedType) {
            elementType = ((ParameterizedType)collectionType).getActualTypeArguments()[index];
        }
        return TagAdapters.getNBTAdapter(TypeToken.get(elementType), false);
    }

    public static class CollectionNBTTypeAdapter<E>
    extends CollectionBaseAdapter<E>
    implements NBTTypeAdapter<Collection<E>, NBTTagList> {
        private final Supplier<Collection<E>> collectionSupplier;

        public CollectionNBTTypeAdapter(NBTTypeAdapter<E, NBTBase> elementAdapter, Supplier<Collection<E>> collectionSupplier) {
            super(elementAdapter);
            this.collectionSupplier = collectionSupplier;
        }

        @Override
        public Collection<E> fromNBT(Collection<E> value, NBTBase nbt) {
            return this.fromNBT(nbt);
        }

        @Override
        public Collection<E> fromNBT(NBTBase list) {
            return super.fromNBT(this.collectionSupplier.get(), list);
        }
    }

    public static class CollectionNBTMutatingTypeAdapter<E>
    extends CollectionBaseAdapter<E>
    implements NBTMutatingTypeAdapter<Collection<E>, NBTTagList> {
        public CollectionNBTMutatingTypeAdapter(NBTTypeAdapter<E, NBTBase> elementAdapter) {
            super(elementAdapter);
        }
    }

    public static abstract class CollectionBaseAdapter<E>
    extends AbstractNBTTypeAdapter<Collection<E>, NBTTagList> {
        protected final NBTTypeAdapter<E, NBTBase> elementAdapter;

        protected CollectionBaseAdapter(NBTTypeAdapter<E, NBTBase> elementAdapter) {
            this.elementAdapter = elementAdapter;
        }

        @Override
        public Collection<E> fromNBT(Collection<E> value, NBTBase nbt) {
            this.cast(nbt, NBTTagList.class).ifPresent(list -> {
                value.clear();
                for (NBTBase nbtBase : list) {
                    value.add(this.elementAdapter.fromNBT(nbtBase));
                }
            });
            return value;
        }

        @Override
        public NBTTagList toNBT(Collection<E> value) {
            NBTTagList list = new NBTTagList();
            for (E element : value) {
                list.func_74742_a(this.elementAdapter.toNBT(element));
            }
            return list;
        }
    }
}

