/*
 * Decompiled with CFR 0.152.
 */
package ladylib.nbt.serialization;

import com.google.common.annotations.Beta;
import java.util.Optional;
import net.minecraft.nbt.NBTBase;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

@Beta
public interface NBTTypeAdapter<T, NBT extends NBTBase> {
    @Nullable
    public NBT toNBT(T var1);

    @Nullable
    default public T fromNBT(T value, NBTBase nbt) {
        return this.fromNBT(nbt);
    }

    @Nullable
    public T fromNBT(NBTBase var1);

    @Contract(pure=true)
    public static <NBT extends NBTBase> Optional<NBT> castNBT(NBTBase nbt, Class<NBT> clazz) {
        if (clazz.isInstance(nbt)) {
            return Optional.of(clazz.cast(nbt));
        }
        return Optional.empty();
    }
}

