/*
 * Decompiled with CFR 0.152.
 */
package ladylib.nbt;

import com.google.common.base.Preconditions;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ladylib.nbt.serialization.NBTDeserializationException;
import ladylib.nbt.serialization.NBTTypeAdapter;
import ladylib.nbt.serialization.TagAdapters;
import net.minecraft.nbt.NBTBase;

public final class NBTSerialization {
    private NBTSerialization() {
    }

    @Nullable
    public static NBTBase toNBT(@Nullable Object src) {
        return src == null ? null : NBTSerialization.toNBT(src, src.getClass());
    }

    @Nullable
    public static NBTBase toNBT(Object src, Type typeOfSrc) {
        NBTTypeAdapter adapter = TagAdapters.getNBTAdapter(TypeToken.get((Type)typeOfSrc), false);
        return adapter.toNBT(src);
    }

    @Nullable
    public static <T> T fromNBT(@Nullable NBTBase nbt, Class<T> classOfT) throws NBTDeserializationException {
        return NBTSerialization.fromNBT(nbt, classOfT);
    }

    @Nullable
    public static <T> T fromNBT(@Nullable NBTBase nbt, Type typeOfT) throws NBTDeserializationException {
        if (nbt == null) {
            return null;
        }
        Preconditions.checkNotNull((Object)typeOfT);
        NBTTypeAdapter adapter = TagAdapters.getNBTAdapter(TypeToken.get((Type)typeOfT), false);
        return adapter.fromNBT(nbt);
    }

    @Nullable
    public static NBTBase serializeNBT(@Nonnull Object src) {
        NBTTypeAdapter adapter = TagAdapters.getNBTAdapter(TypeToken.get(src.getClass()), true);
        return adapter.toNBT(src);
    }

    public static void deserializeNBT(@Nonnull Object target, @Nullable NBTBase nbt) throws NBTDeserializationException {
        if (nbt == null) {
            return;
        }
        NBTTypeAdapter adapter = TagAdapters.getNBTAdapter(TypeToken.get(target.getClass()), true);
        adapter.fromNBT(target, nbt);
    }
}

