/*
 * Decompiled with CFR 0.152.
 */
package ladylib.modwinder.installer;

import com.google.common.annotations.VisibleForTesting;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import ladylib.modwinder.ModWinder;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class ModDeleter
extends Thread {
    private Set<File> modsToDelete = new HashSet<File>();
    private File llSource = ((ModContainer)Loader.instance().getIndexedModList().getOrDefault("modwinder", new DummyModContainer())).getSource();
    @VisibleForTesting
    static ModDeleter instance;
    @VisibleForTesting
    static Path modsDir;

    @Override
    public void run() {
        ArrayList<String> commandArgs = new ArrayList<String>();
        File runDir = this.llSource;
        String java = System.getProperty("java.home") + "/bin/java";
        if (!Files.exists(Paths.get(java, new String[0]), new LinkOption[0]) && !Files.exists(Paths.get(java = java + ".exe", new String[0]), new LinkOption[0])) {
            java = "java";
        }
        commandArgs.add(java);
        if (!this.llSource.isDirectory()) {
            commandArgs.add("-cp");
            commandArgs.add(this.llSource.getAbsolutePath());
            runDir = runDir.getParentFile();
        }
        commandArgs.add(ModDeleter.class.getName());
        commandArgs.add(modsDir.toString());
        try {
            for (File file : this.modsToDelete) {
                commandArgs.add(file.getCanonicalPath());
            }
            ProcessBuilder processBuilder = new ProcessBuilder(commandArgs);
            processBuilder.directory(runDir);
            processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
            Logger.getGlobal().log(Level.INFO, "Starting {} in {}", new Object[]{String.join((CharSequence)" ", commandArgs), runDir});
            processBuilder.start();
        }
        catch (IOException e) {
            ModWinder.LOGGER.error("Could not start mod remover process", (Throwable)e);
        }
    }

    public static boolean isInModFolder(File file) {
        return file.toPath().toAbsolutePath().normalize().startsWith(modsDir);
    }

    public static void scheduleModDeletion(String modId) {
        ModContainer mc = (ModContainer)Loader.instance().getIndexedModList().get(modId);
        if (mc == null) {
            return;
        }
        File currentSource = mc.getSource();
        if (ModDeleter.isInModFolder(currentSource)) {
            ModDeleter.scheduleFileDeletion(currentSource);
        }
    }

    public static void cancelModDeletion(String modId) {
        ModContainer mc = (ModContainer)Loader.instance().getIndexedModList().get(modId);
        if (mc == null || instance == null) {
            return;
        }
        ModDeleter.instance.modsToDelete.remove(mc.getSource());
    }

    @VisibleForTesting
    static void scheduleFileDeletion(File mod) {
        if (instance == null) {
            instance = new ModDeleter();
            Runtime.getRuntime().addShutdownHook(instance);
        }
        ModDeleter.instance.modsToDelete.add(mod);
    }

    public static void main(String ... args) {
        if (args.length <= 0) {
            return;
        }
        modsDir = Paths.get(args[0], new String[0]);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            Logger.getGlobal().log(Level.WARNING, "Got interrupted, aborting operation", e);
            return;
        }
        Arrays.stream(args).skip(1L).map(File::new).filter(File::exists).filter(ModDeleter::isInModFolder).filter(f -> !f.delete()).map(File::getAbsolutePath).reduce((s, s1) -> s + "\n" + s1).ifPresent(ModDeleter::showManualDeletionDialog);
    }

    private static void showManualDeletionDialog(String oopsie) {
        try {
            Desktop.getDesktop().open(modsDir.toFile());
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.SEVERE, "Could not open mods directory", e);
        }
        JOptionPane.showMessageDialog(null, "The following mods need to be deleted manually:\n" + oopsie, "Failed to delete old mods.", 2);
    }

    static {
        modsDir = Paths.get("mods", new String[0]).toAbsolutePath().normalize();
    }
}

