/*
 * Decompiled with CFR 0.152.
 */
package ladylib.modwinder.installer;

import ladylib.modwinder.data.ModEntry;

public class InstallationState {
    public static final InstallationState NAUGHT = new InstallationState(Status.NONE, "");
    private final Status status;
    private final String[] message;

    public InstallationState(Status status, String ... message) {
        this.status = status;
        this.message = message;
    }

    public Status getStatus() {
        return this.status;
    }

    public String[] getMessage() {
        return this.message;
    }

    public static enum Status {
        NONE(false, 0, true){

            @Override
            public boolean canInstall(ModEntry selected) {
                return !selected.isInstalled() || selected.isOutdated();
            }
        }
        ,
        FAILED(true, 3, true),
        INSTALLING(true, 6, false),
        INSTALLED(true, 9, false),
        UNINSTALLED(true, 12, true);

        private final boolean display;
        private final int sheetOffset;
        private final boolean canInstall;

        private Status(boolean display, int sheetOffset, boolean canInstall) {
            this.display = display;
            this.sheetOffset = sheetOffset;
            this.canInstall = canInstall;
        }

        public boolean shouldDisplay() {
            return this.display;
        }

        public float getSheetOffset() {
            return this.sheetOffset;
        }

        public boolean canInstall(ModEntry selected) {
            return this.canInstall;
        }
    }
}

