/*
 * Decompiled with CFR 0.152.
 */
package ladylib.modwinder.installer;

import com.google.common.base.Throwables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ladylib.misc.ReflectionUtil;
import ladylib.modwinder.ModWinder;
import ladylib.modwinder.data.DummyModEntry;
import ladylib.modwinder.data.LocalModList;
import ladylib.modwinder.data.ModEntry;
import ladylib.modwinder.data.ModWinderList;
import ladylib.modwinder.installer.InstallationException;
import ladylib.modwinder.installer.InstallationState;
import ladylib.modwinder.installer.ModDeleter;
import ladylib.networking.http.HTTPRequestHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.libraries.Artifact;
import net.minecraftforge.fml.relauncher.libraries.LibraryManager;
import net.minecraftforge.fml.relauncher.libraries.ModList;
import net.minecraftforge.fml.relauncher.libraries.Repository;
import net.minecraftforge.fml.relauncher.libraries.SnapshotJson;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class AddonInstaller {
    public static final InstallationState DOWNLOAD_START = new InstallationState(InstallationState.Status.INSTALLING, "modwinder.status.downloading.start");
    public static final InstallationState DOWNLOAD_FAILED = new InstallationState(InstallationState.Status.FAILED, "modwinder.status.failed");
    public static final InstallationState INSTALLATION_COMPLETE = new InstallationState(InstallationState.Status.INSTALLED, "modwinder.status.installed", "modwinder.status.restart");
    public static final InstallationState INSTALLATION_END = new InstallationState(InstallationState.Status.INSTALLING, "modwinder.status.installing.end");
    public static final InstallationState UNINSTALLED = new InstallationState(InstallationState.Status.UNINSTALLED, "modwinder.status.uninstalled", "modwinder.status.restart");
    public static final InstallationState UNINSTALL_FAILED = new InstallationState(InstallationState.Status.FAILED, "modwinder.status.uninstalled.failed");
    public static final LocalModList LOCAL_MODS;
    public static final ModList MOD_LIST;
    private static final Executor DOWNLOAD_THREAD;
    private static final Gson GSON;
    private static final MethodHandle libraryManager$extractPacked;

    private AddonInstaller() {
    }

    public static CompletableFuture<List<File>> installLatestFromCurseforge(ModEntry mod) {
        class ParamHolder {
            private String fileName;
            private String fileId;

            ParamHolder(String fileName, String fileId) {
                this.fileName = fileName;
                this.fileId = fileId;
            }
        }
        URL apiUrl;
        try {
            apiUrl = new URL("https://curse.nikky.moe/api/addon/" + mod.getCurseId());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        mod.setInstallationState(DOWNLOAD_START);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)HTTPRequestHelper.getJSON(apiUrl).thenApply(json -> {
            for (JsonElement el : json.getAsJsonObject().get("gameVersionLatestFiles").getAsJsonArray()) {
                if (!"1.12.2".equals(el.getAsJsonObject().get("gameVersion").getAsString())) continue;
                return new ParamHolder(el.getAsJsonObject().get("projectFileName").getAsString(), el.getAsJsonObject().get("projectFileID").getAsString());
            }
            throw new InstallationException("No file has been uploaded on project " + json.getAsJsonObject().get("webSiteURL") + " for version " + "1.12.2");
        })).thenCompose(holder -> AddonInstaller.downloadFromCurseforge(mod, ((ParamHolder)holder).fileName, ((ParamHolder)holder).fileId))).thenApplyAsync(list -> list.stream().map(CompletableFuture::join).flatMap(Collection::stream).collect(Collectors.toList()), (Executor)ForkJoinPool.commonPool())).handle((result, t) -> {
            if (t != null) {
                ModWinder.LOGGER.error((Message)new FormattedMessage("Could not download latest file of {} (project {})", (Object)mod.getName(), (Object)mod.getCurseId()), t);
                mod.setInstallationState(DOWNLOAD_FAILED);
                Throwables.throwIfUnchecked((Throwable)t);
                throw new AssertionError(t);
            }
            mod.setInstallationState(INSTALLATION_COMPLETE);
            return result;
        });
    }

    public static void uninstall(ModEntry modEntry) {
        try {
            for (ModEntry dlc : modEntry.getDlcs()) {
                AddonInstaller.uninstall(dlc);
            }
            if (LOCAL_MODS.getArtifact(modEntry, MOD_LIST.getRepository()) == null) {
                ModDeleter.scheduleModDeletion(modEntry.getModId());
                if (modEntry.isInstalled()) {
                    modEntry.setInstallationState(UNINSTALLED);
                } else {
                    modEntry.setInstallationState(InstallationState.NAUGHT);
                }
                return;
            }
            List artifacts = (List)ReflectionHelper.getPrivateValue(ModList.class, (Object)MOD_LIST, (String[])new String[]{"artifacts"});
            Map art_map = (Map)ReflectionHelper.getPrivateValue(ModList.class, (Object)MOD_LIST, (String[])new String[]{"art_map"});
            artifacts.removeIf(artifact -> {
                if (artifact.matchesID(modEntry.getLocalArtifact())) {
                    art_map.remove(artifact.toString());
                    return true;
                }
                return false;
            });
            MOD_LIST.save();
            LOCAL_MODS.save();
            if (modEntry.isInstalled()) {
                modEntry.setInstallationState(UNINSTALLED);
            } else {
                modEntry.setInstallationState(InstallationState.NAUGHT);
            }
        }
        catch (Exception e) {
            ModWinder.LOGGER.error("Could not uninstall mod {} ({})", (Object)modEntry.getName(), (Object)modEntry.getModId(), (Object)e);
            modEntry.setInstallationState(UNINSTALL_FAILED);
        }
    }

    public static boolean attemptReEnabling(ModEntry modEntry) {
        try {
            if (modEntry.isDlc() && !modEntry.getParentMods().allMatch(AddonInstaller::attemptReEnabling)) {
                return false;
            }
            Artifact disabled = modEntry.getLocalArtifact();
            if (disabled == null) {
                if (Loader.isModLoaded((String)modEntry.getModId()) && !modEntry.isOutdated()) {
                    ModDeleter.cancelModDeletion(modEntry.getModId());
                    modEntry.setInstallationState(InstallationState.NAUGHT);
                    return true;
                }
                return false;
            }
            MOD_LIST.add(disabled);
            MOD_LIST.save();
            if (Loader.isModLoaded((String)modEntry.getModId()) && !modEntry.isOutdated()) {
                modEntry.setInstallationState(InstallationState.NAUGHT);
            } else {
                modEntry.setInstallationState(INSTALLATION_COMPLETE);
                ModDeleter.scheduleModDeletion(modEntry.getModId());
            }
            return true;
        }
        catch (Exception e) {
            ModWinder.LOGGER.error("Could not re-enable mod {}", (Object)modEntry.getModId(), (Object)e);
            return false;
        }
    }

    private static CompletableFuture<List<CompletableFuture<List<File>>>> downloadFromCurseforge(ModEntry mod, String fileName, @Nullable String fileId) {
        try {
            return HTTPRequestHelper.getJSON(new URL("https://curse.nikky.moe/api/addon/" + mod.getCurseId() + "/files")).thenApplyAsync(json -> {
                JsonObject fileToDownload = null;
                for (JsonElement el : json.getAsJsonArray()) {
                    String fileNameOnDisk = el.getAsJsonObject().get("fileNameOnDisk").getAsString();
                    if (!fileNameOnDisk.equals(fileName) && !el.getAsJsonObject().get("id").getAsString().equals(fileId)) continue;
                    fileToDownload = el.getAsJsonObject();
                    break;
                }
                if (fileToDownload == null) {
                    throw new InstallationException("Could not find file " + fileName + " in project " + mod.getCurseId());
                }
                ArrayList<CompletableFuture<List<File>>> downloadedFiles = new ArrayList<CompletableFuture<List<File>>>();
                AddonInstaller.installDependencies(fileToDownload, downloadedFiles);
                String downloadURL = fileToDownload.getAsJsonObject().get("downloadURL").getAsString();
                mod.setInstallationState(new InstallationState(InstallationState.Status.INSTALLING, I18n.func_135052_a((String)"modwinder.status.downloading.file", (Object[])new Object[]{fileName})));
                Path temp = HTTPRequestHelper.downloadFile(fileName, downloadURL);
                mod.setInstallationState(new InstallationState(InstallationState.Status.INSTALLING, I18n.func_135052_a((String)"modwinder.status.installing", (Object[])new Object[]{fileName})));
                File archived = AddonInstaller.moveToModRepository(temp, mod, fileName);
                if (archived != null) {
                    downloadedFiles.add(CompletableFuture.completedFuture(Collections.singletonList(archived)));
                }
                mod.setInstallationState(INSTALLATION_END);
                return downloadedFiles;
            }, DOWNLOAD_THREAD);
        }
        catch (MalformedURLException e) {
            throw new InstallationException("Invalid project id " + mod.getCurseId(), e);
        }
    }

    private static void installDependencies(JsonObject fileToDownload, List<CompletableFuture<List<File>>> downloadedFiles) {
        for (JsonElement dependency : fileToDownload.get("dependencies").getAsJsonArray()) {
            JsonObject dep = dependency.getAsJsonObject();
            if (!dep.get("type").getAsString().equals("REQUIRED")) continue;
            int depCurseId = dep.get("addOnId").getAsInt();
            ModEntry depEntry = ModWinderList.ALL.getModEntries().stream().filter(me -> me.getCurseId() == depCurseId).findAny().orElse(new DummyModEntry(depCurseId));
            if (!depEntry.getInstallationState().getStatus().canInstall(depEntry)) continue;
            downloadedFiles.add(AddonInstaller.installLatestFromCurseforge(depEntry));
        }
    }

    @Nullable
    private static File moveToModRepository(Path artifactPath, ModEntry mod, String originalName) {
        Pair<byte[], Attributes> ret = AddonInstaller.readManifestData(artifactPath);
        byte[] manifestData = (byte[])ret.getLeft();
        Attributes meta = (Attributes)ret.getRight();
        File modsDir = new File(Launch.minecraftHome, "mods/1.12.2");
        Artifact artifact = AddonInstaller.readArtifact(MOD_LIST.getRepository(), meta);
        try {
            if (artifact == null) {
                ModWinder.LOGGER.warn("{}'s Maven-Artifact attribute is absent, putting in mods", (Object)mod.getName());
                ModDeleter.scheduleModDeletion(mod.getModId());
                return Files.copy(artifactPath, modsDir.toPath().resolve(originalName), new CopyOption[0]).toFile();
            }
            if (!artifact.getFile().getParentFile().exists() && !artifact.getFile().getParentFile().mkdirs()) {
                throw new InstallationException("Could not create parent directories for " + artifact.getFile());
            }
            MOD_LIST.getRepository().archive(artifact, artifactPath.toFile(), manifestData);
            List artifacts = (List)ReflectionHelper.getPrivateValue(ModList.class, (Object)MOD_LIST, (String[])new String[]{"artifacts"});
            Map art_map = (Map)ReflectionHelper.getPrivateValue(ModList.class, (Object)MOD_LIST, (String[])new String[]{"art_map"});
            artifacts.removeIf(o -> !art_map.containsKey(o.toString()) && artifact.matchesID(o));
            ModDeleter.scheduleModDeletion(mod.getModId());
            mod.setLocalArtifact(artifact);
            LOCAL_MODS.add(mod, artifact);
            MOD_LIST.add(artifact);
            libraryManager$extractPacked.invoke(artifact.getFile(), MOD_LIST, modsDir);
            LOCAL_MODS.save();
            MOD_LIST.save();
        }
        catch (Throwable e) {
            throw new InstallationException("Could not archive downloaded mod " + (artifact != null ? artifact.getFilename() : originalName), e);
        }
        return artifact.getFile();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    private static Pair<byte[], Attributes> readManifestData(Path artifactPath) {
        try {
            byte[] data = Files.readAllBytes(artifactPath);
            try (ZipInputStream zi = new ZipInputStream(new ByteArrayInputStream(data));){
                ZipEntry ze;
                do {
                    if ((ze = zi.getNextEntry()) == null) throw new InstallationException("Could not find manifest data in downloaded file " + artifactPath.toFile().getName());
                } while (!ze.getName().equalsIgnoreCase("META-INF/MANIFEST.MF"));
                byte[] manifestData = IOUtils.toByteArray((InputStream)zi);
                Attributes meta = new Manifest(new ByteArrayInputStream(manifestData)).getMainAttributes();
                Pair pair = Pair.of((Object)manifestData, (Object)meta);
                return pair;
            }
        }
        catch (IOException e) {
            throw new InstallationException("Could not read manifest data from downloaded file " + artifactPath.toFile().getName(), e);
        }
    }

    @Nullable
    private static Artifact readArtifact(Repository repo, Attributes meta) {
        String mavenArtifact;
        String timestamp = meta.getValue(new Attributes.Name("Timestamp"));
        if (timestamp != null) {
            timestamp = SnapshotJson.TIMESTAMP.format(new Date(Long.parseLong(timestamp)));
        }
        if ((mavenArtifact = meta.getValue(new Attributes.Name("Maven-Artifact"))) == null) {
            return null;
        }
        return new Artifact(repo, mavenArtifact, timestamp);
    }

    static {
        DOWNLOAD_THREAD = Executors.newSingleThreadExecutor(r -> new Thread(r, "Ladylib Installer"));
        GSON = new GsonBuilder().setLenient().setPrettyPrinting().create();
        libraryManager$extractPacked = ReflectionUtil.findMethodHandleFromObfName(LibraryManager.class, "extractPacked", Pair.class, File.class, ModList.class, File[].class);
        Path modsPath = Paths.get("mods", "1.12.2");
        LOCAL_MODS = LocalModList.create(modsPath.resolve("modwinder_local_mods.json"));
        File modsDir = modsPath.toFile();
        File modList = new File(modsDir, "mod_list.json");
        if (!modList.exists()) {
            if (!modsDir.exists() && !modsDir.mkdir()) {
                throw new IllegalStateException("No mods directory ?!");
            }
            HashMap<String, String> baseList = new HashMap<String, String>();
            baseList.put("repositoryRoot", "mods/1.12.2");
            try {
                Files.write(modList.toPath(), GSON.toJson(baseList).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new InstallationException("Could not write base mod list", e);
            }
        }
        MOD_LIST = ModList.create((File)modList, (File)Launch.minecraftHome);
    }
}

