/*
 * Decompiled with CFR 0.152.
 */
package ladylib.modwinder.data;

import com.google.common.collect.ImmutableList;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import ladylib.modwinder.ModWinder;
import ladylib.modwinder.ModsFetchedEvent;
import ladylib.modwinder.data.ModEntry;
import ladylib.networking.http.HTTPRequestHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ModWinderList {
    public static final String LADYSNAKE = "ladysnake";
    public static final ModWinderList ALL = new ModWinderList("all", (List<ModEntry>)ImmutableList.of());
    private static final TreeMap<String, ModWinderList> ALL_LISTS = new TreeMap();
    private ImmutableList<ModEntry> list;
    private final String name;

    private ModWinderList(String name, List<ModEntry> list) {
        this.name = name;
        this.list = ImmutableList.copyOf(list);
    }

    public ImmutableList<ModEntry> getModEntries() {
        return this.list;
    }

    public String getUnlocalizedName() {
        return "modwinder.list." + this.getName().toLowerCase(Locale.ENGLISH);
    }

    public String getName() {
        return this.name;
    }

    public static void addList(String name, List<ModEntry> list) {
        ALL_LISTS.put(name, new ModWinderList(name, list));
        ModWinderList.ALL.list = (ImmutableList)ALL_LISTS.values().stream().flatMap(mwl -> mwl.list.stream()).distinct().collect(ImmutableList.toImmutableList());
    }

    public static ModWinderList getList(String name) {
        return ALL_LISTS.get(name);
    }

    public static ModWinderList getNext(ModWinderList list) {
        Map.Entry<String, ModWinderList> entry = ALL_LISTS.higherEntry(list.name);
        if (entry == null) {
            entry = ALL_LISTS.firstEntry();
        }
        return entry.getValue();
    }

    public static CompletableFuture<Map<String, List<ModEntry>>> retrieveList(URL url) {
        return ((CompletableFuture)HTTPRequestHelper.getJSON(url).thenApply(json -> {
            Type type = new TypeToken<Map<String, List<ModEntry>>>(){}.getType();
            Map retrieved = (Map)ModEntry.GSON.fromJson(json, type);
            MinecraftForge.EVENT_BUS.post((Event)new ModsFetchedEvent(url, retrieved));
            return retrieved;
        })).exceptionally(t -> {
            ModWinder.LOGGER.warn("Could not create the list of Ladysnake mods", t);
            return Collections.emptyMap();
        });
    }

    static {
        ALL_LISTS.put("all", ALL);
    }
}

