/*
 * Decompiled with CFR 0.152.
 */
package ladylib.modwinder.data;

import com.google.common.collect.ImmutableList;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import ladylib.modwinder.ModWinder;
import ladylib.modwinder.data.LocalModList;
import ladylib.modwinder.data.ModEntryTypeAdapterFactory;
import ladylib.modwinder.installer.AddonInstaller;
import ladylib.modwinder.installer.InstallationState;
import ladylib.networking.http.HTTPRequestException;
import ladylib.networking.http.HTTPRequestHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.libraries.Artifact;

public class ModEntry {
    public static final Gson GSON = new GsonBuilder().setFieldNamingStrategy((FieldNamingStrategy)FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapterFactory((TypeAdapterFactory)new ModEntryTypeAdapterFactory()).create();
    @SerializedName(value="modid")
    private String modId;
    @SerializedName(value="curseid")
    private int curseId;
    private String name;
    private String author;
    @Nullable
    private URL updateUrl;
    private List<ModEntry> dlcs;
    private transient boolean initialized;
    private transient boolean installed;
    private transient boolean outdated;
    private transient InstallationState installationState = InstallationState.NAUGHT;
    private transient String installedVersion = "";
    private transient String latestVersion = "";
    private transient ResourceLocation logoTexture;
    private transient Artifact localArtifact;
    private transient Set<ModEntry> parents = new HashSet<ModEntry>();
    private transient Map<ComparableVersion, String> changelog;

    private ModEntry() {
        this.dlcs = Collections.emptyList();
        this.setLogo(null);
    }

    public ModEntry(String modId, int curseId, String name, String author, URL updateUrl, List<ModEntry> dlcs) {
        this();
        this.modId = modId;
        this.curseId = curseId;
        this.name = name;
        this.author = author;
        this.updateUrl = updateUrl;
        this.dlcs = dlcs;
        this.init();
    }

    private synchronized void init(ModEntry parent) {
        this.parents.add(parent);
        this.init();
    }

    protected synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.setLocalArtifact(AddonInstaller.LOCAL_MODS.getArtifact(this, AddonInstaller.MOD_LIST.getRepository()));
        this.checkInstall();
        this.fetchLogo();
        this.fetchUpdateJson();
        this.initialized = true;
        this.dlcs.forEach(modEntry -> modEntry.init(this));
    }

    private void checkInstall() {
        ModContainer installedMod = (ModContainer)Loader.instance().getIndexedModList().get(this.modId);
        if (installedMod != null) {
            this.installed = true;
            this.installedVersion = installedMod.getVersion();
        } else {
            this.installedVersion = AddonInstaller.LOCAL_MODS.get(this.modId).map(LocalModList.LocalModEntry::getVersion).orElse("");
        }
    }

    private void fetchLogo() {
        URL curseApi;
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            return;
        }
        try {
            curseApi = new URL("https://curse.nikky.moe/api/addon/" + this.curseId);
        }
        catch (MalformedURLException e) {
            throw new HTTPRequestException("Invalid curse project id " + this.curseId, e);
        }
        ((CompletableFuture)((CompletableFuture)HTTPRequestHelper.getJSON(curseApi).thenApply(json -> {
            for (JsonElement attachment : json.getAsJsonObject().get("attachments").getAsJsonArray()) {
                if (!attachment.getAsJsonObject().get("default").getAsBoolean()) continue;
                return (URL)GSON.fromJson(attachment.getAsJsonObject().get("url"), URL.class);
            }
            throw new HTTPRequestException("No logo found for project " + json.getAsJsonObject().get("name"));
        })).thenAccept(logo -> {
            try {
                this.setLogo(ImageIO.read(logo));
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        })).exceptionally(t -> {
            ModWinder.LOGGER.error("Could not download logo", t);
            return null;
        });
    }

    private void fetchUpdateJson() {
        if (this.latestVersion.isEmpty() && this.getUpdateUrl() != null) {
            HTTPRequestHelper.getJSON(this.getUpdateUrl()).thenAccept(json -> {
                String latest = json.getAsJsonObject().get("promos").getAsJsonObject().get("1.12.2-latest").getAsString();
                this.setLatestVersion(latest);
                this.outdated = this.installed && new ComparableVersion(this.installedVersion).compareTo(new ComparableVersion(latest)) < 0;
                Map temp = (Map)GSON.fromJson(json.getAsJsonObject().get("1.12.2"), new TypeToken<Map<String, String>>(){}.getType());
                this.setChangelog(temp.keySet().stream().collect(Collectors.toMap(ComparableVersion::new, temp::get)));
            });
        }
    }

    @Nullable
    public synchronized Map<ComparableVersion, String> getChangelog() {
        return this.changelog;
    }

    private synchronized void setChangelog(Map<ComparableVersion, String> changelog) {
        this.changelog = changelog;
    }

    @Nullable
    public synchronized Artifact getLocalArtifact() {
        return this.localArtifact;
    }

    public synchronized void setLocalArtifact(@Nullable Artifact localArtifact) {
        this.localArtifact = localArtifact;
    }

    public boolean isDlc() {
        return !this.parents.isEmpty();
    }

    public Stream<ModEntry> getParentMods() {
        return this.parents.stream();
    }

    public boolean isOutdated() {
        return this.outdated;
    }

    public String getModId() {
        return this.modId;
    }

    public int getCurseId() {
        return this.curseId;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    @Nullable
    public URL getUpdateUrl() {
        return this.updateUrl;
    }

    public List<ModEntry> getDlcs() {
        return ImmutableList.copyOf(this.dlcs);
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public String getInstalledVersion() {
        return this.installedVersion;
    }

    public synchronized String getLatestVersion() {
        return this.latestVersion;
    }

    public synchronized void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
    }

    public synchronized InstallationState getInstallationState() {
        return this.installationState;
    }

    public synchronized void setInstallationState(InstallationState installationState) {
        this.installationState = installationState;
    }

    public ResourceLocation getLogo() {
        return this.logoTexture;
    }

    public void setLogo(@Nullable BufferedImage logo) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                DynamicTexture texture = logo == null ? TextureUtil.field_111001_a : new DynamicTexture(logo);
                this.logoTexture = Minecraft.func_71410_x().func_110434_K().func_110578_a("curse-logo-" + this.getModId(), texture);
            });
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModEntry modEntry = (ModEntry)o;
        return Objects.equals(this.modId, modEntry.modId) && Objects.equals(this.curseId, modEntry.curseId) && Objects.equals(this.name, modEntry.name) && Objects.equals(this.updateUrl, modEntry.updateUrl) && Objects.equals(this.dlcs, modEntry.dlcs);
    }

    public int hashCode() {
        return Objects.hash(this.modId, this.curseId, this.name, this.updateUrl, this.dlcs);
    }

    public String toString() {
        return this.name + "(" + this.modId + ") {" + (this.installed ? "installed," : "") + (this.outdated ? "outdated," : "") + "curseId='" + this.curseId + '\'' + ", installedVersion=" + this.installedVersion + ", latestVersion=" + this.latestVersion + '}';
    }
}

