/*
 * Decompiled with CFR 0.152.
 */
package ladylib.modwinder.data;

import com.google.gson.reflect.TypeToken;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import ladylib.LadyLib;
import ladylib.modwinder.data.ModEntry;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import net.minecraftforge.fml.relauncher.libraries.Artifact;
import net.minecraftforge.fml.relauncher.libraries.Repository;

public class LocalModList {
    private static final Map<Path, LocalModList> CACHE = new HashMap<Path, LocalModList>();
    private Map<String, LocalModEntry> allMods = new HashMap<String, LocalModEntry>();
    private transient Path saveFile;

    public static LocalModList create(Path modList) {
        return CACHE.computeIfAbsent(modList, ml -> {
            LocalModList ret = new LocalModList();
            try {
                if (ml.toFile().exists()) {
                    Type type = new TypeToken<Map<String, LocalModEntry>>(){}.getType();
                    ret.allMods = (Map)ModEntry.GSON.fromJson((Reader)Files.newBufferedReader(ml), type);
                }
            }
            catch (IOException e) {
                LadyLib.LOGGER.error("Unable to read json mod list {}", ml, (Object)e);
            }
            ret.saveFile = modList;
            return ret;
        });
    }

    private LocalModList() {
    }

    public void add(ModEntry modEntry, Artifact artifact) {
        String version = modEntry.isInstalled() ? modEntry.getInstalledVersion() : modEntry.getLatestVersion();
        this.allMods.put(modEntry.getModId(), new LocalModEntry(artifact.toString(), artifact.isSnapshot() ? artifact.getTimestamp() : null, version));
    }

    public Optional<LocalModEntry> get(String modId) {
        return Optional.ofNullable(this.allMods.get(modId));
    }

    @Nullable
    public Artifact getArtifact(ModEntry modEntry, Repository repo) {
        ComparableVersion latest = new ComparableVersion(modEntry.getLatestVersion());
        LocalModEntry disabled = this.allMods.get(modEntry.getModId());
        if (disabled == null) {
            return null;
        }
        ComparableVersion local = new ComparableVersion(disabled.version);
        if (local.compareTo(latest) < 0) {
            return null;
        }
        return new Artifact(repo, disabled.modRef, disabled.timeStamp);
    }

    public void save() throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(this.saveFile, new OpenOption[0]);){
            ModEntry.GSON.toJson(this.allMods, (Appendable)writer);
        }
    }

    public static class LocalModEntry {
        private String modRef;
        private String timeStamp;
        private String version;

        private LocalModEntry() {
        }

        public LocalModEntry(String modRef, String timeStamp, String version) {
            this();
            this.modRef = modRef;
            this.timeStamp = timeStamp;
            this.version = version;
        }

        public String getModRef() {
            return this.modRef;
        }

        public String getTimeStamp() {
            return this.timeStamp;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

