/*
 * Decompiled with CFR 0.152.
 */
package ladylib.modwinder.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ladylib.LadyLib;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import org.lwjgl.input.Mouse;

public class GuiModChangelog
extends GuiScreen {
    private static final int DONE_BUTTON_ID = 6;
    private GuiScreen previous;
    private Changelog changelogScreen;
    private Map<ComparableVersion, String> changelog;

    public GuiModChangelog(GuiScreen previous, Map<ComparableVersion, String> changelog) {
        this.previous = previous;
        this.changelog = changelog;
    }

    public void func_73866_w_() {
        this.field_146292_n.add(new GuiButton(6, this.field_146294_l / 2 - 100, this.field_146295_m - 38, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.changelogScreen = new Changelog(this.field_146294_l - 30, this.changelog);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.changelogScreen.drawScreen(mouseX, mouseY, partialTicks);
        int left = (this.field_146294_l - 38) / 2 + 30;
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"modwinder.changelog", (Object[])new Object[0]), left, 16, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        super.func_146274_d();
        this.changelogScreen.handleMouseInput(mouseX, mouseY);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 6: {
                    this.field_146297_k.func_147108_a(this.previous);
                    return;
                }
            }
            LadyLib.LOGGER.info("Unrecognized button id {} ({})", (Object)button.field_146127_k, (Object)button);
        }
        super.func_146284_a(button);
    }

    private class Changelog
    extends GuiScrollingList {
        private List<ITextComponent> lines;

        Changelog(int width, Map<ComparableVersion, String> lines) {
            super(GuiModChangelog.this.field_146297_k, width, GuiModChangelog.this.field_146295_m, 32, GuiModChangelog.this.field_146295_m - 88 + 4, 20, 60, GuiModChangelog.this.field_146294_l, GuiModChangelog.this.field_146295_m);
            this.lines = this.resizeContent(lines.entrySet().stream().sorted((v1, v2) -> ((ComparableVersion)v2.getKey()).compareTo((ComparableVersion)v1.getKey())).map(e -> e.getKey() + "\n" + (String)e.getValue() + "\n \n ").flatMap(s -> Arrays.stream(s.split("\n"))).collect(Collectors.toList()));
            this.setHeaderInfo(true, this.getHeaderHeight());
        }

        protected int getSize() {
            return 0;
        }

        protected void elementClicked(int index, boolean doubleClick) {
        }

        protected boolean isSelected(int index) {
            return false;
        }

        protected void drawBackground() {
        }

        protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
        }

        private List<ITextComponent> resizeContent(List<String> lines) {
            ArrayList<ITextComponent> ret = new ArrayList<ITextComponent>();
            for (String line : lines) {
                if (line == null) {
                    ret.add(null);
                    continue;
                }
                ITextComponent chat = ForgeHooks.newChatWithLinks((String)line, (boolean)false);
                int maxTextLength = this.listWidth - 8;
                if (maxTextLength < 0) continue;
                ret.addAll(GuiUtilRenderComponents.func_178908_a((ITextComponent)chat, (int)maxTextLength, (FontRenderer)GuiModChangelog.this.field_146289_q, (boolean)false, (boolean)true));
            }
            return ret;
        }

        private int getHeaderHeight() {
            int height = 0;
            if ((height += this.lines.size() * 10) < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        protected void drawHeader(int entryRight, int relativeY, Tessellator tess) {
            int top = relativeY;
            for (ITextComponent line : this.lines) {
                if (line != null) {
                    GlStateManager.func_179147_l();
                    GuiModChangelog.this.field_146289_q.func_175063_a(line.func_150254_d(), (float)this.left + 4.0f, (float)top, 0xFFFFFF);
                    GlStateManager.func_179118_c();
                    GlStateManager.func_179084_k();
                }
                top += 10;
            }
        }

        protected void clickHeader(int x, int y) {
            if (y <= 0) {
                return;
            }
            int lineIdx = y / 10;
            if (lineIdx >= this.lines.size()) {
                return;
            }
            ITextComponent line = this.lines.get(lineIdx);
            if (line != null) {
                int k = -4;
                for (ITextComponent part : line) {
                    if (!(part instanceof TextComponentString) || (k += GuiModChangelog.this.field_146289_q.func_78256_a(((TextComponentString)part).func_150265_g())) < x) continue;
                    GuiModChangelog.this.func_175276_a(part);
                    break;
                }
            }
        }
    }
}

