/*
 * Decompiled with CFR 0.152.
 */
package ladylib.modwinder.client.gui;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import ladylib.LadyLib;
import ladylib.misc.ReflectionUtil;
import ladylib.modwinder.ModWinder;
import ladylib.modwinder.ModsFetchedEvent;
import ladylib.modwinder.client.gui.GuiButtonModBar;
import ladylib.modwinder.client.gui.GuiInstallerModList;
import ladylib.modwinder.client.gui.GuiModChangelog;
import ladylib.modwinder.client.gui.GuiOutdatedJava;
import ladylib.modwinder.client.gui.GuiWaitingModInstall;
import ladylib.modwinder.data.ModEntry;
import ladylib.modwinder.data.ModWinderList;
import ladylib.modwinder.installer.AddonInstaller;
import ladylib.modwinder.installer.InstallationState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Mouse;

@Mod.EventBusSubscriber(modid="modwinder", value={Side.CLIENT})
public class GuiModBar
extends GuiScreen {
    private static final int MODWINDER_BUTTON_ID = 88037256;
    private static final int DONE_BUTTON_ID = 6;
    private static final int CHANGELOG_BUTTON_ID = 7;
    private static final int DESCRIPTION_BUTTON_ID = 8;
    private static final int SWITCH_LIST_BUTTON_ID = 9;
    private static final int UPDATE_ALL_BUTTON_ID = 10;
    private GuiScreen mainMenu;
    private GuiInstallerModList modList;
    private GuiButton changelogButton;
    private GuiButton descriptionButton;
    private GuiButton cycleListButton;
    private int numButtons = SortType.values().length;
    private String lastFilterText = "";
    private String tip = I18n.func_135052_a((String)"modwinder.hint", (Object[])new Object[0]);
    private List<String> hoveringText;
    private GuiTextField search;
    private boolean sorted = false;
    private SortType sortType = SortType.NORMAL;
    private ModWinderList selectedList = ModWinderList.getList("ladysnake");

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onGuiScreenInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiMainMenu) {
            List buttons = event.getButtonList();
            GuiModBar.addModBarButton(buttons);
        }
    }

    @SubscribeEvent
    public static void onModsFetched(ModsFetchedEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_152344_a(() -> {
            List buttonList;
            if (mc.field_71462_r instanceof GuiMainMenu && (buttonList = ReflectionUtil.getPrivateValue(GuiScreen.class, mc.field_71462_r, "field_146292_n", List.class)).stream().mapToInt(b -> b.field_146127_k).noneMatch(id -> id == 88037256)) {
                GuiModBar.addModBarButton(buttonList);
            }
        });
    }

    private static void addModBarButton(List<GuiButton> buttons) {
        if (ModWinderList.ALL.getModEntries().isEmpty()) {
            return;
        }
        String targetDisplayString = I18n.func_135052_a((String)"fml.menu.mods", (Object[])new Object[0]);
        buttons.stream().filter(b -> targetDisplayString.equals(b.field_146126_j)).findAny().ifPresent(target -> {
            boolean collision;
            GuiButtonModBar installer = new GuiButtonModBar(88037256, target.field_146128_h - 24, target.field_146129_i);
            List possibleCollisions = buttons.stream().filter(other -> other.field_146129_i < installer.field_146129_i + installer.field_146121_g && other.field_146129_i + other.field_146121_g > installer.field_146129_i).collect(Collectors.toList());
            do {
                collision = false;
                for (GuiButton other2 : possibleCollisions) {
                    if (other2.field_146128_h >= installer.field_146128_h + installer.field_146120_f || other2.field_146128_h + other2.field_146120_f <= installer.field_146128_h) continue;
                    installer.field_146128_h = other2.field_146128_h - installer.field_146120_f - 4;
                    collision = true;
                }
            } while (collision);
            buttons.add(installer);
        });
    }

    @SubscribeEvent
    public static void onGuiScreenActionPerformed(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (event.getGui() instanceof GuiMainMenu && event.getButton().field_146127_k == 88037256) {
            if (System.getProperty("java.version").matches("1\\.8\\.0_\\d{2}")) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiOutdatedJava(event.getGui()));
            } else {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiModBar(event.getGui()));
            }
            event.getButton().func_146113_a(Minecraft.func_71410_x().func_147118_V());
            event.setCanceled(true);
        }
    }

    public GuiModBar(GuiScreen mainMenu) {
        this.mainMenu = mainMenu;
    }

    public void func_73866_w_() {
        this.modList = new GuiInstallerModList(this, (List<ModEntry>)this.selectedList.getModEntries(), this.field_146294_l - 30, 35);
        this.field_146292_n.add(new GuiButton(6, this.field_146294_l / 2 - 100, this.field_146295_m - 38, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.changelogButton = new GuiButton(7, 3 * this.field_146294_l / 4, this.field_146295_m - 38, this.field_146294_l / 5, 20, I18n.func_135052_a((String)"modwinder.changelog", (Object[])new Object[0]));
        this.changelogButton.field_146124_l = false;
        this.field_146292_n.add(this.changelogButton);
        this.descriptionButton = new GuiButton(8, 3 * this.field_146294_l / 4, this.field_146295_m - 57, this.field_146294_l / 5, 20, I18n.func_135052_a((String)"modwinder.cf_description", (Object[])new Object[0]));
        this.descriptionButton.field_146124_l = false;
        this.field_146292_n.add(this.descriptionButton);
        this.field_146292_n.add(new GuiButton(10, this.field_146294_l / 4 - this.field_146294_l / 5, this.field_146295_m - 57, this.field_146294_l / 5, 20, I18n.func_135052_a((String)"modwinder.update_all", (Object[])new Object[0])));
        this.cycleListButton = new GuiButton(9, this.field_146294_l / 4 - this.field_146294_l / 5, this.field_146295_m - 38, this.field_146294_l / 5, 20, I18n.func_135052_a((String)this.selectedList.getUnlocalizedName(), (Object[])new Object[0]));
        this.field_146292_n.add(this.cycleListButton);
        this.search = new GuiTextField(0, this.field_146289_q, 12 + 3 * this.modList.getListWidth() / 4, this.modList.getTop() - 17, this.modList.getListWidth() / 4 - 4, 14);
        this.search.func_146195_b(true);
        this.search.func_146205_d(true);
        int width = this.modList.getListWidth() / 3 / this.numButtons;
        int x = 10;
        int y = 10;
        int buttonMargin = 1;
        GuiButton normalSort = new GuiButton(SortType.NORMAL.buttonID, x, y, width - buttonMargin, 20, I18n.func_135052_a((String)"fml.menu.mods.normal", (Object[])new Object[0]));
        normalSort.field_146124_l = false;
        this.field_146292_n.add(normalSort);
        GuiButton alphabeticalSort = new GuiButton(SortType.A_TO_Z.buttonID, x += width + buttonMargin, y, width - buttonMargin, 20, "A-Z");
        this.field_146292_n.add(alphabeticalSort);
        this.field_146292_n.add(new GuiButton(SortType.Z_TO_A.buttonID, x += width + buttonMargin, y, width - buttonMargin, 20, "Z-A"));
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        this.search.func_146192_a(x, y, button);
        if (button == 1 && x >= this.search.field_146209_f && x < this.search.field_146209_f + this.search.field_146218_h && y >= this.search.field_146210_g && y < this.search.field_146210_g + this.search.field_146219_i) {
            this.search.func_146180_a("");
        }
    }

    protected void func_73869_a(char c, int keyCode) throws IOException {
        super.func_73869_a(c, keyCode);
        this.search.func_146201_a(c, keyCode);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.search.func_146178_a();
        if (!this.search.func_146179_b().equals(this.lastFilterText) || !this.sorted) {
            this.modList.reloadMods();
            this.sorted = true;
        }
        this.lastFilterText = this.search.func_146179_b();
    }

    public String getSearchText() {
        return this.search.func_146179_b().toLowerCase(Locale.ENGLISH);
    }

    public SortType getSortType() {
        return this.sortType;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.modList.drawScreen(mouseX, mouseY, partialTicks);
        int left = (this.field_146294_l - 38) / 2 + 30;
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"modwinder.menu.title", (Object[])new Object[0]), left, 16, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String text = I18n.func_135052_a((String)"fml.menu.mods.search", (Object[])new Object[0]);
        int x = this.search.field_146209_f - 5 - this.getFontRenderer().func_78256_a(text);
        this.getFontRenderer().func_78276_b(text, x, this.search.field_146210_g + 5, 0xFFFFFF);
        this.search.func_146194_f();
        this.func_73731_b(this.field_146289_q, this.tip, this.field_146294_l - 10 - this.field_146289_q.func_78256_a(this.tip), this.field_146295_m - 10, 0xFFFF99);
        if (this.hoveringText != null) {
            GuiUtils.drawHoveringText(this.hoveringText, (int)mouseX, (int)mouseY, (int)this.field_146294_l, (int)this.field_146295_m, (int)-1, (FontRenderer)this.field_146289_q);
            this.hoveringText = null;
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            SortType type = SortType.getTypeForButton(button);
            if (type != null) {
                this.field_146292_n.stream().filter(SortType::isSortingButton).forEach(b -> {
                    b.field_146124_l = true;
                });
                button.field_146124_l = false;
                this.sorted = false;
                this.sortType = type;
            } else {
                switch (button.field_146127_k) {
                    case 6: {
                        this.exitModBar();
                        return;
                    }
                    case 7: {
                        this.displayChangelog();
                        return;
                    }
                    case 8: {
                        this.openCurseforgeDescription();
                        return;
                    }
                    case 9: {
                        this.cycleSelectedList();
                        return;
                    }
                    case 10: {
                        this.updateAll();
                        return;
                    }
                }
                LadyLib.LOGGER.warn("Unrecognized button id {} ({})", (Object)button.field_146127_k, (Object)button);
            }
        }
    }

    private void updateAll() {
        ModWinderList.ALL.getModEntries().stream().filter(ModEntry::isOutdated).forEach(AddonInstaller::installLatestFromCurseforge);
    }

    private void openCurseforgeDescription() {
        ModEntry selected = this.modList.getSelected();
        if (selected != null) {
            String cfLink = "https://minecraft.curseforge.com/projects/" + selected.getCurseId();
            try {
                this.field_175286_t = new URI(cfLink);
                GuiConfirmOpenLink link = new GuiConfirmOpenLink((GuiYesNoCallback)this, cfLink, 31102009, false);
                link.func_146358_g();
                this.field_146297_k.func_147108_a((GuiScreen)link);
            }
            catch (URISyntaxException e) {
                ModWinder.LOGGER.error("Can't open url for {}", (Object)cfLink, (Object)e);
            }
        }
    }

    private void displayChangelog() {
        ModEntry selected = this.modList.getSelected();
        if (selected != null && selected.getChangelog() != null) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiModChangelog(this, selected.getChangelog()));
        }
    }

    private void exitModBar() {
        if (ModWinderList.ALL.getModEntries().stream().map(ModEntry::getInstallationState).map(InstallationState::getStatus).anyMatch(status -> status == InstallationState.Status.INSTALLING || status == InstallationState.Status.INSTALLED)) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((confirm, i) -> {
                if (confirm) {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiWaitingModInstall(this));
                } else {
                    this.field_146297_k.func_147108_a(this.mainMenu);
                }
            }, I18n.func_135052_a((String)"modwinder.restart.1", (Object[])new Object[0]), I18n.func_135052_a((String)"modwinder.restart.2", (Object[])new Object[0]), I18n.func_135052_a((String)"modwinder.restart.yes", (Object[])new Object[0]), I18n.func_135052_a((String)"modwinder.restart.no", (Object[])new Object[0]), 6));
        } else {
            this.field_146297_k.func_147108_a(this.mainMenu);
        }
    }

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        super.func_146274_d();
        this.modList.handleMouseInput(mouseX, mouseY);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public ModWinderList getSelectedList() {
        return this.selectedList;
    }

    private void cycleSelectedList() {
        this.selectedList = ModWinderList.getNext(this.selectedList);
        if (this.selectedList.getName().equals("others")) {
            this.selectedList = ModWinderList.getNext(this.selectedList);
        }
        this.cycleListButton.field_146126_j = I18n.func_188566_a((String)this.selectedList.getUnlocalizedName()) ? I18n.func_135052_a((String)this.selectedList.getUnlocalizedName(), (Object[])new Object[0]) : this.selectedList.getName();
        this.sorted = false;
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    public void setHoveringText(String ... hoveringText) {
        this.hoveringText = Arrays.stream(hoveringText).map(x$0 -> I18n.func_135052_a((String)x$0, (Object[])new Object[0])).collect(Collectors.toList());
    }

    public void onModEntrySelected(ModEntry selected) {
        this.changelogButton.field_146124_l = selected.getChangelog() != null;
        this.descriptionButton.field_146124_l = true;
    }

    public static enum SortType implements Comparator<ModEntry>
    {
        NORMAL(24, (s1, s2) -> 0),
        A_TO_Z(25, String::compareTo),
        Z_TO_A(26, (s1, s2) -> s2.compareTo((String)s1));

        private int buttonID;
        private Comparator<String> modNameComparator;

        private SortType(int buttonID, Comparator<String> modNameComparator) {
            this.buttonID = buttonID;
            this.modNameComparator = modNameComparator;
        }

        @Nullable
        public static SortType getTypeForButton(GuiButton button) {
            for (SortType t : SortType.values()) {
                if (t.buttonID != button.field_146127_k) continue;
                return t;
            }
            return null;
        }

        public static boolean isSortingButton(GuiButton button) {
            return SortType.getTypeForButton(button) != null;
        }

        @Override
        public int compare(ModEntry o1, ModEntry o2) {
            String name1 = StringUtils.func_76338_a((String)o1.getName()).toLowerCase();
            String name2 = StringUtils.func_76338_a((String)o2.getName()).toLowerCase();
            return this.modNameComparator.compare(name1, name2);
        }
    }
}

