/*
 * Decompiled with CFR 0.152.
 */
package ladylib.modwinder.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import ladylib.client.shader.ShaderUtil;
import ladylib.modwinder.client.gui.GuiModBar;
import ladylib.modwinder.client.gui.MWShaders;
import ladylib.modwinder.data.ModEntry;
import ladylib.modwinder.installer.AddonInstaller;
import ladylib.modwinder.installer.InstallationState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.GuiScrollingList;
import org.lwjgl.input.Mouse;

public class GuiInstallerModList
extends GuiScrollingList {
    public static final ResourceLocation INSTALLATION_STATUS_ICON = new ResourceLocation("modwinder", "textures/gui/installation_status_icons.png");
    public static final ResourceLocation TRASH_ICONS = new ResourceLocation("modwinder", "textures/gui/uninstall_icons.png");
    public static final ResourceLocation VERSION_CHECK_ICONS = new ResourceLocation("forge", "textures/gui/version_check_icons.png");
    private final GuiModBar parent;
    private List<ModEntry> flattenedEntries;
    private int selectedSlot = -1;

    public GuiInstallerModList(GuiModBar parent, List<ModEntry> entries, int listWidth, int slotHeight) {
        super(Minecraft.func_71410_x(), listWidth, parent.field_146295_m, 32, parent.field_146295_m - 88 + 4, 10, slotHeight, parent.field_146294_l, parent.field_146295_m);
        this.parent = parent;
        this.flattenEntries(entries);
    }

    protected int getSize() {
        return this.flattenedEntries.size();
    }

    protected void elementClicked(int index, boolean doubleClick) {
        this.selectedSlot = index;
        ModEntry selected = this.flattenedEntries.get(index);
        this.parent.onModEntrySelected(selected);
        if (doubleClick && selected.getInstallationState().getStatus().canInstall(selected) && !AddonInstaller.attemptReEnabling(selected)) {
            AddonInstaller.installLatestFromCurseforge(selected);
            selected.getDlcs().stream().filter(ModEntry::isOutdated).forEach(AddonInstaller::installLatestFromCurseforge);
        }
    }

    protected boolean isSelected(int index) {
        return index == this.selectedSlot;
    }

    @Nullable
    public ModEntry getSelected() {
        return this.selectedSlot >= 0 ? this.flattenedEntries.get(this.selectedSlot) : null;
    }

    protected void drawBackground() {
        this.parent.func_146276_q_();
    }

    protected void drawSlot(int slotIdx, int entryRight, int slotTop, int height, Tessellator tess) {
        ModEntry entry = this.flattenedEntries.get(slotIdx);
        String name = entry.getName();
        String latestVersion = entry.getLatestVersion();
        String displayedVersion = entry.getInstalledVersion();
        String author = entry.getAuthor();
        FontRenderer font = this.parent.getFontRenderer();
        int left = this.left + 3;
        if (entry.isDlc()) {
            left += height + 5;
        }
        this.drawModIcon(slotTop, height, tess, entry, left);
        left += height + 5;
        int iconX = this.right - (height / 2 + 4 + 12);
        int iconY = slotTop + (height / 2 - 4);
        int iconWidth = 8;
        int iconHeight = 8;
        boolean flashing = (System.currentTimeMillis() / 800L & 1L) == 1L;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (entry.isInstalled() && entry.getInstallationState() == InstallationState.NAUGHT || entry.getInstallationState().getStatus() == InstallationState.Status.INSTALLED && AddonInstaller.LOCAL_MODS.getArtifact(entry, AddonInstaller.MOD_LIST.getRepository()) != null) {
            this.drawTrashCan(slotIdx, entry, iconX, iconY, 8, 8);
        }
        iconX += 12;
        int versionColor = 59090;
        if (entry.getInstallationState().getStatus().shouldDisplay()) {
            InstallationState state = entry.getInstallationState();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(INSTALLATION_STATUS_ICON);
            GlStateManager.func_179094_E();
            Gui.func_146110_a((int)iconX, (int)iconY, (float)(state.getStatus().getSheetOffset() * 8.0f), (float)(flashing ? 8.0f : 0.0f), (int)8, (int)8, (float)112.0f, (float)16.0f);
            GlStateManager.func_179121_F();
            if (this.isMouseHovering(iconX, iconY, 8, 8)) {
                this.parent.setHoveringText(state.getMessage());
            }
        } else if (!entry.isInstalled()) {
            versionColor = 0x9E9E9E;
        } else if (entry.isOutdated()) {
            versionColor = 16739840;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(VERSION_CHECK_ICONS);
            GlStateManager.func_179094_E();
            Gui.func_146110_a((int)(this.right - (height / 2 + 4)), (int)(slotTop + (height / 2 - 4)), (float)24.0f, (float)(flashing ? 8.0f : 0.0f), (int)8, (int)8, (float)64.0f, (float)16.0f);
            GlStateManager.func_179121_F();
            if (this.isMouseHovering(iconX, iconY, 8, 8)) {
                this.parent.setHoveringText(I18n.func_135052_a((String)"modwinder.status.outdated", (Object[])new Object[0]), I18n.func_135052_a((String)"modwinder.status.outdated.latest_version", (Object[])new Object[]{latestVersion}));
            }
        }
        int textY = slotTop + 2;
        font.func_78276_b(font.func_78269_a(name, this.listWidth - 10), left, slotTop + 2, 0xFFFFFF);
        if (!Strings.isNullOrEmpty((String)author)) {
            font.func_78276_b(font.func_78269_a("by " + author, this.listWidth - 10), left + font.func_78256_a(name) + 5, textY, 0x808080);
        }
        textY += 10;
        if (Strings.isNullOrEmpty((String)displayedVersion)) {
            displayedVersion = "Not Installed";
        }
        font.func_78276_b(font.func_78269_a(displayedVersion, this.listWidth - (5 + height)), left, textY, versionColor);
        textY += 10;
        if (!entry.getDlcs().isEmpty()) {
            font.func_78276_b(font.func_78269_a(I18n.func_135052_a((String)"modwinder.dlc", (Object[])new Object[]{entry.getDlcs().size()}), this.listWidth - (5 + height)), left, textY, 0xCCCCCC);
        }
        GlStateManager.func_179118_c();
    }

    private void drawTrashCan(int slotIdx, ModEntry entry, int iconX, int iconY, int iconWidth, int iconHeight) {
        float u = 3.0f;
        float v = 0.0f;
        if (this.isMouseHovering(iconX, iconY, iconWidth, iconHeight)) {
            v = 8.0f;
            if (Mouse.isButtonDown((int)0)) {
                AddonInstaller.uninstall(entry);
                this.parent.setTip(I18n.func_135052_a((String)"modwinder.hint.uninstall", (Object[])new Object[0]));
            }
        }
        if (this.isSelected(slotIdx)) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TRASH_ICONS);
            GlStateManager.func_179094_E();
            Gui.func_146110_a((int)iconX, (int)iconY, (float)(u * (float)iconWidth), (float)v, (int)iconWidth, (int)iconHeight, (float)64.0f, (float)16.0f);
            GlStateManager.func_179121_F();
        }
    }

    private boolean isMouseHovering(int iconX, int iconY, int iconWidth, int iconHeight) {
        return this.mouseX >= iconX && this.mouseX < iconX + iconWidth && this.mouseY > iconY && this.mouseY < iconY + iconHeight;
    }

    private void drawModIcon(int slotTop, int height, Tessellator tess, ModEntry entry, int left) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(entry.getLogo());
        GlStateManager.func_179141_d();
        ShaderUtil.useShader(MWShaders.ROUNDISH);
        ShaderUtil.setUniform("saturation", entry.isInstalled() ? 1.0f : 0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BufferBuilder bufferbuilder = tess.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)((float)left + 0.0f), (double)((float)slotTop + (float)height), 1.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(left + height), (double)((float)slotTop + (float)height), 1.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(left + height), (double)((float)slotTop + 0.0f), 1.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)((float)left + 0.0f), (double)((float)slotTop + 0.0f), 1.0).func_187315_a(0.0, 0.0).func_181675_d();
        tess.func_78381_a();
        ShaderUtil.revert();
    }

    protected int getContentHeight() {
        return Math.max(this.bottom - this.top, super.getContentHeight());
    }

    public int getListWidth() {
        return this.listWidth;
    }

    public void reloadMods() {
        this.flattenEntries(this.parent.getSelectedList().getModEntries().stream().filter(me -> me.getName().toLowerCase(Locale.ENGLISH).contains(this.parent.getSearchText())).sorted(this.parent.getSortType()).collect(Collectors.toList()));
    }

    private void flattenEntries(List<ModEntry> entries) {
        this.flattenedEntries = entries.stream().flatMap(me -> {
            ArrayList<ModEntry> ret = new ArrayList<ModEntry>(me.getDlcs());
            ret.sort(this.parent.getSortType());
            ret.add(0, (ModEntry)me);
            return ret.stream();
        }).collect(Collectors.toList());
    }

    public int getTop() {
        return this.top;
    }
}

