/*
 * Decompiled with CFR 0.152.
 */
package ladylib.misc;

import com.google.common.annotations.Beta;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import ladylib.LadyLib;
import ladylib.client.ItemRenderRegistrationHandler;
import ladylib.registration.BlockRegistrar;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.CustomModLoadingErrorDisplayException;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Beta
public class TemplateUtil {
    private static final ResourceLocation STUB_ITEM_MODEL = new ResourceLocation("ladylib", "models/item/sample_item.json");
    private static final ResourceLocation STUB_BLOCKSTATE = new ResourceLocation("ladylib", "blockstates/sample_blockstate.json");
    private static final String NAME_TOKEN = "@NAME@";
    private static final String DOMAIN_TOKEN = "@DOMAIN@";
    private static String srcRoot;

    private TemplateUtil() {
    }

    public static void generateStubModels(String modid, @Nullable String srcRoot) {
        if (!LadyLib.isDevEnv()) {
            return;
        }
        if (srcRoot == null) {
            srcRoot = "../src/main/resources";
        }
        TemplateUtil.srcRoot = srcRoot;
        List<String> createdModelFiles = LadyLib.INSTANCE.getItemRegistrar().getAllItems().stream().filter(item -> modid.equals(item.getRegistryName().func_110624_b())).filter(itemIn -> !(itemIn instanceof ItemBlock) && !(itemIn instanceof ItemRenderRegistrationHandler)).map(IForgeRegistryEntry.Impl::getRegistryName).map(TemplateUtil::generateItemModel).filter(Objects::nonNull).collect(Collectors.toList());
        if (!createdModelFiles.isEmpty()) {
            throw new ModelStubsCreatedPleaseRestartTheGameException(createdModelFiles);
        }
    }

    public static void generateStubBlockstates(BlockRegistrar blockRegistrar, @Nullable String srcRoot) {
        if (!LadyLib.isDevEnv()) {
            return;
        }
        if (srcRoot == null) {
            srcRoot = "../src/main/resources";
        }
        TemplateUtil.srcRoot = srcRoot;
        List<String> createdModelFiles = blockRegistrar.getAllBlocks().stream().map(IForgeRegistryEntry.Impl::getRegistryName).filter(Objects::nonNull).map(TemplateUtil::generateBlockState).filter(Objects::nonNull).collect(Collectors.toList());
        if (!createdModelFiles.isEmpty()) {
            throw new ModelStubsCreatedPleaseRestartTheGameException(createdModelFiles);
        }
    }

    @Nullable
    private static String generateItemModel(ResourceLocation loc) {
        if (!LadyLib.isDevEnv()) {
            return null;
        }
        String domain = loc.func_110624_b();
        String fileName = loc.func_110623_a() + ".json";
        String textureName = loc.func_110624_b() + ":items/" + loc.func_110623_a();
        Path modelPath = Paths.get(srcRoot, "assets", domain, "models", "item", fileName);
        return TemplateUtil.getStubModel(STUB_ITEM_MODEL, fileName, textureName, modelPath);
    }

    @Nullable
    private static String generateBlockState(ResourceLocation loc) {
        if (!LadyLib.isDevEnv()) {
            return null;
        }
        String domain = loc.func_110624_b();
        String fileName = loc.func_110623_a() + ".json";
        String textureName = loc.func_110624_b() + ":blocks/" + loc.func_110623_a();
        Path modelPath = Paths.get(srcRoot, "assets", domain, "blockstates", fileName);
        return TemplateUtil.getStubModel(STUB_BLOCKSTATE, fileName, textureName, modelPath);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private static String getStubModel(ResourceLocation stubModel, String fileName, String textureName, Path modelPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class ModelStubsCreatedPleaseRestartTheGameException
    extends CustomModLoadingErrorDisplayException {
        private final List<String> createdModelFiles;

        ModelStubsCreatedPleaseRestartTheGameException(List<String> createdModelFiles) {
            this.createdModelFiles = createdModelFiles;
        }

        public void initGui(GuiErrorScreen errorScreen, FontRenderer fontRenderer) {
        }

        public void drawScreen(GuiErrorScreen errorScreen, FontRenderer fontRenderer, int mouseRelX, int mouseRelY, float tickTime) {
            int i;
            fontRenderer.func_78276_b("The following model stub files have been generated:", 30, 10, -1);
            for (i = 0; i < this.createdModelFiles.size(); ++i) {
                String s = this.createdModelFiles.get(i);
                fontRenderer.func_78276_b(s, 5, 20 * (i + 2), -1);
            }
            fontRenderer.func_78276_b("The game should now be restarted", 30, 30 * (i + 1), -1);
        }
    }
}

