/*
 * Decompiled with CFR 0.152.
 */
package ladylib.misc;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.annotation.Nullable;
import ladylib.misc.ReflectionFailedException;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.objectweb.asm.Type;

public final class ReflectionUtil {
    private static final MethodHandles.Lookup TRUSTED_LOOKUP;

    private ReflectionUtil() {
    }

    public static Class<?> getClassForType(Type type) {
        switch (type.getSort()) {
            case 0: {
                return Void.TYPE;
            }
            case 1: {
                return Boolean.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
            case 10: {
                try {
                    return Class.forName(type.getClassName(), false, ReflectionUtil.class.getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new ReflectionHelper.UnableToFindClassException(new String[]{type.getClassName()}, (Exception)e);
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public static Method findMethodFromObfName(Class<?> clazz, String methodObfName, Class<?> returnType, Class<?> ... parameterTypes) {
        String methodDesc = Type.getMethodDescriptor((Type)Type.getType(returnType), (Type[])((Type[])Arrays.stream(parameterTypes).map(Type::getType).toArray(Type[]::new)));
        String deobfName = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(clazz.getName().replace('.', '/'), methodObfName, methodDesc);
        return ReflectionHelper.findMethod(clazz, (String)deobfName, (String)methodObfName, (Class[])parameterTypes);
    }

    public static Field findFieldFromObfName(Class<?> clazz, String fieldObfName, Class<?> type) {
        String deobfName = FMLDeobfuscatingRemapper.INSTANCE.mapFieldName(clazz.getName().replace('.', '/'), fieldObfName, Type.getType(type).getDescriptor());
        return ReflectionHelper.findField(clazz, (String[])new String[]{deobfName});
    }

    public static <C, T> T getPrivateValue(Class<C> clazz, @Nullable C instance, String fieldObfName, Class<? super T> type) {
        String deobfName = FMLDeobfuscatingRemapper.INSTANCE.mapFieldName(clazz.getName().replace('.', '/'), fieldObfName, Type.getType(type).getDescriptor());
        return (T)ReflectionHelper.getPrivateValue(clazz, instance, (String[])new String[]{deobfName});
    }

    public static <C, T> void setPrivateValue(Class<C> clazz, @Nullable C instance, String fieldObfName, Class<? super T> type, T value) {
        String deobfName = FMLDeobfuscatingRemapper.INSTANCE.mapFieldName(clazz.getName().replace('.', '/'), fieldObfName, Type.getType(type).getDescriptor());
        ReflectionHelper.setPrivateValue(clazz, instance, value, (String[])new String[]{deobfName});
    }

    public static MethodHandle findMethodHandleFromObfName(Class<?> clazz, String methodObfName, Class<?> returnType, Class<?> ... parameterTypes) {
        try {
            return MethodHandles.lookup().unreflect(ReflectionUtil.findMethodFromObfName(clazz, methodObfName, returnType, parameterTypes));
        }
        catch (IllegalAccessException e) {
            throw new ReflectionHelper.UnableToFindMethodException((Throwable)e);
        }
    }

    public static MethodHandle findGetterFromObfName(Class<?> clazz, String fieldObfName, Class<?> type) {
        try {
            return MethodHandles.lookup().unreflectGetter(ReflectionUtil.findFieldFromObfName(clazz, fieldObfName, type));
        }
        catch (IllegalAccessException e) {
            throw new ReflectionHelper.UnableToFindFieldException(new String[]{fieldObfName}, (Exception)e);
        }
    }

    public static MethodHandle findSetterFromObfName(Class<?> clazz, String fieldObfName, Class<?> type) {
        try {
            return MethodHandles.lookup().unreflectSetter(ReflectionUtil.findFieldFromObfName(clazz, fieldObfName, type));
        }
        catch (IllegalAccessException e) {
            throw new ReflectionHelper.UnableToFindFieldException(new String[]{fieldObfName}, (Exception)e);
        }
    }

    public static <T> T createFactory(Class<?> clazz, String invokedName, Class<?> lambdaType) {
        return ReflectionUtil.createFactory(clazz, invokedName, lambdaType, MethodHandles.lookup());
    }

    public static <T> T createFactory(Class<?> clazz, String invokedName, Class<?> lambdaType, MethodHandles.Lookup lookup) {
        try {
            MethodHandle handle = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE));
            CallSite metafactory = LambdaMetafactory.metafactory(lookup, invokedName, MethodType.methodType(lambdaType), MethodType.methodType(Object.class), handle, MethodType.methodType(clazz));
            return (T)metafactory.getTarget().invoke();
        }
        catch (Throwable throwable) {
            throw new UnableToGetFactoryException(throwable);
        }
    }

    public static MethodHandles.Lookup getTrustedLookup(Class clazz) {
        return TRUSTED_LOOKUP.in(clazz);
    }

    static {
        try {
            MethodHandles.Lookup original = MethodHandles.lookup();
            Field internal = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            internal.setAccessible(true);
            TRUSTED_LOOKUP = (MethodHandles.Lookup)internal.get(original);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ReflectionFailedException("Could not access trusted lookup", e);
        }
    }

    public static class UnableToGetFactoryException
    extends RuntimeException {
        public UnableToGetFactoryException(Throwable cause) {
            super(cause);
        }
    }
}

