/*
 * Decompiled with CFR 0.152.
 */
package ladylib.misc;

import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraftforge.items.ItemHandlerHelper;

public final class ItemUtil {
    private ItemUtil() {
    }

    @Nonnull
    public static NBTTagCompound getOrCreateCompound(@Nonnull ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        return nbt;
    }

    public static ItemStack turnItemIntoAnother(ItemStack fromStack, EntityLivingBase bearer, ItemStack toStack, boolean affectCreative) {
        StatBase stat;
        if (!affectCreative && bearer instanceof EntityPlayer && ((EntityPlayer)bearer).func_184812_l_()) {
            return fromStack;
        }
        fromStack.func_190918_g(toStack.func_190916_E());
        if (bearer instanceof EntityPlayer && (stat = StatList.func_188057_b((Item)fromStack.func_77973_b())) != null) {
            ((EntityPlayer)bearer).func_71029_a(stat);
        }
        if (fromStack.func_190926_b()) {
            return toStack;
        }
        if (bearer instanceof EntityPlayer) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)((EntityPlayer)bearer), (ItemStack)toStack);
        } else {
            bearer.func_70099_a(toStack, 0.0f);
        }
        return fromStack;
    }
}

