/*
 * Decompiled with CFR 0.152.
 */
package ladylib.config;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ConfigUtil {
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("(.*?)\\*");

    private ConfigUtil() {
    }

    public static Pattern wildcardToRegex(String wildcard) {
        return ConfigUtil.wildcardToRegex(wildcard, true);
    }

    public static Pattern wildcardToRegex(String wildcard, boolean allowRawRegex) {
        if (allowRawRegex && wildcard.charAt(0) == '/' && wildcard.charAt(wildcard.length() - 1) == '/') {
            return Pattern.compile(wildcard.substring(1, wildcard.length() - 1));
        }
        Matcher m = WILDCARD_PATTERN.matcher(wildcard);
        String regex = m.find() ? m.replaceAll("$1\\\\E\\\\w*\\\\Q") : wildcard;
        regex = "\\Q" + regex + "\\E";
        return Pattern.compile(regex);
    }
}

