/*
 * Decompiled with CFR 0.152.
 */
package ladylib.compat.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ladylib.LadyLib;
import ladylib.compat.EnhancedBusSubscriber;
import ladylib.compat.StateEventReceiver;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.asm.ModAnnotation;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.relauncher.Side;

public class EnhancedAutomaticEventSubscriber {
    private static final List<StateEventReceiver> STATE_EVENT_RECEIVERS = new ArrayList<StateEventReceiver>();

    public static void inject(ASMDataTable data) {
        Set targets = data.getAll(EnhancedBusSubscriber.class.getName());
        ModClassLoader mcl = Loader.instance().getModClassLoader();
        for (ASMDataTable.ASMData targ : targets) {
            try {
                List requiredModIds;
                List sidesEnum = (List)targ.getAnnotationInfo().get("side");
                if (sidesEnum != null) {
                    if (sidesEnum.stream().map(ModAnnotation.EnumHolder::getValue).map(Side::valueOf).noneMatch(arg_0 -> FMLCommonHandler.instance().getSide().equals(arg_0))) {
                        return;
                    }
                }
                if ((requiredModIds = (List)targ.getAnnotationInfo().get("value")) != null && !requiredModIds.stream().allMatch(Loader::isModLoaded)) {
                    return;
                }
                LadyLib.LOGGER.debug("Registering @EventBusSubscriber for {}", (Object)targ.getClassName());
                Class<?> subscriptionTarget = Class.forName(targ.getClassName(), true, (ClassLoader)mcl);
                Object instance = null;
                for (Field f : subscriptionTarget.getDeclaredFields()) {
                    if (!EnhancedAutomaticEventSubscriber.isInstanceField(f, subscriptionTarget)) continue;
                    f.setAccessible(true);
                    instance = f.get(null);
                    break;
                }
                if (instance == null) {
                    Constructor<?> constructor = subscriptionTarget.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    instance = constructor.newInstance(new Object[0]);
                }
                MinecraftForge.EVENT_BUS.register(instance);
                if (instance instanceof StateEventReceiver) {
                    STATE_EVENT_RECEIVERS.add((StateEventReceiver)instance);
                }
                LadyLib.LOGGER.debug("Injected @EventBusSubscriber class {}", (Object)targ.getClassName());
            }
            catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LadyLib.LOGGER.error("The class {} cannot be instantiated. Please add a valid constructor or an instance field", (Object)targ.getClassName(), (Object)e);
                throw new LoaderException((Throwable)e);
            }
            catch (ExceptionInInitializerError e) {
                LadyLib.LOGGER.error("Class {} errored during static initialization", (Object)targ.getClassName(), (Object)e);
                throw e;
            }
            catch (Throwable e) {
                LadyLib.LOGGER.error("An error occurred trying to load an EventBusSubscriber {}", (Object)targ.getClassName(), (Object)e);
                throw new LoaderException(e);
            }
        }
    }

    private static boolean isInstanceField(Field f, Class<?> subscriptionTarget) {
        return f.getName().equalsIgnoreCase("instance") && subscriptionTarget.isAssignableFrom(f.getType()) && Modifier.isStatic(f.getModifiers()) && Modifier.isFinal(f.getModifiers());
    }

    public static void redistributeEvent(FMLStateEvent event) {
        for (StateEventReceiver receiver : STATE_EVENT_RECEIVERS) {
            if (event instanceof FMLPreInitializationEvent) {
                receiver.preInit((FMLPreInitializationEvent)event);
                continue;
            }
            if (event instanceof FMLInitializationEvent) {
                receiver.init((FMLInitializationEvent)event);
                continue;
            }
            if (event instanceof FMLPostInitializationEvent) {
                receiver.postInit((FMLPostInitializationEvent)event);
                continue;
            }
            if (!(event instanceof FMLServerStartingEvent)) continue;
            receiver.serverStarting((FMLServerStartingEvent)event);
        }
    }
}

