/*
 * Decompiled with CFR 0.152.
 */
package ladylib.client.shader;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import ladylib.LadyLib;
import ladylib.client.command.ShaderReloadCommand;
import ladylib.client.lighting.FramebufferReplacement;
import ladylib.client.shader.ShaderException;
import ladylib.client.shader.ShaderPair;
import ladylib.client.shader.ShaderRegistryEvent;
import ladylib.misc.MatUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.Shader;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.shader.ShaderUniform;
import net.minecraft.command.ICommand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="ladylib")
public final class ShaderUtil {
    public static final String SHADER_LOCATION_PREFIX = "shaders/";
    private static boolean initialized = false;
    private static FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
    private static FloatBuffer buffer1 = BufferUtils.createFloatBuffer((int)16);
    private static int prevProgram = 0;
    private static int currentProgram = 0;
    private static final Object2IntMap<ResourceLocation> linkedShaders = new Object2IntOpenHashMap();
    private static final Int2ObjectMap<Object2IntMap<String>> uniformsCache = new Int2ObjectOpenHashMap();
    private static final Map<ResourceLocation, ShaderGroup> screenShaders = new HashMap<ResourceLocation, ShaderGroup>();
    private static boolean resetScreenShaders;
    private static int oldDisplayWidth;
    private static int oldDisplayHeight;

    private ShaderUtil() {
    }

    private static boolean shouldUseShaders() {
        return OpenGlHelper.field_148824_g;
    }

    public static void init() {
        if (!initialized) {
            Minecraft mc = Minecraft.func_71410_x();
            ((IReloadableResourceManager)mc.func_110442_L()).func_110542_a(ShaderUtil::loadShaders);
            ClientCommandHandler.instance.func_71560_a((ICommand)new ShaderReloadCommand());
            initialized = true;
        }
    }

    public static void useShader(ResourceLocation id) {
        ShaderUtil.useShader(linkedShaders.getInt((Object)id));
    }

    public static void useShader(int program) {
        if (!ShaderUtil.shouldUseShaders()) {
            return;
        }
        prevProgram = GlStateManager.func_187397_v((int)35725);
        OpenGlHelper.func_153161_d((int)program);
        currentProgram = program;
    }

    public static void setAttribValue(String attribName, IntConsumer operation) {
        if (!ShaderUtil.shouldUseShaders() || currentProgram == 0) {
            return;
        }
        int attrib = GL20.glGetAttribLocation((int)currentProgram, (CharSequence)attribName);
        if (attrib != -1) {
            operation.accept(attrib);
        }
    }

    public static void setUniformValue(String uniformName, IntConsumer operation) {
        if (!ShaderUtil.shouldUseShaders() || currentProgram == 0) {
            return;
        }
        int uniform = ShaderUtil.getUniform(uniformName);
        if (uniform != -1) {
            operation.accept(uniform);
        }
    }

    public static void setUniform(String uniformName, int value) {
        if (!ShaderUtil.shouldUseShaders() || currentProgram == 0) {
            return;
        }
        int uniform = ShaderUtil.getUniform(uniformName);
        if (uniform != -1) {
            GL20.glUniform1i((int)uniform, (int)value);
        }
    }

    public static void setUniform(String uniformName, float ... values) {
        if (!ShaderUtil.shouldUseShaders()) {
            return;
        }
        int uniform = ShaderUtil.getUniform(uniformName);
        if (uniform != -1) {
            switch (values.length) {
                case 1: {
                    GL20.glUniform1f((int)uniform, (float)values[0]);
                    break;
                }
                case 2: {
                    GL20.glUniform2f((int)uniform, (float)values[0], (float)values[1]);
                    break;
                }
                case 3: {
                    GL20.glUniform3f((int)uniform, (float)values[0], (float)values[1], (float)values[2]);
                    break;
                }
                case 4: {
                    GL20.glUniform4f((int)uniform, (float)values[0], (float)values[1], (float)values[2], (float)values[3]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Shader float uniforms only support between 1 and 4 values");
                }
            }
        }
    }

    public static void setUniform(String uniformName, FloatBuffer mat4) {
        if (!ShaderUtil.shouldUseShaders()) {
            return;
        }
        int uniform = ShaderUtil.getUniform(uniformName);
        if (uniform != -1) {
            GL20.glUniformMatrix4((int)uniform, (boolean)false, (FloatBuffer)mat4);
        }
    }

    private static int getUniform(String uniformName) {
        int uniform;
        Object2IntMap shaderUniformsCache = (Object2IntMap)uniformsCache.get(currentProgram);
        if (shaderUniformsCache == null) {
            shaderUniformsCache = new Object2IntOpenHashMap();
            uniformsCache.put(currentProgram, (Object)shaderUniformsCache);
        }
        if (shaderUniformsCache.containsKey((Object)uniformName)) {
            uniform = (Integer)shaderUniformsCache.get((Object)uniformName);
        } else {
            uniform = GL20.glGetUniformLocation((int)currentProgram, (CharSequence)uniformName);
            shaderUniformsCache.put((Object)uniformName, uniform);
        }
        return uniform;
    }

    public static void bindAdditionalTextures(ResourceLocation ... textures) {
        for (int i = 0; i < textures.length; ++i) {
            ResourceLocation texture = textures[i];
            GlStateManager.func_179138_g((int)(i + OpenGlHelper.field_77478_a + 2));
            Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
            ShaderUtil.setUniform("texture" + (i + 1), i + 2);
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public static int getDepthTexture() {
        return FramebufferReplacement.getMainDepthTexture();
    }

    public static FloatBuffer getTempBuffer() {
        buffer.clear();
        return buffer;
    }

    public static FloatBuffer getProjectionMatrix() {
        FloatBuffer projection = ShaderUtil.getTempBuffer();
        GL11.glGetFloat((int)2983, (FloatBuffer)projection);
        projection.rewind();
        return projection;
    }

    public static FloatBuffer getProjectionMatrixInverse() {
        FloatBuffer projection = ShaderUtil.getProjectionMatrix();
        FloatBuffer projectionInverse = buffer1;
        projectionInverse.clear();
        MatUtil.invertMat4FBFA(projectionInverse, projection);
        projection.rewind();
        projectionInverse.rewind();
        return projectionInverse;
    }

    public static FloatBuffer getModelViewMatrix() {
        FloatBuffer modelView = ShaderUtil.getTempBuffer();
        GL11.glGetFloat((int)2982, (FloatBuffer)modelView);
        modelView.rewind();
        return modelView;
    }

    public static FloatBuffer getModelViewMatrixInverse() {
        FloatBuffer modelView = ShaderUtil.getModelViewMatrix();
        FloatBuffer modelViewInverse = buffer1;
        modelViewInverse.clear();
        MatUtil.invertMat4FBFA(modelViewInverse, modelView);
        modelView.rewind();
        modelViewInverse.rewind();
        return modelViewInverse;
    }

    public static void revert() {
        ShaderUtil.useShader(prevProgram);
    }

    public static void enableScreenShader(ResourceLocation location) {
        if (ShaderUtil.shouldUseShaders() && !screenShaders.containsKey(location)) {
            try {
                Minecraft mc = Minecraft.func_71410_x();
                resetScreenShaders = true;
                screenShaders.put(location, new ShaderGroup(mc.func_110434_K(), mc.func_110442_L(), mc.func_147110_a(), location));
            }
            catch (IOException e) {
                LadyLib.LOGGER.error((Message)new FormattedMessage("Could not enable screen shader {}", (Object)location), (Throwable)e);
            }
        }
    }

    public static void disableScreenShader(ResourceLocation location) {
        if (screenShaders.containsKey(location)) {
            screenShaders.remove(location).func_148021_a();
        }
    }

    @SubscribeEvent
    public static void renderScreenShaders(RenderGameOverlayEvent.Pre event) {
        if (ShaderUtil.shouldUseShaders() && !screenShaders.isEmpty() && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            ShaderUtil.resetScreenShaders();
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            float partialTicks = event.getPartialTicks();
            screenShaders.forEach((key, shaderGroup) -> {
                GlStateManager.func_179094_E();
                ShaderUtil.setScreenUniform(key, "SystemTime", System.currentTimeMillis(), new float[0]);
                shaderGroup.func_148018_a(partialTicks);
                GlStateManager.func_179121_F();
            });
            Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
        }
    }

    public static void setScreenUniform(ResourceLocation shaderId, String uniformName, int value, int ... more) {
        ShaderGroup shaderGroup;
        if (more.length < 3) {
            int[] temp = new int[3];
            System.arraycopy(more, 0, temp, 0, more.length);
            more = temp;
        }
        if ((shaderGroup = screenShaders.get(shaderId)) != null) {
            for (Shader shader : shaderGroup.field_148031_d) {
                shader.func_148043_c().func_147984_b(uniformName).func_148083_a(value, more[0], more[1], more[2]);
            }
        }
    }

    public static void setScreenUniform(ResourceLocation shaderId, String uniformName, float value, float ... more) {
        ShaderGroup shaderGroup = screenShaders.get(shaderId);
        if (shaderGroup != null) {
            block6: for (Shader shader : shaderGroup.field_148031_d) {
                ShaderUniform uniform = shader.func_148043_c().func_147984_b(uniformName);
                switch (more.length) {
                    case 0: {
                        uniform.func_148090_a(value);
                        continue block6;
                    }
                    case 1: {
                        uniform.func_148087_a(value, more[0]);
                        continue block6;
                    }
                    case 2: {
                        uniform.func_148095_a(value, more[0], more[1]);
                        continue block6;
                    }
                    case 3: {
                        uniform.func_148081_a(value, more[0], more[1], more[2]);
                        continue block6;
                    }
                }
                throw new IllegalArgumentException("There should be between 1 and 4 values total, got " + more.length);
            }
        }
    }

    public static void setScreenSampler(ResourceLocation shaderId, String samplerName, ITextureObject texture) {
        ShaderUtil.setScreenSampler(shaderId, samplerName, (Object)texture);
    }

    public static void setScreenSampler(ResourceLocation shaderId, String samplerName, Framebuffer textureFbo) {
        ShaderUtil.setScreenSampler(shaderId, samplerName, (Object)textureFbo);
    }

    public static void setScreenSampler(ResourceLocation shaderId, String samplerName, int textureName) {
        ShaderUtil.setScreenSampler(shaderId, samplerName, (Object)textureName);
    }

    private static void setScreenSampler(ResourceLocation shaderId, String samplerName, Object texture) {
        ShaderGroup shaderGroup = screenShaders.get(shaderId);
        if (shaderGroup != null) {
            for (Shader shader : shaderGroup.field_148031_d) {
                shader.func_148043_c().func_147992_a(samplerName, texture);
            }
        }
    }

    private static void resetScreenShaders() {
        Minecraft mc = Minecraft.func_71410_x();
        if (resetScreenShaders || mc.field_71443_c != oldDisplayWidth || oldDisplayHeight != mc.field_71440_d) {
            for (ShaderGroup sg : screenShaders.values()) {
                sg.func_148026_a(mc.field_71443_c, mc.field_71440_d);
            }
            oldDisplayWidth = mc.field_71443_c;
            oldDisplayHeight = mc.field_71440_d;
            resetScreenShaders = false;
        }
    }

    public static void loadShaders(IResourceManager resourceManager) {
        if (!ShaderUtil.shouldUseShaders()) {
            return;
        }
        HashMap<ResourceLocation, ShaderPair> registeredShaders = new HashMap<ResourceLocation, ShaderPair>();
        MinecraftForge.EVENT_BUS.post((Event)new ShaderRegistryEvent(registeredShaders));
        registeredShaders.forEach((rl, sh) -> {
            try {
                int old = linkedShaders.put(rl, ShaderUtil.loadShader(resourceManager, sh.getVertex(), sh.getFragment()));
                if (old > 0) {
                    GL20.glDeleteProgram((int)old);
                }
            }
            catch (Exception e) {
                LadyLib.LOGGER.error((Message)new FormattedMessage("Could not create shader {} from vertex {} and fragment {}", new Object[]{rl, sh.getVertex(), sh.getFragment(), e}));
            }
        });
    }

    private static int loadShader(IResourceManager resourceManager, @Nullable ResourceLocation vertexLocation, @Nullable ResourceLocation fragmentLocation) throws IOException {
        String log;
        int programId = OpenGlHelper.func_153183_d();
        int vertexShaderId = 0;
        int fragmentShaderId = 0;
        if (vertexLocation != null) {
            vertexShaderId = OpenGlHelper.func_153195_b((int)OpenGlHelper.field_153209_q);
            ARBShaderObjects.glShaderSourceARB((int)vertexShaderId, (CharSequence)ShaderUtil.fromFile(resourceManager, vertexLocation));
            ARBShaderObjects.glCompileShaderARB((int)vertexShaderId);
            ARBShaderObjects.glAttachObjectARB((int)programId, (int)vertexShaderId);
            log = GL20.glGetShaderInfoLog((int)vertexShaderId, (int)1024);
            if (!log.isEmpty()) {
                LadyLib.LOGGER.error("Could not compile vertex shader " + vertexLocation + ": " + log);
            }
        }
        if (fragmentLocation != null) {
            fragmentShaderId = OpenGlHelper.func_153195_b((int)OpenGlHelper.field_153210_r);
            ARBShaderObjects.glShaderSourceARB((int)fragmentShaderId, (CharSequence)ShaderUtil.fromFile(resourceManager, fragmentLocation));
            ARBShaderObjects.glCompileShaderARB((int)fragmentShaderId);
            ARBShaderObjects.glAttachObjectARB((int)programId, (int)fragmentShaderId);
            log = GL20.glGetShaderInfoLog((int)fragmentShaderId, (int)1024);
            if (!log.isEmpty()) {
                LadyLib.LOGGER.error("Could not compile fragment shader " + fragmentLocation + ": " + log);
            }
        }
        OpenGlHelper.func_153179_f((int)programId);
        if (OpenGlHelper.func_153175_a((int)programId, (int)35714) == 0) {
            throw new ShaderException("Error linking Shader code: " + OpenGlHelper.func_153166_e((int)programId, (int)1024));
        }
        if (vertexShaderId != 0) {
            GL20.glDetachShader((int)programId, (int)vertexShaderId);
            GL20.glDeleteShader((int)vertexShaderId);
        }
        if (fragmentShaderId != 0) {
            GL20.glDetachShader((int)programId, (int)fragmentShaderId);
            GL20.glDeleteShader((int)fragmentShaderId);
        }
        if (LadyLib.isDevEnv()) {
            GL20.glValidateProgram((int)programId);
            if (OpenGlHelper.func_153175_a((int)programId, (int)35715) == 0) {
                LadyLib.LOGGER.warn("Warning validating Shader code:" + OpenGlHelper.func_153166_e((int)programId, (int)1024));
            }
        }
        return programId;
    }

    private static String fromFile(IResourceManager resourceManager, ResourceLocation fileLocation) throws IOException {
        StringBuilder source = new StringBuilder();
        try (InputStream in = resourceManager.func_110536_a(fileLocation).func_110527_b();
             BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                source.append(line).append('\n');
            }
        }
        return source.toString();
    }

    static {
        oldDisplayWidth = Minecraft.func_71410_x().field_71443_c;
        oldDisplayHeight = Minecraft.func_71410_x().field_71440_d;
    }
}

